/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.json;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import org.eclipse.epsilon.emc.json.Contained;
import org.eclipse.epsilon.emc.json.HasCreatorModel;
import org.eclipse.epsilon.emc.json.JsonModel;
import org.json.simple.JSONArray;

public class JsonModelArray
implements List<Object>,
Contained,
HasCreatorModel {
    private final JsonModel creatorModel;
    private Set<Object> containers = Collections.newSetFromMap(new IdentityHashMap());
    private JSONArray array = new JSONArray();

    public JsonModelArray() {
        this.creatorModel = null;
    }

    public JsonModelArray(JsonModel creatorModel) {
        this.creatorModel = creatorModel;
    }

    @Override
    public JsonModel getCreatorModel() {
        return this.creatorModel;
    }

    @Override
    public Set<Object> getContainers() {
        return this.containers;
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.array.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableList(this.array).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.array.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.array.toArray((Object[])a);
    }

    @Override
    public boolean add(Object e) {
        boolean ret = this.array.add(e);
        if (ret && e instanceof Contained) {
            ((Contained)e).addContainer(this);
        }
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = this.array.remove(o);
        if (ret && o instanceof Contained) {
            ((Contained)o).removeContainer(this);
        }
        return ret;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.array.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        boolean ret = false;
        for (Object object : c) {
            boolean bl = ret = this.add(object) || ret;
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        for (Object object : c) {
            if (!(object instanceof Contained)) continue;
            ((Contained)object).addContainer(this);
        }
        return this.array.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean anyRemoved = false;
        for (Object o : c) {
            if (!this.array.remove(o)) continue;
            anyRemoved = true;
            if (!(o instanceof Contained)) continue;
            ((Contained)o).removeContainer(this);
        }
        return anyRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean anyRemoved = false;
        Iterator it = this.array.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (c.contains(o)) continue;
            it.remove();
            anyRemoved = true;
            if (!(o instanceof Contained)) continue;
            ((Contained)o).removeContainer(this);
        }
        return anyRemoved;
    }

    @Override
    public void clear() {
        for (Object o : this.array) {
            if (!(o instanceof Contained)) continue;
            ((Contained)o).removeContainer(this);
        }
        this.array.clear();
    }

    @Override
    public Object get(int index) {
        return this.array.get(index);
    }

    @Override
    public Object set(int index, Object newValue) {
        Object oldValue = this.array.set(index, newValue);
        if (oldValue instanceof Contained) {
            ((Contained)oldValue).removeContainer(this);
        }
        if (newValue instanceof Contained) {
            ((Contained)newValue).addContainer(this);
        }
        return oldValue;
    }

    @Override
    public void add(int index, Object element) {
        if (element instanceof Contained) {
            ((Contained)element).addContainer(this);
        }
        this.array.add(index, element);
    }

    @Override
    public Object remove(int index) {
        Object removed = this.array.remove(index);
        if (removed instanceof Contained) {
            ((Contained)removed).removeContainer(this);
        }
        return removed;
    }

    @Override
    public int indexOf(Object o) {
        return this.array.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.array.lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return Collections.unmodifiableList(this.array).listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return Collections.unmodifiableList(this.array).listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.array).subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.array);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.array.equals(obj);
    }

    public String toString() {
        return "JsonModelArray [array=" + this.array + ", containers=" + this.containers + "]";
    }
}

