/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.internal.common.Activator;
import org.eclipse.gmf.internal.common.codegen.Messages;
import org.eclipse.gmf.internal.common.codegen.PackageReferencesCollector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class OrganizeImportsPostprocessor {
    private final boolean myRestoreExistingImports;

    public OrganizeImportsPostprocessor() {
        this(true);
    }

    public OrganizeImportsPostprocessor(boolean restoreExistingImports) {
        this.myRestoreExistingImports = restoreExistingImports;
    }

    public void organizeImports(ICompilationUnit icu, IProgressMonitor progress) throws CoreException {
        this.organizeImports(icu, null, progress);
    }

    public void organizeImports(ICompilationUnit icu, String[] declaredImportsAsStrings, IProgressMonitor progress) throws CoreException {
        Document document = new Document(icu.getBuffer().getContents());
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(icu);
        parser.setCompilerOptions(OrganizeImportsPostprocessor.createCompilerOptions("1.5"));
        CompilationUnit cu = (CompilationUnit)parser.createAST(progress);
        TextEdit importsEdit = this.organizeImports(cu, declaredImportsAsStrings, progress);
        try {
            importsEdit.apply((IDocument)document);
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getID(), 0, "Unable to apply imports text changes", (Throwable)e));
        }
        catch (MalformedTreeException ex) {
            throw new CoreException((IStatus)new Status(4, Activator.getID(), 0, "Unable to apply imports text changes", (Throwable)ex));
        }
        icu.getBuffer().setContents(document.get());
    }

    public TextEdit organizeImports(CompilationUnit astRoot, IProgressMonitor progress) throws CoreException {
        return this.organizeImports(astRoot, null, progress);
    }

    public TextEdit organizeImports(CompilationUnit astRoot, String[] declaredImports, IProgressMonitor progress) throws CoreException {
        MultiTextEdit result = new MultiTextEdit();
        HashSet<String> oldSingleImports = new HashSet<String>();
        HashSet<String> oldDemandImports = new HashSet<String>();
        List importDeclarations = astRoot.imports();
        String[] customImports = this.substract(declaredImports, importDeclarations);
        if (OrganizeImportsPostprocessor.isDebug()) {
            this.collectExistingImports(astRoot, oldSingleImports, oldDemandImports, customImports);
        }
        if (!this.checkForNoSyntaxErrors(astRoot)) {
            String location = astRoot.getJavaElement() == null ? "<undefined>" : astRoot.getJavaElement().getElementName();
            throw new CoreException((IStatus)new Status(4, Activator.getID(), 0, Messages.bind((String)Messages.organizeImportsFail, (Object)location), null));
        }
        ArrayList<Name> qualifiedTypeReferences = new ArrayList<Name>();
        ArrayList<SimpleName> simpleTypeReferences = new ArrayList<SimpleName>();
        ArrayList<String> importsAdded = new ArrayList<String>();
        PackageReferencesCollector.collect((ASTNode)astRoot, qualifiedTypeReferences, simpleTypeReferences, importsAdded);
        ImportRewrite importRewrite = this.createImportRewrite(astRoot);
        OrganizeImportsPostprocessor.copyImports(importRewrite, customImports);
        ReferencedTypesAwareImportRewriteContext context = new ReferencedTypesAwareImportRewriteContext(simpleTypeReferences, importRewrite);
        for (Name typeRef : qualifiedTypeReferences) {
            if (typeRef.isQualifiedName()) {
                QualifiedName qualifiedName = (QualifiedName)typeRef;
                SimpleName simpleName = qualifiedName.getName();
                boolean added = this.addImport(simpleName.getIdentifier(), qualifiedName.getFullyQualifiedName(), importRewrite, context, importsAdded);
                if (!added) continue;
                Name qualifier = qualifiedName.getQualifier();
                int qualifierStart = qualifier.getStartPosition();
                int simpleNameStart = simpleName.getStartPosition();
                try {
                    result.addChild((TextEdit)new ReplaceEdit(qualifierStart, simpleNameStart - qualifierStart, ""));
                    continue;
                }
                catch (MalformedTreeException e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getID(), 0, "Unable to produce correct text changes for replacing full name: " + qualifiedName, (Throwable)e));
                }
            }
            SimpleName simpleName = (SimpleName)typeRef;
            this.addImport(simpleName.getIdentifier(), simpleName.getFullyQualifiedName(), importRewrite, context, importsAdded);
        }
        TextEdit edit = importRewrite.rewriteImports(progress);
        try {
            result.addChild(edit);
        }
        catch (MalformedTreeException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getID(), 0, "Text changes conflict while organizing imports", (Throwable)e));
        }
        if (OrganizeImportsPostprocessor.isDebug()) {
            this.determineImportDifferences(importRewrite, oldSingleImports, oldDemandImports);
        }
        return result;
    }

    private static void copyImports(ImportRewrite importRewrite, String[] importsToCopy) {
        if (importsToCopy == null || importsToCopy.length == 0) {
            return;
        }
        int i = 0;
        while (i < importsToCopy.length) {
            importRewrite.addImport(importsToCopy[i]);
            ++i;
        }
    }

    private String[] substract(String[] declaredImports, List<ImportDeclaration> list) {
        if (declaredImports == null || declaredImports.length == 0) {
            return declaredImports;
        }
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(declaredImports));
        int i = 0;
        while (i < list.size()) {
            result.remove(list.get(i).getName().getFullyQualifiedName());
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean addImport(String typeName, String fullName, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context, Collection<String> importsAdded) {
        boolean resultIsOk = importRewrite.addImport(fullName, context).equals(typeName);
        if (resultIsOk && !importsAdded.contains(fullName)) {
            importsAdded.add(fullName);
        }
        return resultIsOk;
    }

    private void collectExistingImports(CompilationUnit astRoot, Set<String> oldSingleImports, Set<String> oldDemandImports, String[] declaredImports) {
        if (declaredImports != null && declaredImports.length > 0) {
            int i = 0;
            while (i < declaredImports.length) {
                String curr = declaredImports[i];
                if (curr.endsWith("*")) {
                    oldDemandImports.add(curr);
                } else {
                    oldSingleImports.add(curr);
                }
                ++i;
            }
        }
        List imports = astRoot.imports();
        int i = 0;
        while (i < imports.size()) {
            ImportDeclaration curr = (ImportDeclaration)imports.get(i);
            String id = curr.getName().getFullyQualifiedName();
            if (curr.isOnDemand()) {
                oldDemandImports.add(id);
            } else {
                oldSingleImports.add(id);
            }
            ++i;
        }
    }

    private boolean checkForNoSyntaxErrors(CompilationUnit astRoot) {
        IProblem[] problems = astRoot.getProblems();
        int i = 0;
        while (i < problems.length) {
            IProblem curr = problems[i];
            if (curr.isError() && (curr.getID() & 0x40000000) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ImportRewrite createImportRewrite(CompilationUnit astRoot) {
        return OrganizeImportsPostprocessor.configureImportRewrite(ImportRewrite.create((CompilationUnit)astRoot, (boolean)this.myRestoreExistingImports));
    }

    private static ImportRewrite configureImportRewrite(ImportRewrite rewrite) {
        IJavaProject project = rewrite.getCompilationUnit().getJavaProject();
        String order = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.importorder", (IJavaProject)project);
        rewrite.setImportOrder(order.split(";", 0));
        String thres = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.ondemandthreshold", (IJavaProject)project);
        try {
            int num = Integer.parseInt(thres);
            if (num == 0) {
                num = 1;
            }
            rewrite.setOnDemandImportThreshold(num);
        }
        catch (NumberFormatException numberFormatException) {}
        String thresStatic = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.staticondemandthreshold", (IJavaProject)project);
        try {
            int num = Integer.parseInt(thresStatic);
            if (num == 0) {
                num = 1;
            }
            rewrite.setStaticOnDemandImportThreshold(num);
        }
        catch (NumberFormatException numberFormatException) {}
        return rewrite;
    }

    private void determineImportDifferences(ImportRewrite importsStructure, Set<String> oldSingleImports, Set<String> oldDemandImports) {
        String importName;
        ArrayList<String> importsAdded = new ArrayList<String>();
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedImports()));
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedStaticImports()));
        Object[] content = oldSingleImports.toArray();
        int i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(importName)) {
                oldSingleImports.remove(importName);
            }
            ++i;
        }
        content = oldDemandImports.toArray();
        i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(String.valueOf(importName) + ".*")) {
                oldDemandImports.remove(importName);
            }
            ++i;
        }
        int fNumberOfImportsAdded = importsAdded.size();
        int fNumberOfImportsRemoved = oldSingleImports.size() + oldDemandImports.size();
        Activator.log((IStatus)new Status(1, Activator.getID(), 0, "[imports added]: " + fNumberOfImportsAdded, null));
        Activator.log((IStatus)new Status(1, Activator.getID(), 0, "[imports removed]: " + fNumberOfImportsRemoved, null));
    }

    private static boolean isDebug() {
        return Boolean.parseBoolean(Platform.getDebugOption((String)(String.valueOf(Activator.getID()) + "/debug/organizeImports")));
    }

    private static final HashMap<String, String> createCompilerOptions(String targetLevel) {
        HashMap<String, String> result = new HashMap<String, String>(JavaCore.getOptions());
        result.put("org.eclipse.jdt.core.compiler.compliance", targetLevel);
        result.put("org.eclipse.jdt.core.compiler.source", targetLevel);
        result.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetLevel);
        return result;
    }

    private class ReferencedTypesAwareImportRewriteContext
    extends ImportRewrite.ImportRewriteContext {
        private Collection<SimpleName> mySimpleTypesReferenced;
        private ImportRewrite myImportRewrite;

        public ReferencedTypesAwareImportRewriteContext(Collection<SimpleName> simpleTypesReferenced, ImportRewrite importRewrite) {
            this.mySimpleTypesReferenced = simpleTypesReferenced;
            this.myImportRewrite = importRewrite;
        }

        public int findInContext(String qualifier, String name, int kind) {
            int result = this.myImportRewrite.getDefaultImportRewriteContext().findInContext(qualifier, name, kind);
            if (result == 2) {
                for (SimpleName next : this.mySimpleTypesReferenced) {
                    if (!name.equals(next.getIdentifier())) continue;
                    return 3;
                }
            }
            return result;
        }
    }
}

