/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.equinox.internal.transforms.Pipe;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XSLTStreamTransformer {
    protected EntityResolver resolver = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    };
    private ServiceTracker logTracker;
    private static final Map templateMap = new HashMap();

    public XSLTStreamTransformer(ServiceTracker logTracker) {
        this.logTracker = logTracker;
    }

    public InputStream getInputStream(InputStream inputStream, URL transformerUrl) throws IOException {
        Templates template = this.getTemplate(transformerUrl);
        if (template != null) {
            Transformer transformer = null;
            try {
                transformer = template.newTransformer();
                XSLTPipe pipe = new XSLTPipe(inputStream, transformer);
                return pipe.getPipedInputStream();
            }
            catch (TransformerConfigurationException e) {
                this.log(2, "Could not perform transform.", e);
            }
        }
        return null;
    }

    private synchronized Templates getTemplate(URL transformerURL) {
        Templates templates = null;
        SoftReference<Templates> templatesRef = (SoftReference<Templates>)templateMap.get(transformerURL);
        if (templatesRef != null) {
            templates = (Templates)templatesRef.get();
        }
        if (templates != null) {
            return templates;
        }
        try {
            InputStream xsltStream = transformerURL.openStream();
            TransformerFactory tFactory = null;
            try {
                tFactory = TransformerFactory.newInstance();
                InputSource inputSource = new InputSource(xsltStream);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                if (this.resolver != null) {
                    reader.setEntityResolver(this.resolver);
                } else {
                    reader.setFeature("http://xml.org/sax/features/validation", false);
                }
                SAXSource xsltSource = new SAXSource(reader, inputSource);
                try {
                    templates = tFactory.newTemplates(xsltSource);
                    templatesRef = new SoftReference<Templates>(templates);
                    templateMap.put(transformerURL, templatesRef);
                }
                catch (Exception e) {
                    this.log(16, "Could not create transform template: " + transformerURL.toString(), e);
                }
            }
            catch (TransformerFactoryConfigurationError e) {
                this.log(16, "Could not create transformer factory.  No transforms will be invoked.", e);
            }
            catch (SAXException e) {
                this.log(16, "Could not create XML reader.  No transforms will be invoked.", e);
            }
        }
        catch (IOException e) {
            this.log(16, "General IO Exception creating templates.", e);
        }
        return templates;
    }

    void log(int severity, String msg, Throwable t) {
        FrameworkLog log = (FrameworkLog)this.logTracker.getService();
        if (log == null) {
            if (msg != null) {
                System.err.println(msg);
            }
            if (t != null) {
                t.printStackTrace();
            }
            return;
        }
        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.equinox.transforms.xslt", severity, 0, msg, 0, t, null);
        log.log(entry);
    }

    class XSLTPipe
    extends Pipe {
        private Transformer transformer;

        public XSLTPipe(InputStream original, Transformer transformer) throws IOException {
            super(original);
            this.transformer = transformer;
        }

        protected void pipeInput(InputStream original, OutputStream result) throws IOException {
            try {
                InputSource streamSource = new InputSource(original);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                if (XSLTStreamTransformer.this.resolver != null) {
                    reader.setEntityResolver(XSLTStreamTransformer.this.resolver);
                } else {
                    reader.setFeature("http://xml.org/sax/features/validation", false);
                }
                SAXSource saxSource = new SAXSource(reader, streamSource);
                this.transformer.transform(saxSource, new StreamResult(result));
            }
            catch (TransformerException e) {
                XSLTStreamTransformer.this.log(2, "Could not perform transform.", e);
                throw new IOException(e.getMessage());
            }
            catch (SAXException e) {
                XSLTStreamTransformer.this.log(2, "Problem parsing transform.", e);
                throw new IOException(e.getMessage());
            }
        }
    }
}

