/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.coordinator;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

final class SignerProperty {
    private final Bundle bundle;
    private final String pattern;

    public SignerProperty(String pattern) {
        this.pattern = pattern;
        this.bundle = null;
    }

    SignerProperty(Bundle bundle) {
        this.bundle = bundle;
        this.pattern = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SignerProperty)) {
            return false;
        }
        SignerProperty other = (SignerProperty)o;
        Bundle matchBundle = this.bundle != null ? this.bundle : other.bundle;
        String matchPattern = this.bundle != null ? other.pattern : this.pattern;
        Map signers = matchBundle.getSignerCertificates(2);
        Iterator iterator = signers.values().iterator();
        while (iterator.hasNext()) {
            List signerCerts = (List)iterator.next();
            ArrayList<String> dnChain = new ArrayList<String>(signerCerts.size());
            Iterator iterator2 = signerCerts.iterator();
            while (iterator2.hasNext()) {
                X509Certificate signerCert = (X509Certificate)iterator2.next();
                dnChain.add(signerCert.getSubjectDN().getName());
            }
            try {
                if (!FrameworkUtil.matchDistinguishedNameChain((String)matchPattern, dnChain)) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    boolean isBundleSigned() {
        if (this.bundle == null) {
            return false;
        }
        Map signers = this.bundle.getSignerCertificates(2);
        return !signers.isEmpty();
    }
}

