/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.initializer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.initializer.Activator;
import org.eclipse.equinox.internal.initializer.Messages;
import org.eclipse.osgi.util.NLS;

public class Initializer
implements IPlatformRunnable {
    public static final String PT_INITIALIZERS = "initializers";
    public static final String PI_INITIALIZER = "org.eclipse.equinox.initializer";

    public Object run(Object args) throws Exception {
        IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint(PI_INITIALIZER, PT_INITIALIZERS);
        if (xpt == null) {
            return IPlatformRunnable.EXIT_OK;
        }
        IExtension[] exts = xpt.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            IPlatformRunnable initializer = null;
            if (configs.length != 0) {
                try {
                    initializer = (IPlatformRunnable)configs[0].createExecutableExtension("initialize");
                    initializer.run(args);
                }
                catch (CoreException e) {
                    String msg = NLS.bind((String)Messages.initializer_error, (Object)exts[i].getExtensionPointUniqueIdentifier());
                    Status status = new Status(4, PI_INITIALIZER, 2, msg, (Throwable)e);
                    Activator.log((IStatus)status);
                    return null;
                }
            }
            ++i;
        }
        return IPlatformRunnable.EXIT_OK;
    }
}

