/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.net.URLConnection;
import java.util.Properties;
import org.eclipse.equinox.internal.transforms.TransformInstanceListData;
import org.eclipse.equinox.internal.transforms.TransformedBundleFile;
import org.eclipse.equinox.internal.transforms.TransformerList;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class TransformerHook
implements BundleFileWrapperFactoryHook,
HookConfigurator,
AdaptorHook {
    private TransformerList transformers;
    private TransformInstanceListData templates;
    private static BaseAdaptor ADAPTOR;

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) throws IOException {
        if (this.transformers == null || this.templates == null) {
            return null;
        }
        return new TransformedBundleFile(this.transformers, this.templates, data, bundleFile);
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook((AdaptorHook)this);
        hookRegistry.addBundleFileWrapperFactoryHook((BundleFileWrapperFactoryHook)this);
    }

    public void addProperties(Properties properties) {
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        try {
            this.transformers = new TransformerList(context);
        }
        catch (InvalidSyntaxException e) {
            throw new BundleException("Problem registering service tracker: transformers", (Throwable)e);
        }
        try {
            this.templates = new TransformInstanceListData(context);
        }
        catch (InvalidSyntaxException e) {
            this.transformers.close();
            this.transformers = null;
            throw new BundleException("Problem registering service tracker: templates", (Throwable)e);
        }
    }

    public void frameworkStop(BundleContext context) {
        this.transformers.close();
        this.templates.close();
    }

    protected BundleContext getContext() {
        return ADAPTOR.getContext();
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void handleRuntimeError(Throwable error) {
    }

    public void initialize(BaseAdaptor adaptor) {
        ADAPTOR = adaptor;
    }

    public URLConnection mapLocationToURLConnection(String location) {
        return null;
    }

    public boolean matchDNChain(String pattern, String[] dnChain) {
        return false;
    }

    static void log(int severity, String msg, Throwable t) {
        if (ADAPTOR == null) {
            System.err.println(msg);
            t.printStackTrace();
            return;
        }
        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", severity, 0, msg, 0, t, null);
        ADAPTOR.getFrameworkLog().log(entry);
    }
}

