/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.statushandlers.StatusManager;

public class GlobalBuildAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private int buildType;
    private IWorkbenchWindow workbenchWindow;

    public GlobalBuildAction(IWorkbench workbench, Shell shell, int type) {
        this(workbench.getActiveWorkbenchWindow(), type);
        Assert.isNotNull((Object)shell);
    }

    public GlobalBuildAction(IWorkbenchWindow window, int type) {
        Assert.isNotNull((Object)window);
        this.workbenchWindow = window;
        this.setBuildType(type);
    }

    private void setBuildType(int type) {
        switch (type) {
            case 9: 
            case 10: {
                this.setText(IDEWorkbenchMessages.GlobalBuildAction_text);
                this.setToolTipText(IDEWorkbenchMessages.GlobalBuildAction_toolTip);
                this.setId("build");
                this.workbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.global_incremental_build_action_context");
                this.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC"));
                this.setDisabledImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC_DISABLED"));
                this.setActionDefinitionId("org.eclipse.ui.project.buildAll");
                break;
            }
            case 6: {
                this.setText(IDEWorkbenchMessages.GlobalBuildAction_rebuildText);
                this.setToolTipText(IDEWorkbenchMessages.GlobalBuildAction_rebuildToolTip);
                this.setId("rebuildAll");
                this.workbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.global_full_build_action_context");
                this.setActionDefinitionId("org.eclipse.ui.project.rebuildAll");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid build type");
            }
        }
        this.buildType = type;
    }

    private Shell getShell() {
        return this.workbenchWindow.getShell();
    }

    private String getOperationMessage() {
        if (this.buildType == 10) {
            return IDEWorkbenchMessages.GlobalBuildAction_buildOperationTitle;
        }
        return IDEWorkbenchMessages.GlobalBuildAction_rebuildAllOperationTitle;
    }

    public void doBuild() {
        this.doBuildOperation();
    }

    void doBuildOperation() {
        Job buildJob = new Job(IDEWorkbenchMessages.GlobalBuildAction_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(GlobalBuildAction.this.getOperationMessage(), 100);
                try {
                    try {
                        ResourcesPlugin.getWorkspace().build(GlobalBuildAction.this.buildType, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }
        };
        buildJob.setUser(true);
        buildJob.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        buildJob.schedule();
    }

    IProject[] getWorkspaceProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        IProject[] roots = this.getWorkspaceProjects();
        if (roots.length < 1) {
            return;
        }
        if (!this.verifyBuildersAvailable(roots)) {
            return;
        }
        if (!this.verifyNoManualRunning()) {
            return;
        }
        BuildUtilities.saveEditors(null);
        this.doBuildOperation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean verifyBuildersAvailable(IProject[] roots) {
        try {
            int i = 0;
            while (true) {
                if (i >= roots.length) {
                    return false;
                }
                if (roots[i].isAccessible() && roots[i].getDescription().getBuildSpec().length > 0) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "org.eclipse.ui.ide");
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.GlobalBuildAction_buildProblems, (String)NLS.bind((String)IDEWorkbenchMessages.GlobalBuildAction_internalError, (Object)e.getMessage()), (IStatus)e.getStatus());
            return false;
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }

    private boolean verifyNoManualRunning() {
        Job[] buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        if (buildJobs.length == 0) {
            return true;
        }
        boolean cancel = MessageDialog.openQuestion((Shell)this.getShell(), (String)IDEWorkbenchMessages.GlobalBuildAction_BuildRunningTitle, (String)IDEWorkbenchMessages.GlobalBuildAction_BuildRunningMessage);
        if (cancel) {
            int i = 0;
            while (i < buildJobs.length) {
                Job job = buildJobs[i];
                job.cancel();
                ++i;
            }
        }
        return false;
    }
}

