/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.filetransfer.events.socketfactory.INonconnectedSocketFactory;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketEventCreateUtil;

public class ECFHttpClientProtocolSocketFactory
implements ProtocolSocketFactory {
    protected ISocketEventSource source;
    private INonconnectedSocketFactory unconnectedFactory;
    private ISocketListener socketConnectListener;
    private static final ISocketListener NULL_SOCKET_EVENT_LISTENER = new ISocketListener(){

        public void handleSocketEvent(ISocketEvent event) {
        }
    };
    static /* synthetic */ Class class$0;

    public ECFHttpClientProtocolSocketFactory(INonconnectedSocketFactory unconnectedFactory, ISocketEventSource source, ISocketListener socketConnectListener) {
        Assert.isNotNull((Object)unconnectedFactory);
        Assert.isNotNull((Object)source);
        this.unconnectedFactory = unconnectedFactory;
        this.source = source;
        this.socketConnectListener = socketConnectListener != null ? socketConnectListener : NULL_SOCKET_EVENT_LISTENER;
    }

    public ECFHttpClientProtocolSocketFactory(final SocketFactory socketFactory, ISocketEventSource source, ISocketListener socketConnectListener) {
        this(new INonconnectedSocketFactory(){

            public Socket createSocket() throws IOException {
                return socketFactory.createSocket();
            }
        }, source, socketConnectListener);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        InetSocketAddress remoteInetAddress = new InetSocketAddress(host, port);
        InetSocketAddress localInetAddress = new InetSocketAddress(clientHost, clientPort);
        return this.createSocket(remoteInetAddress, localInetAddress, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, SocketTimeoutException {
        InetSocketAddress remoteInetAddress = new InetSocketAddress(host, port);
        InetSocketAddress localInetAddress = new InetSocketAddress(localAddress, localPort);
        return this.createSocket(remoteInetAddress, localInetAddress, params);
    }

    private Socket createSocket(InetSocketAddress remoteInetAddress, InetSocketAddress localInetAddress, HttpConnectionParams params) throws IOException, UnknownHostException, SocketTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        return this.createSocket(remoteInetAddress, localInetAddress, timeout);
    }

    protected Socket createSocket() throws IOException {
        return this.unconnectedFactory.createSocket();
    }

    private Socket createSocket(InetSocketAddress remoteInetAddress, InetSocketAddress localInetAddress, int timeout) throws IOException {
        return SocketEventCreateUtil.createSocket((ISocketListener)this.socketConnectListener, (ISocketEventSource)this.source, (INonconnectedSocketFactory)this.unconnectedFactory, (InetSocketAddress)remoteInetAddress, (InetSocketAddress)localInetAddress, (int)timeout);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetSocketAddress remoteInetAddress = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
        InetSocketAddress localInetAddress = new InetSocketAddress(0);
        return this.createSocket(remoteInetAddress, localInetAddress, 0);
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ecf.internal.provider.filetransfer.httpclient.ECFHttpClientProtocolSocketFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.provider.filetransfer.httpclient.ECFHttpClientProtocolSocketFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.hashCode();
    }
}

