/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.HttpListener;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class HttpService
implements org.osgi.service.http.HttpService {
    private HttpListener listener;
    private Bundle bundle;

    HttpService(HttpListener listener, Bundle bundle) {
        this.listener = listener;
        this.bundle = bundle;
    }

    void destroy() {
        this.listener.destroyBundle(this.bundle);
        this.listener = null;
        this.bundle = null;
    }

    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        HttpListener tempListener = this.listener;
        if (tempListener != null) {
            if (httpContext == null) {
                httpContext = this.createDefaultHttpContext();
            }
            tempListener.registerResources(this.bundle, alias, name, httpContext);
        }
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException, IllegalArgumentException {
        HttpListener tempListener = this.listener;
        if (tempListener != null) {
            if (httpContext == null) {
                httpContext = this.createDefaultHttpContext();
            }
            tempListener.registerServlet(this.bundle, alias, servlet, initparams, httpContext);
        }
    }

    public void unregister(String alias) throws IllegalArgumentException {
        HttpListener tempListener = this.listener;
        if (tempListener != null) {
            tempListener.unregister(this.bundle, alias);
        }
    }

    public HttpContext createDefaultHttpContext() {
        HttpListener tempListener = this.listener;
        if (tempListener != null) {
            return tempListener.createDefaultHttpContext(this.bundle);
        }
        return null;
    }
}

