/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.jmx.internal;

import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.jmx.common.ContributionNotificationEvent;
import org.eclipse.equinox.jmx.server.Contribution;
import org.eclipse.equinox.jmx.server.ContributionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.jmx.internal.Activator;
import org.eclipse.swt.jmx.internal.SleakMessages;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class SleakContributionProvider
extends ContributionProvider {
    private static int DEFAULT_REFRESH_INTERVAL = 10000;
    private static final String SLEAK_IMG_PATH = "icons/sleak.png";
    private int colors;
    private int cursors;
    private int fonts;
    private int gcs;
    private int images;
    private int regions;
    private boolean started;
    private int refreshInterval = DEFAULT_REFRESH_INTERVAL;
    private Object mutex = new Object();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SleakContributionProvider() {
        new Sleak().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mutex;
        synchronized (object) {
            this.started = true;
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.started = false;
        }
    }

    public void setPollInterval(Integer interval) {
        this.refreshInterval = interval;
    }

    protected boolean contributesType(Object obj) {
        return false;
    }

    protected boolean providesType(Object obj) {
        return false;
    }

    protected ContributionProvider createProvider(Object obj) {
        return null;
    }

    protected Contribution createContribution(Object obj) throws MalformedObjectNameException {
        return null;
    }

    protected String getName() {
        return SleakMessages.name;
    }

    protected Object[] getChildren() {
        return null;
    }

    protected Set getProperties() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(String.valueOf(SleakMessages.colors) + " " + this.colors);
        result.add(String.valueOf(SleakMessages.cursors) + " " + this.cursors);
        result.add(String.valueOf(SleakMessages.fonts) + " " + this.fonts);
        result.add(String.valueOf(SleakMessages.gcs) + " " + this.gcs);
        result.add(String.valueOf(SleakMessages.images) + " " + this.images);
        result.add(String.valueOf(SleakMessages.regions) + " " + this.regions);
        return result;
    }

    protected URL getImageLocation() {
        return FileLocator.find((Bundle)Activator.getBundle(), (IPath)new Path(SLEAK_IMG_PATH), null);
    }

    protected MBeanInfo getMBeanInfo(Object delegate) {
        MBeanOperationInfo[] ops = new MBeanOperationInfo[]{SleakContributionProvider.createStartOperation(), SleakContributionProvider.createStopOperation(), SleakContributionProvider.createSetPollIntervalOperation()};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.jmx.internal.SleakContributionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new MBeanInfo(clazz.getName(), SleakMessages.description, null, null, ops, null);
    }

    protected Object invokeOperation(String operationName, Object[] args, String[] argTypes) {
        if (operationName.equals("start")) {
            this.start();
        } else if (operationName.equals("stop")) {
            this.stop();
        } else if (operationName.equals("setPollInterval") && args.length == 1 && args[0] instanceof Integer) {
            try {
                this.setPollInterval((Integer)args[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    private static MBeanOperationInfo createStartOperation() {
        return new MBeanOperationInfo("start", SleakMessages.start_monitoring, new MBeanParameterInfo[0], Void.TYPE.getName(), 0);
    }

    private static MBeanOperationInfo createStopOperation() {
        return new MBeanOperationInfo("stop", SleakMessages.stop_monitoring, new MBeanParameterInfo[0], Void.TYPE.getName(), 0);
    }

    private static MBeanOperationInfo createSetPollIntervalOperation() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.jmx.internal.SleakContributionProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            return new MBeanOperationInfo(SleakMessages.poll_interval_desc, clazz.getMethod("setPollInterval", classArray));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class Sleak
    extends Thread {
        Object[] oldObjects = new Object[0];
        Object[] objects = new Object[0];
        Error[] errors = new Error[0];
        ContributionNotificationEvent event = new ContributionNotificationEvent("contribution.updated");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = SleakContributionProvider.this.mutex;
                synchronized (object) {
                    try {
                        if (!SleakContributionProvider.this.started) {
                            SleakContributionProvider.this.mutex.wait();
                        }
                        this.refreshDifference();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    SleakContributionProvider.this.contributionStateChanged(this.event);
                    Thread.sleep(SleakContributionProvider.this.refreshInterval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        void refreshCounters() {
            SleakContributionProvider.this.regions = 0;
            SleakContributionProvider.this.images = 0;
            SleakContributionProvider.this.gcs = 0;
            SleakContributionProvider.this.fonts = 0;
            SleakContributionProvider.this.cursors = 0;
            SleakContributionProvider.this.colors = 0;
            int i = 0;
            while (i < this.objects.length) {
                Object object = this.objects[i];
                if (object instanceof Color) {
                    SleakContributionProvider sleakContributionProvider = SleakContributionProvider.this;
                    sleakContributionProvider.colors = sleakContributionProvider.colors + 1;
                }
                if (object instanceof Cursor) {
                    SleakContributionProvider sleakContributionProvider = SleakContributionProvider.this;
                    sleakContributionProvider.cursors = sleakContributionProvider.cursors + 1;
                }
                if (object instanceof Font) {
                    SleakContributionProvider sleakContributionProvider = SleakContributionProvider.this;
                    sleakContributionProvider.fonts = sleakContributionProvider.fonts + 1;
                }
                if (object instanceof GC) {
                    SleakContributionProvider sleakContributionProvider = SleakContributionProvider.this;
                    sleakContributionProvider.gcs = sleakContributionProvider.gcs + 1;
                }
                if (object instanceof Image) {
                    SleakContributionProvider sleakContributionProvider = SleakContributionProvider.this;
                    sleakContributionProvider.images = sleakContributionProvider.images + 1;
                }
                if (object instanceof Region) {
                    SleakContributionProvider sleakContributionProvider = SleakContributionProvider.this;
                    sleakContributionProvider.regions = sleakContributionProvider.regions + 1;
                }
                ++i;
            }
        }

        void refreshDifference() {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(this, display){
                final /* synthetic */ Sleak this$1;
                private final /* synthetic */ Display val$display;
                {
                    this.this$1 = sleak;
                    this.val$display = display;
                }

                public void run() {
                    DeviceData info = this.val$display.getDeviceData();
                    if (!info.tracking) {
                        return;
                    }
                    Object[] newObjects = info.objects;
                    Error[] newErrors = info.errors;
                    Object[] diffObjects = new Object[newObjects.length];
                    Error[] diffErrors = new Error[newErrors.length];
                    int count = 0;
                    int i = 0;
                    while (i < newObjects.length) {
                        int index = 0;
                        while (index < this.this$1.oldObjects.length) {
                            if (newObjects[i] == this.this$1.oldObjects[index]) break;
                            ++index;
                        }
                        if (index == this.this$1.oldObjects.length) {
                            diffObjects[count] = newObjects[i];
                            diffErrors[count] = newErrors[i];
                            ++count;
                        }
                        ++i;
                    }
                    this.this$1.objects = new Object[count];
                    this.this$1.errors = new Error[count];
                    System.arraycopy(diffObjects, 0, this.this$1.objects, 0, count);
                    System.arraycopy(diffErrors, 0, this.this$1.errors, 0, count);
                    this.this$1.refreshCounters();
                }
            });
        }
    }
}

