/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.BundleCachingService;
import org.eclipse.equinox.weaving.internal.caching.CacheItem;
import org.eclipse.equinox.weaving.internal.caching.CacheWriter;
import org.eclipse.equinox.weaving.internal.caching.Log;
import org.eclipse.equinox.weaving.internal.caching.UnchangedCachingService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class CachingServiceFactory
implements ICachingServiceFactory {
    private final Map<String, ICachingService> bundleCachingServices = new HashMap<String, ICachingService>();
    private final BundleContext bundleContext;
    private final BlockingQueue<CacheItem> cacheQueue;
    private final CacheWriter cacheWriter;

    public CachingServiceFactory(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument \"bundleContext\" must not be null!");
        }
        this.bundleContext = bundleContext;
        this.cacheQueue = new ArrayBlockingQueue<CacheItem>(5000);
        this.cacheWriter = new CacheWriter(this.cacheQueue);
        this.cacheWriter.start();
        this.bundleContext.addBundleListener((BundleListener)new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 16) {
                    CachingServiceFactory.this.stopBundleCachingService(event);
                } else if (event.getType() == 8) {
                    CachingServiceFactory.this.stopBundleCachingService(event);
                }
            }
        });
    }

    public synchronized ICachingService createCachingService(ClassLoader classLoader, Bundle bundle, String key) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument \"bundle\" must not be null!");
        }
        String cacheId = this.getCacheId(bundle);
        Object bundleCachingService = this.bundleCachingServices.get(cacheId);
        if (bundleCachingService == null) {
            bundleCachingService = key != null && key.length() > 0 ? new BundleCachingService(this.bundleContext, bundle, key, this.cacheQueue) : new UnchangedCachingService();
            this.bundleCachingServices.put(cacheId, (ICachingService)bundleCachingService);
            if (Log.isDebugEnabled()) {
                Log.debug(MessageFormat.format("Created BundleCachingService for [{0}].", cacheId));
            }
        }
        return bundleCachingService;
    }

    public String getCacheId(Bundle bundle) {
        String bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
        if (bundleVersion == null || bundleVersion.length() == 0) {
            bundleVersion = "0.0.0";
        }
        return String.valueOf(bundle.getSymbolicName()) + "_" + bundleVersion;
    }

    public synchronized void stop() {
        for (ICachingService bundleCachingService : this.bundleCachingServices.values()) {
            bundleCachingService.stop();
        }
        this.bundleCachingServices.clear();
        this.cacheWriter.stop();
    }

    protected void stopBundleCachingService(BundleEvent event) {
        String cacheId = this.getCacheId(event.getBundle());
        ICachingService bundleCachingService = this.bundleCachingServices.get(cacheId);
        if (bundleCachingService != null) {
            bundleCachingService.stop();
            this.bundleCachingServices.remove(cacheId);
        }
    }
}

