/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;

public class FileTreeContentProvider
implements ITreeContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private AbstractTextSearchResult fResult;
    private FileSearchPage fPage;
    private AbstractTreeViewer fTreeViewer;
    private Map<Object, Set<Object>> fChildrenMap;

    FileTreeContentProvider(FileSearchPage page, AbstractTreeViewer viewer) {
        this.fPage = page;
        this.fTreeViewer = viewer;
        this.fChildrenMap = new HashMap<Object, Set<Object>>();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    private int getElementLimit() {
        return this.fPage.getElementLimit();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof FileSearchResult) {
            this.initialize((FileSearchResult)newInput);
        }
    }

    private synchronized void initialize(AbstractTextSearchResult result) {
        boolean showLineMatches;
        this.fResult = result;
        this.fChildrenMap = new HashMap<Object, Set<Object>>();
        boolean bl = showLineMatches = !((FileSearchQuery)this.fResult.getQuery()).isFileNameSearch();
        if (result != null) {
            Object[] elements;
            Object[] objectArray = elements = result.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (showLineMatches) {
                    Match[] matches;
                    Match[] matchArray = matches = result.getMatches(element);
                    int n3 = matches.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Match match = matchArray[n4];
                        if (!match.isFiltered()) {
                            this.insert(((FileMatch)match).getLineElement(), false);
                        }
                        ++n4;
                    }
                } else {
                    this.insert(element, false);
                }
                ++n2;
            }
        }
    }

    private void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fTreeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fTreeViewer.update(parent, null);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild(this.fResult, child) && refreshViewer) {
            this.fTreeViewer.add((Object)this.fResult, child);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        Set<Object> children = this.fChildrenMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.fChildrenMap.put(parent, children);
        }
        return children.add(child);
    }

    private boolean hasChild(Object parent, Object child) {
        Set<Object> children = this.fChildrenMap.get(parent);
        return children != null && children.contains(child);
    }

    private void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.fTreeViewer.refresh(element);
            }
        } else if (!this.hasMatches(element)) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, this.fResult);
                if (refreshViewer) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.fTreeViewer.refresh(element);
        }
    }

    private boolean hasMatches(Object element) {
        LineElement lineElement;
        IResource resource;
        if (element instanceof LineElement && this.hasMatches(resource = (lineElement = (LineElement)element).getParent())) {
            return lineElement.hasMatches(this.fResult);
        }
        return this.fPage.getDisplayedMatchCount(element) > 0;
    }

    private boolean hasMatches(IResource element) {
        if (this.hasActiveMatchFilters()) {
            return this.fPage.getDisplayedMatchCount(element) > 0;
        }
        return this.fResult.hasMatches();
    }

    private int getMatchCount(Object element) {
        if (this.hasActiveMatchFilters()) {
            return this.fPage.getDisplayedMatchCount(element);
        }
        return this.fResult.getMatchCount();
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set<Object> siblings = this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        int elementLimit = this.getElementLimit();
        if (elementLimit != -1 && elementLimit < children.size()) {
            Object[] limitedChildren = new Object[elementLimit];
            System.arraycopy(children.toArray(), 0, limitedChildren, 0, elementLimit);
            return limitedChildren;
        }
        return children.toArray();
    }

    @Override
    public int getLeafCount(Object parentElement) {
        Object[] children = this.getChildren(parentElement);
        if (children.length == 0) {
            return 0;
        }
        int count = 0;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            boolean leaf;
            Object object = objectArray[n2];
            boolean bl = leaf = !this.hasChildren(object);
            count = leaf ? ++count : (count += this.getLeafCount(object));
            ++n2;
        }
        return count;
    }

    public boolean hasChildren(Object element) {
        Set<Object> children = this.fChildrenMap.get(element);
        if (children == null) {
            return false;
        }
        return !children.isEmpty();
    }

    static <T> Stream<T> toStream(Enumeration<T> e) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(e.asIterator(), 16), false);
    }

    private boolean isUnfiltered(FileMatch m) {
        MatchFilter[] filters = this.fResult.getActiveMatchFilters();
        if (filters != null) {
            MatchFilter[] matchFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                MatchFilter filter = matchFilterArray[n2];
                if (filter.filters(m)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public synchronized void elementsChanged(Object[] updatedElements) {
        boolean singleElement = updatedElements.length == 1;
        Set lineMatches = Collections.emptySet();
        lineMatches = this.hasActiveMatchFilters() ? Arrays.stream(updatedElements).filter(LineElement.class::isInstance).map(u -> ((LineElement)u).getParent()).distinct().map(this.fResult::getMatchSet).flatMap(FileTreeContentProvider::toStream).map(m -> (FileMatch)m).filter(this::isUnfiltered).map(m -> m.getLineElement()).collect(Collectors.toSet()) : Arrays.stream(updatedElements).filter(LineElement.class::isInstance).map(u -> ((LineElement)u).getParent()).distinct().map(this.fResult::getMatchSet).flatMap(FileTreeContentProvider::toStream).map(m -> ((FileMatch)m).getLineElement()).collect(Collectors.toSet());
        try {
            Object[] objectArray = updatedElements;
            int n = updatedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object updatedElement = objectArray[n2];
                if (!(updatedElement instanceof LineElement)) {
                    if (this.getMatchCount(updatedElement) > 0) {
                        this.insert(updatedElement, singleElement);
                    } else {
                        this.remove(updatedElement, singleElement);
                    }
                } else {
                    LineElement lineElement = (LineElement)updatedElement;
                    boolean hasMatches = lineMatches.contains(lineElement);
                    if (hasMatches) {
                        if (singleElement && this.hasChild(lineElement.getParent(), lineElement)) {
                            this.fTreeViewer.update(new Object[]{lineElement, lineElement.getParent()}, null);
                        } else {
                            this.insert(lineElement, singleElement);
                        }
                    } else {
                        this.remove(lineElement, singleElement);
                    }
                }
                ++n2;
            }
        }
        finally {
            if (updatedElements.length > 0 && !singleElement) {
                this.fTreeViewer.refresh();
            }
        }
    }

    private boolean hasActiveMatchFilters() {
        MatchFilter[] activeMatchFilters = this.fResult.getActiveMatchFilters();
        return activeMatchFilters != null && activeMatchFilters.length > 0;
    }

    @Override
    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getParent();
        }
        if (element instanceof LineElement) {
            return ((LineElement)element).getParent();
        }
        if (element instanceof FileMatch) {
            FileMatch match = (FileMatch)element;
            return match.getLineElement();
        }
        return null;
    }
}

