/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ObjectType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeParamRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.UnresolvedType;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.TypeHints;

public class TypesChecker {
    public static final BoolType NON_NULLABLE_BOOL_TYPE = ToolDefConstructors.newBoolType((Boolean)false, null);
    public static final TypeHints NON_NULLABLE_BOOL_HINT = new TypeHints().add((ToolDefType)NON_NULLABLE_BOOL_TYPE);
    public static final IntType NON_NULLABLE_INT_TYPE = ToolDefConstructors.newIntType((Boolean)false, null);
    public static final TypeHints NON_NULLABLE_INT_HINT = new TypeHints().add((ToolDefType)NON_NULLABLE_INT_TYPE);

    private TypesChecker() {
    }

    public static void tcheck(ToolDefType type, CheckerContext ctxt) {
        if (type instanceof BoolType) {
            return;
        }
        if (type instanceof DoubleType) {
            return;
        }
        if (type instanceof IntType) {
            return;
        }
        if (type instanceof LongType) {
            return;
        }
        if (type instanceof ObjectType) {
            return;
        }
        if (type instanceof StringType) {
            return;
        }
        if (type instanceof ListType) {
            ListType ltype = (ListType)type;
            TypesChecker.tcheck(ltype.getElemType(), ctxt);
            return;
        }
        if (type instanceof SetType) {
            SetType stype = (SetType)type;
            TypesChecker.tcheck(stype.getElemType(), ctxt);
            return;
        }
        if (type instanceof MapType) {
            MapType mtype = (MapType)type;
            TypesChecker.tcheck(mtype.getKeyType(), ctxt);
            TypesChecker.tcheck(mtype.getValueType(), ctxt);
            return;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            Assert.check((ttype.getFields().size() >= 2 ? 1 : 0) != 0);
            int i = 0;
            while (i < ttype.getFields().size()) {
                ToolDefType fieldType = (ToolDefType)ttype.getFields().get(i);
                TypesChecker.tcheck(fieldType, ctxt);
                ++i;
            }
            return;
        }
        if (type instanceof UnresolvedType) {
            UnresolvedType utype = (UnresolvedType)type;
            Assert.check((!utype.isNullable() ? 1 : 0) != 0);
            ToolDefType resolved = ctxt.resolveType(utype.getName(), utype.getPosition());
            EMFHelper.updateParentContainment((EObject)type, (EObject)resolved);
            return;
        }
        if (type instanceof TypeRef || type instanceof TypeParamRef) {
            throw new RuntimeException("Already resolved ref? " + String.valueOf(type));
        }
        throw new RuntimeException("Unknown type: " + String.valueOf(type));
    }
}

