/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import org.eclipse.escet.cif.datasynth.settings.BddOutputMode;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettingsDefaults;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class BddOutputOption
extends EnumOption<BddOutputMode> {
    public BddOutputOption() {
        super("BDD output mode", "Indicates how to convert BDDs to CIF for the output of synthesis. Specify \"normal\" (default) to convert each BDD to a CIF predicate in conjunctive or disjunctive normal form (CNF/DNF) notation, \"cnf\" to convert each BDD to a CIF predicate in conjunctive normal form (CNF) notation, \"dnf\" to convert each BDD to a CIF predicate in disjunctive normal form (DNF) notation, or \"nodes\" to represent the internal BDD nodes directly in CIF.", Character.valueOf('t'), "bdd-output", "OUTMODE", (Enum)CifDataSynthesisSettingsDefaults.BDD_OUTPUT_MODE_DEFAULT, true, "Indicates how to convert BDDs to CIF for the output of synthesis.");
    }

    protected String getDialogText(BddOutputMode value) {
        switch (value) {
            case NORMAL: {
                return "Convert each BDD to a CIF predicate in conjunctive or disjunctive normal form (CNF/DNF) notation";
            }
            case CNF: {
                return "Convert each BDD to a CIF predicate in conjunctive normal form (CNF) notation";
            }
            case DNF: {
                return "Convert each BDD to a CIF predicate in disjunctive normal form (DNF) notation";
            }
            case NODES: {
                return "Represent the internal BDD nodes directly in CIF";
            }
        }
        throw new RuntimeException("Unknown mode: " + String.valueOf((Object)value));
    }

    public static BddOutputMode getMode() {
        return (BddOutputMode)((Object)Options.get(BddOutputOption.class));
    }
}

