/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.plcgen.generators.typegen.PlcDerivedTypeData;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouInstance;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTask;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcFuncBlockType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public abstract class Writer {
    public static final int INDENT = 4;
    protected final PlcTarget target;

    protected Writer(PlcTarget target) {
        this.target = target;
    }

    public abstract void write(PlcProject var1, PathPair var2);

    protected void ensureDirectory(PathPair outPaths) {
        Path nioAbsPath = java.nio.file.Paths.get(outPaths.systemPath, new String[0]);
        if (!Files.isDirectory(nioAbsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(nioAbsPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create output directory \"%s\" for the generated PLC code.", (Object[])new Object[]{outPaths.userPath});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
    }

    protected Box toBox(PlcProject project) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("PROJECT %s", new Object[]{project.name});
        c.indent();
        for (PlcDerivedTypeData derivedTypeData : project.derivedTypeDatas) {
            c.add(this.toTypeDeclBox(derivedTypeData.derivedType));
        }
        for (PlcPou pou : project.pous) {
            c.add(this.toBox(pou));
        }
        for (PlcConfiguration configuration : project.configurations) {
            c.add(this.toBox(configuration));
        }
        c.dedent();
        c.add("END_PROJECT");
        return c;
    }

    protected Box toBox(PlcConfiguration configuration) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("CONFIGURATION %s", new Object[]{configuration.name});
        c.indent();
        for (PlcGlobalVarList globalVarList : configuration.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(this.toVarDeclBox(globalVarList));
        }
        Assert.check((configuration.resources.size() <= 1 ? 1 : 0) != 0);
        for (PlcResource resource : configuration.resources) {
            c.add(this.toBox(resource));
        }
        c.dedent();
        c.add("END_CONFIGURATION");
        return c;
    }

    protected Box toBox(PlcTask task) {
        return new TextBox("TASK %s(INTERVAL := t#%dms, PRIORITY := %d);", new Object[]{task.name, task.cycleTime, task.priority});
    }

    protected Box toBox(PlcResource resource) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        for (PlcGlobalVarList globalVarList : resource.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(this.toVarDeclBox(globalVarList));
        }
        for (PlcTask task : resource.tasks) {
            c.add(this.toBox(task));
        }
        for (PlcPouInstance pouInstance : resource.pouInstances) {
            c.add(this.toBox(pouInstance, null));
        }
        for (PlcTask task : resource.tasks) {
            for (PlcPouInstance pouInstance : task.pouInstances) {
                c.add(this.toBox(pouInstance, task.name));
            }
        }
        return c;
    }

    protected Box toVarDeclBox(PlcGlobalVarList globVarList) {
        Assert.check((!globVarList.variables.isEmpty() ? 1 : 0) != 0);
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("VAR_GLOBAL%s // %s", new Object[]{globVarList.listKind == PlcGlobalVarList.PlcVarListKind.CONSTANTS ? " CONSTANT" : "", globVarList.name});
        c.indent();
        for (PlcDataVariable variable : globVarList.variables) {
            c.add(this.toVarDeclBox(variable));
        }
        c.dedent();
        c.add("END_VAR");
        return c;
    }

    protected Box toVarDeclBox(PlcDataVariable dataVar) {
        String addrTxt = dataVar.address == null ? "" : Strings.fmt((String)" AT %s", (Object[])new Object[]{dataVar.address});
        String valueTxt = dataVar.value == null ? "" : " := " + this.target.getModelTextGenerator().literalToString(dataVar.value);
        String txt = Strings.fmt((String)"%s%s: %s%s;", (Object[])new Object[]{dataVar.varName, addrTxt, this.toTypeRefBox(dataVar.type), valueTxt});
        return new TextBox(txt);
    }

    protected Box toBox(PlcPouInstance pouInstance) {
        return this.toBox(pouInstance, null);
    }

    protected Box toBox(PlcPouInstance pouInstance, String taskName) {
        String taskTxt = taskName == null ? "" : Strings.fmt((String)" WITH %s", (Object[])new Object[]{taskName});
        return new TextBox("PROGRAM %s%s: %s;", new Object[]{pouInstance.name, taskTxt, pouInstance.pou.name});
    }

    protected Box toBox(PlcPou pou) {
        CodeBox c = this.headerToBox(pou);
        c.add();
        c.add((Box)pou.body);
        c.add("END_%s", new Object[]{pou.pouType});
        return c;
    }

    protected CodeBox headerToBox(PlcPou pou) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        String retTypeTxt = pou.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.toTypeRefBox(pou.retType)});
        c.add("%s %s%s", new Object[]{pou.pouType, pou.name, retTypeTxt});
        this.writeVariableList((CodeBox)c, "VAR_INPUT", pou.inputVars);
        this.writeVariableList((CodeBox)c, "VAR_IN_OUT", pou.inOutVars);
        this.writeVariableList((CodeBox)c, "VAR_OUTPUT", pou.outputVars);
        boolean inFunction = pou.pouType == PlcPouType.FUNCTION;
        Assert.implies((boolean)inFunction, (boolean)pou.persistedVars.isEmpty());
        this.writeVariableList((CodeBox)c, "VAR", pou.persistedVars);
        this.writeVariableList((CodeBox)c, inFunction ? "VAR" : "VAR_TEMP", pou.tempVars);
        return c;
    }

    private void writeVariableList(CodeBox box, String varTableName, List<PlcDataVariable> variables) {
        if (variables.isEmpty()) {
            return;
        }
        box.add(varTableName);
        box.indent();
        for (PlcDataVariable var : variables) {
            box.add(this.toVarDeclBox(var));
        }
        box.dedent();
        box.add("END_VAR");
    }

    protected Box toTypeRefBox(PlcType type) {
        if (type instanceof PlcArrayType) {
            PlcArrayType arrayType = (PlcArrayType)type;
            return this.toTypeRefBox(arrayType);
        }
        if (type instanceof PlcDerivedType) {
            PlcDerivedType derType = (PlcDerivedType)type;
            return this.toTypeRefBox(derType);
        }
        if (type instanceof PlcElementaryType) {
            PlcElementaryType elemType = (PlcElementaryType)type;
            return this.toTypeRefBox(elemType);
        }
        if (type instanceof PlcFuncBlockType) {
            PlcFuncBlockType blockType = (PlcFuncBlockType)type;
            return this.toTypeRefBox(blockType);
        }
        String typeText = type == null ? "null" : type.getClass().toString();
        throw new AssertionError((Object)("Unexpected PlcType, found: " + typeText + "."));
    }

    protected Box toTypeDeclBox(PlcDerivedType derivedType) {
        if (derivedType instanceof PlcStructType) {
            PlcStructType structType = (PlcStructType)derivedType;
            return this.toTypeDeclBox(structType);
        }
        if (derivedType instanceof PlcEnumType) {
            PlcEnumType enumType = (PlcEnumType)derivedType;
            return this.toTypeDeclBox(enumType);
        }
        throw new AssertionError((Object)("Unexpected derived type found: \"" + String.valueOf(derivedType) + "\"."));
    }

    protected Box toTypeDeclBox(PlcStructType structType) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("TYPE %s:", new Object[]{structType.getName()});
        c.indent();
        c.add("STRUCT");
        c.indent();
        for (PlcStructField field : structType.fields) {
            c.add(this.toTypeDeclBox(field));
        }
        c.dedent();
        c.add("END_STRUCT;");
        c.dedent();
        c.add("END_TYPE");
        return c;
    }

    protected Box toTypeDeclBox(PlcStructField field) {
        String txt = Strings.fmt((String)"%s: %s;", (Object[])new Object[]{field.fieldName, this.toTypeRefBox(field.type)});
        return new TextBox(txt);
    }

    protected Box toTypeDeclBox(PlcEnumType enumType) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("TYPE %s:", new Object[]{enumType.getName()});
        c.indent();
        c.add("(%s);", new Object[]{enumType.literals.stream().map(elit -> elit.value).collect(Collectors.joining(", "))});
        c.dedent();
        c.add("END_TYPE");
        return c;
    }

    protected Box toTypeRefBox(PlcElementaryType elementaryType) {
        return new TextBox(elementaryType.name);
    }

    protected Box toTypeRefBox(PlcDerivedType derivedType) {
        return new TextBox(derivedType.getName());
    }

    protected Box toTypeRefBox(PlcArrayType arrayType) {
        HBox b = new HBox();
        b.add(Strings.fmt((String)"ARRAY[%d..%d] of ", (Object[])new Object[]{arrayType.lower, arrayType.upper}));
        b.add(this.toTypeRefBox(arrayType.elemType));
        return b;
    }

    protected Box toTypeRefBox(PlcFuncBlockType blockType) {
        return new TextBox(blockType.typeName);
    }

    protected Box makeDerivedTypeDependenciesBox(List<PlcDerivedTypeData> derivedTypeDatas) {
        MemoryCodeBox box = new MemoryCodeBox();
        if (derivedTypeDatas.isEmpty()) {
            box.add("PLC code has no derived types.");
            return box;
        }
        box.add("Direct dependencies:");
        box.add("Each line has the form 'TYPE <- DEPENDENCY_1 DEPENDENCY_2 ...'.");
        box.add("To be able to use type 'TYPE', all 'DEPENDENCY_*' types must be available already.");
        box.add();
        box.indent();
        box.add(derivedTypeDatas.stream().map(dtd -> this.makeDirectDependenciesLine((PlcDerivedTypeData)dtd)).sorted().toList());
        box.dedent();
        box.add();
        boolean depsExist = derivedTypeDatas.stream().anyMatch(dtd -> !dtd.childDeps.isEmpty());
        if (!depsExist) {
            box.add("None of the derived types has a dependency on another derived type.");
            return box;
        }
        List groups = Lists.list();
        Map groupIndices = Maps.map();
        groups.add(Sets.set());
        for (PlcDerivedTypeData derivedTypeData : derivedTypeDatas) {
            int maxDepGroup = -1;
            for (PlcDerivedType dep : derivedTypeData.childDeps) {
                maxDepGroup = Math.max(maxDepGroup, (Integer)groupIndices.get(dep));
            }
            int groupIndex = maxDepGroup + 1;
            groupIndices.put(derivedTypeData.derivedType, groupIndex);
            if (groups.size() == groupIndex) {
                Set declSet = Sets.set();
                declSet.add(derivedTypeData.derivedType);
                groups.add(declSet);
                continue;
            }
            ((Set)groups.get(groupIndex)).add(derivedTypeData.derivedType);
        }
        box.add("Groups of dependent derived types:");
        box.add("A derived type in a non-first group depends on at least one type from the previous group,");
        box.add("and possibly also groups before that.");
        box.indent();
        int i = 0;
        while (i < groups.size()) {
            box.add();
            box.add("Group %d:", new Object[]{i + 1});
            box.indent();
            List<String> groupTypeNames = ((Set)groups.get(i)).stream().map(d -> d.getName()).sorted().toList();
            for (String typeName : groupTypeNames) {
                box.add(typeName);
            }
            box.dedent();
            ++i;
        }
        box.dedent();
        return box;
    }

    private String makeDirectDependenciesLine(PlcDerivedTypeData derivedTypeData) {
        if (derivedTypeData.childDeps.isEmpty()) {
            return Strings.fmt((String)"%s <-", (Object[])new Object[]{derivedTypeData.derivedType.getName()});
        }
        String deps = derivedTypeData.childDeps.stream().map(d -> d.getName()).sorted().collect(Collectors.joining(" "));
        return Strings.fmt((String)"%s <- %s", (Object[])new Object[]{derivedTypeData.derivedType.getName(), deps});
    }

    protected void writeFile(Box code, PathPair dirPaths, String fileName) {
        String userPath = Paths.join((String[])new String[]{dirPaths.userPath, fileName});
        String systemPath = Paths.join((String[])new String[]{dirPaths.systemPath, fileName});
        code.writeToFile(userPath, systemPath);
    }
}

