/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.Set;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SingleEventUsePerAutPostChecker {
    private SingleEventUsePerAutPostChecker() {
    }

    public static void check(Specification spec, CifPostCheckEnv env) {
        if (!SingleEventUsePerAutPostChecker.hasChannel((ComplexComponent)spec)) {
            return;
        }
        SingleEventUsePerAutPostChecker.checkComponent((ComplexComponent)spec, env);
    }

    private static void checkComponent(ComplexComponent comp, CifPostCheckEnv env) {
        Set sndRcvOverlap;
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                SingleEventUsePerAutPostChecker.checkComponent((ComplexComponent)child, env);
            }
            return;
        }
        Automaton aut = (Automaton)comp;
        Set sndEvents = Sets.set();
        Set rcvEvents = Sets.set();
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                for (EdgeEvent edgeEvent : edge.getEvents()) {
                    Event event;
                    Expression eventRef;
                    if (edgeEvent instanceof EdgeSend) {
                        eventRef = edgeEvent.getEvent();
                        event = ((EventExpression)eventRef).getEvent();
                        sndEvents.add(event);
                        continue;
                    }
                    if (!(edgeEvent instanceof EdgeReceive)) continue;
                    eventRef = edgeEvent.getEvent();
                    event = ((EventExpression)eventRef).getEvent();
                    rcvEvents.add(event);
                }
            }
        }
        if (sndEvents.isEmpty() && rcvEvents.isEmpty()) {
            return;
        }
        Set alphabet = CifEventUtils.getAlphabet((Automaton)aut);
        Set sndAlphaOverlap = Sets.intersection((Set)sndEvents, (Set)alphabet);
        Set rcvAlphaOverlap = Sets.intersection((Set)rcvEvents, (Set)alphabet);
        if (!sndAlphaOverlap.isEmpty()) {
            for (Event event : sndAlphaOverlap) {
                env.addProblem(ErrMsg.EVENT_AUT_USAGE_CONFLICT, aut.getPosition(), CifTextUtils.getAbsName((PositionObject)event), CifTextUtils.getAbsName((PositionObject)aut), "send", "synchronize");
            }
        }
        if (!rcvAlphaOverlap.isEmpty()) {
            for (Event event : rcvAlphaOverlap) {
                env.addProblem(ErrMsg.EVENT_AUT_USAGE_CONFLICT, aut.getPosition(), CifTextUtils.getAbsName((PositionObject)event), CifTextUtils.getAbsName((PositionObject)aut), "receive", "synchronize");
            }
        }
        if (!(sndRcvOverlap = Sets.intersection((Set)sndEvents, (Set)rcvEvents)).isEmpty()) {
            for (Event event : sndRcvOverlap) {
                env.addProblem(ErrMsg.EVENT_AUT_USAGE_CONFLICT, aut.getPosition(), CifTextUtils.getAbsName((PositionObject)event), CifTextUtils.getAbsName((PositionObject)aut), "send", "receive");
            }
        }
    }

    private static boolean hasChannel(ComplexComponent comp) {
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof Event) || ((Event)decl).getType() == null) continue;
            return true;
        }
        if (comp instanceof Automaton) {
            return false;
        }
        for (Component child : ((Group)comp).getComponents()) {
            if (!SingleEventUsePerAutPostChecker.hasChannel((ComplexComponent)child)) continue;
            return true;
        }
        return false;
    }
}

