/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.java.CifWalker;

public class ElimEquations
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating equations from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
    }

    protected void postprocessComplexComponent(ComplexComponent comp) {
        comp.getEquations().clear();
    }

    protected void postprocessLocation(Location loc) {
        loc.getEquations().clear();
    }

    protected void preprocessAlgVariable(AlgVariable var) {
        if (var.getValue() != null) {
            return;
        }
        Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
        var.setValue(value);
    }

    protected void preprocessContVariable(ContVariable var) {
        if (var.getDerivative() != null) {
            return;
        }
        Expression der = CifEquationUtils.getSingleDerivativeForContVar((ContVariable)var);
        var.setDerivative(der);
    }

    protected void walkEquation(Equation eqn) {
    }

    protected void preprocessSelfExpression(SelfExpression expr) {
        String msg = "Eliminating equations from a CIF specification with automaton \"self\" references is currently not supported.";
        throw new CifToCifPreconditionException(msg);
    }
}

