/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etmap.ui.quickfix;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class ETMapQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="ETMapJavaValidator.DulicateSubSysMapping")
    public void removeDuplicateSubSysMapping(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove duplicate", "remove this mapping", "remove.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="ETMapJavaValidator.UnmappedSubSysRefs")
    public void addMissingSubSysMappings(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add missing mappings", issue.getData()[0], "add.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                int offset = issue.getOffset() + issue.getLength();
                String insertion = "\n" + issue.getData()[0];
                if (issue.getData()[1].equals("not-empty")) {
                    --offset;
                    insertion = String.valueOf(insertion) + "\t\t";
                }
                xtextDocument.replace(offset, 0, insertion);
            }
        });
    }

    @Fix(value="ETMapJavaValidator.DulicateThreadMapping")
    public void removeDuplicateThreadMapping(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Remove duplicate", "remove this mapping", "remove.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), "");
            }
        });
    }

    @Fix(value="ETMapJavaValidator.UnmappedThreadRefs")
    public void addMissingThreadMappings(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add mappings", issue.getData()[0], "add.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                int offset = issue.getOffset() + issue.getLength();
                String insertion = "\n" + issue.getData()[0];
                if (issue.getData()[1].equals("not-empty")) {
                    --offset;
                    insertion = String.valueOf(insertion) + "\t\t";
                }
                xtextDocument.replace(offset, 0, insertion);
            }
        });
    }

    @Fix(value="ETMapJavaValidator.WrongNamespace")
    public void fixWrongNamespace(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Replace with correct namespace", issue.getData()[0], "add.gif", new IModification(){

            public void apply(IModificationContext context) throws BadLocationException {
                IXtextDocument xtextDocument = context.getXtextDocument();
                String replacement = issue.getData()[0];
                xtextDocument.replace(issue.getOffset().intValue(), issue.getLength().intValue(), replacement);
            }
        });
    }
}

