/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.imports;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.BaseFactory;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.ui.imports.IOrganizeImportHelper;
import org.eclipse.etrice.core.common.ui.imports.NamespaceSelectionDialog;
import org.eclipse.etrice.core.common.ui.imports.NamespaceSelectionLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.lib.Pair;

public class ImportOrganizer {
    private static final int IMPORT_ALL_THRESHOLD = 3;
    @Inject
    private IOrganizeImportHelper organizeImportHelper;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;

    public List<ReplaceRegion> getOrganizedImportChanges(XtextResource resource) {
        return this.getOrganizedImportChanges(resource, true);
    }

    public List<ReplaceRegion> getOrganizedImportChanges(XtextResource resource, boolean interactive) {
        Set<QualifiedName> typeUsages = this.getTypeUsages(resource, interactive);
        typeUsages = this.simplifyImports(typeUsages);
        List<ReplaceRegion> changes = this.getOrganizedImportChanges(resource, typeUsages);
        this.removeNullEdits(resource, changes);
        return changes;
    }

    protected Set<QualifiedName> getTypeUsages(XtextResource resource, boolean interactive) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        HashMultimap ambiguous = HashMultimap.create();
        Multimap<EClass, EReference> typeReferences = this.organizeImportHelper.getTypeReferences();
        EObject root = (EObject)resource.getContents().get(0);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject object = (EObject)it.next();
            if (!typeReferences.containsKey((Object)object.eClass())) continue;
            Collection references = typeReferences.get((Object)object.eClass());
            references.forEach(arg_0 -> this.lambda$0(object, resource, result, (Multimap)ambiguous, arg_0));
        }
        if (!ambiguous.isEmpty()) {
            QualifiedName[][] namespaces = new QualifiedName[ambiguous.asMap().size()][];
            int i = 0;
            for (Collection lists : ambiguous.asMap().values()) {
                QualifiedName[] list = new QualifiedName[lists.size()];
                namespaces[i++] = lists.toArray(list);
            }
            result.addAll(this.doChooseImports(namespaces));
        }
        QualifiedName ownNamespace = this.organizeImportHelper.getFullyQualifiedName(root);
        result.removeIf(fqn -> fqn.startsWith(ownNamespace));
        return result;
    }

    protected Set<QualifiedName> doChooseImports(QualifiedName[][] openChoices) {
        NamespaceSelectionLabelProvider labelProvider = new NamespaceSelectionLabelProvider();
        NamespaceSelectionDialog dialog = new NamespaceSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Organize Imports");
        dialog.setMessage("&Choose type to import:");
        dialog.setElements(openChoices);
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0 && array[0] instanceof QualifiedName) {
                    result.add((QualifiedName)array[0]);
                }
                ++i;
            }
        }
        return result;
    }

    protected Set<QualifiedName> simplifyImports(Set<QualifiedName> typeUsages) {
        Map<QualifiedName, List<QualifiedName>> grouped = typeUsages.stream().collect(Collectors.groupingBy(fqn -> fqn.skipLast(1)));
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        grouped.forEach((namespace, names) -> {
            if (names.size() > 3) {
                result.add(namespace.append("*"));
            } else {
                result.addAll((Collection<QualifiedName>)names);
            }
        });
        return result;
    }

    protected List<ReplaceRegion> getOrganizedImportChanges(XtextResource resource, Set<QualifiedName> namespaces) {
        IOrganizeImportHelper.ImportRegionResult importRegionResult = this.organizeImportHelper.getImportRegion(resource);
        ArrayList result = Lists.newArrayList();
        if (importRegionResult.getRegion() != null) {
            ArrayList<QualifiedName> sortedNamespaces = new ArrayList<QualifiedName>(namespaces);
            Collections.sort(sortedNamespaces);
            List<Import> allImportDeclarations = sortedNamespaces.stream().map(namespace -> this.createImport((QualifiedName)namespace)).collect(Collectors.toList());
            String lineSeparator = this.getLineSeparator(resource);
            String newImportSection = this.serializeImports(allImportDeclarations, lineSeparator);
            if (importRegionResult.isNeedNewLine()) {
                newImportSection = String.valueOf(newImportSection) + lineSeparator + lineSeparator + "\t";
            }
            result.add(new ReplaceRegion(importRegionResult.getRegion(), newImportSection));
            return result;
        }
        return result;
    }

    protected void removeNullEdits(XtextResource resource, List<ReplaceRegion> changes) {
        Iterator<ReplaceRegion> iterator = changes.iterator();
        String document = resource.getParseResult().getRootNode().getText();
        while (iterator.hasNext()) {
            ReplaceRegion region = iterator.next();
            if (!region.getText().equals(document.substring(region.getOffset(), region.getEndOffset()))) continue;
            iterator.remove();
        }
    }

    protected Import createImport(QualifiedName namespace) {
        Import result = BaseFactory.eINSTANCE.createImport();
        result.setImportedNamespace(namespace.toString());
        return result;
    }

    protected String serializeImports(List<Import> allImportDeclarations, String newLine) {
        if (allImportDeclarations.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        allImportDeclarations.forEach(imp -> this.appendImport(builder, (Import)imp, newLine));
        return builder.toString().trim();
    }

    protected void appendImport(StringBuilder builder, Import imp, String newLine) {
        builder.append("\timport " + imp.getImportedNamespace() + newLine);
    }

    protected String getLineSeparator(XtextResource resource) {
        return this.whitespaceInformationProvider.getLineSeparatorInformation(resource.getURI()).getLineSeparator();
    }

    private /* synthetic */ void lambda$0(EObject eObject, XtextResource xtextResource, Set set, Multimap multimap, EReference ref) {
        Object refObject = eObject.eGet((EStructuralFeature)ref);
        if (refObject instanceof EObject) {
            if (((EObject)refObject).eIsProxy()) {
                List nodes = NodeModelUtils.findNodesForFeature((EObject)eObject, (EStructuralFeature)ref);
                if (!nodes.isEmpty()) {
                    String refText = ((INode)nodes.get(0)).getText().trim();
                    List<QualifiedName> resolved = this.organizeImportHelper.resolveFullyQualifiedName(refText, ref.getEReferenceType(), (Resource)xtextResource);
                    if (resolved.size() == 1) {
                        set.addAll(resolved);
                    } else if (resolved.size() > 1) {
                        multimap.putAll((Object)new Pair((Object)eObject.eClass(), (Object)refText), resolved);
                    }
                }
            } else {
                QualifiedName namespace;
                boolean isQualified = false;
                List nodes = NodeModelUtils.findNodesForFeature((EObject)eObject, (EStructuralFeature)ref);
                if (!nodes.isEmpty() && nodes.stream().filter(node -> !node.getText().contains(".")).count() == 0L) {
                    isQualified = true;
                }
                if (!isQualified && (namespace = this.organizeImportHelper.getFullyQualifiedName((EObject)refObject)) != null) {
                    set.add(namespace);
                }
            }
        }
    }
}

