/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.validation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.generator.base.GeneratorException;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.base.validation.IGeneratorResourceValidator;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class GeneratorResourceValidator
implements IGeneratorResourceValidator {
    private IResourceValidator resourceValidator;

    @Inject
    public GeneratorResourceValidator(IResourceValidator resourceValidator) {
        this.resourceValidator = resourceValidator;
    }

    @Override
    public void validate(List<Resource> resources, Arguments arguments, ILogger logger) throws GeneratorException {
        int errors = 0;
        int warnings = 0;
        for (Resource resource : resources) {
            List list = this.resourceValidator.validate(resource, CheckMode.ALL, CancelIndicator.NullImpl);
            for (Issue issue : list) {
                if (issue.getSeverity() == Severity.ERROR) {
                    ++errors;
                    logger.logError(issue.toString());
                    continue;
                }
                if (issue.getSeverity() == Severity.WARNING) {
                    ++warnings;
                    logger.logWarning(issue.toString());
                    continue;
                }
                logger.logInfo(issue.toString());
            }
        }
        if (warnings > 0) {
            logger.logWarning(warnings + " warnings");
        }
        if (errors > 0) {
            logger.logError(errors + " errors");
            throw new GeneratorException("validation failed");
        }
    }
}

