/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.math;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KielerMath;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierSpline {
    private LinkedList<BezierCurve> curves = new LinkedList();

    public void addCurve(BezierCurve curve) {
        this.curves.add(curve);
    }

    public void addSpline(BezierSpline spline, boolean beginning) {
        if (!beginning) {
            this.curves.addAll(spline.getCurves());
        } else {
            this.curves.addAll(0, spline.getCurves());
        }
    }

    public void addCurve(KVector startPnt, KVector fstCtrPnt, KVector sndCtrPnt, KVector endPnt) {
        this.curves.add(new BezierCurve(startPnt, fstCtrPnt, sndCtrPnt, endPnt));
    }

    public KVector getStartPoint() {
        return this.curves.getFirst().start;
    }

    public KVector getEndPoint() {
        return this.curves.getLast().end;
    }

    public KVector[] getInnerPoints() {
        if (this.curves.isEmpty()) {
            return new KVector[0];
        }
        int size = this.curves.size() * 3 - 1;
        KVector[] points = new KVector[size];
        int i = 0;
        ListIterator curveIter = this.curves.listIterator();
        while (curveIter.hasNext()) {
            BezierCurve cu = (BezierCurve)curveIter.next();
            points[i++] = cu.fstControlPnt;
            points[i++] = cu.sndControlPnt;
            if (!curveIter.hasNext()) continue;
            points[i++] = cu.end;
        }
        return points;
    }

    public KVector[] getBasePoints() {
        int size = this.curves.size() + 1;
        KVector[] ret = new KVector[size];
        ret[0] = this.curves.getFirst().start;
        int i = 1;
        for (BezierCurve curve : this.curves) {
            ret[i++] = curve.end;
        }
        return ret;
    }

    public KVector[] getPolylineApprx(int accuracy) {
        KVector[] apprx = new KVector[this.curves.size() * accuracy + 1];
        apprx[0] = this.curves.getFirst().start;
        int i = 1;
        for (BezierCurve curve : this.curves) {
            KVector[] pts;
            KVector[] kVectorArray = pts = KielerMath.calcBezierPoints(curve.asVectorList(), accuracy);
            int n = pts.length;
            int n2 = 0;
            while (n2 < n) {
                KVector p = kVectorArray[n2];
                apprx[i++] = p.clone();
                ++n2;
            }
        }
        return apprx;
    }

    public LinkedList<BezierCurve> getCurves() {
        return this.curves;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (BezierCurve cu : this.curves) {
            s.append(cu.start + " -> " + cu.fstControlPnt + " -> " + cu.sndControlPnt + " -> " + cu.end + "\n");
        }
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BezierCurve {
        public KVector start;
        public KVector fstControlPnt;
        public KVector sndControlPnt;
        public KVector end;

        public BezierCurve(KVector startPnt, KVector fstCtrPnt, KVector sndCtrPnt, KVector endPnt) {
            this.start = startPnt;
            this.fstControlPnt = fstCtrPnt;
            this.sndControlPnt = sndCtrPnt;
            this.end = endPnt;
        }

        public List<KVector> asVectorList() {
            ArrayList<KVector> list = new ArrayList<KVector>(4);
            list.add(this.start);
            list.add(this.fstControlPnt);
            list.add(this.sndControlPnt);
            list.add(this.end);
            return list;
        }
    }
}

