/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.gmf;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.kiml.ui.diagram.DiagramLayoutEngine;
import de.cau.cs.kieler.kiml.ui.util.ProgressMonitorAdapter;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class LayoutDiagramFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            final Object[] elements = ((IStructuredSelection)selection).toArray();
            Job job = new Job("Layout diagram file"){

                protected IStatus run(IProgressMonitor monitor) {
                    ProgressMonitorAdapter kielerMonitor = new ProgressMonitorAdapter(monitor);
                    kielerMonitor.begin("Layout selected files", (float)elements.length);
                    try {
                        Object[] objectArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (!monitor.isCanceled()) {
                                if (object instanceof IFile) {
                                    LayoutDiagramFileHandler.layoutDiagram((IFile)object, kielerMonitor.subTask(1.0f));
                                }
                                ++n2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        return new Status(4, "de.cau.cs.kieler.kiml.gmf", "Failed to layout the selected diagram file.", (Throwable)exception);
                    }
                    kielerMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    private static void layoutDiagram(IFile file, IKielerProgressMonitor monitor) throws IOException {
        monitor.begin("Layout diagram file " + file.toString(), 2.0f);
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        final Resource resource = resourceSet.createResource(uri);
        resource.load(Collections.emptyMap());
        if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof Diagram)) {
            throw new IllegalArgumentException("The selected file does not contain a diagram.");
        }
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
        final Maybe editPart = new Maybe();
        final Maybe wrappedException = new Maybe();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Diagram diagram = (Diagram)resource.getContents().get(0);
                    OffscreenEditPartFactory offscreenFactory = OffscreenEditPartFactory.getInstance();
                    editPart.set((Object)offscreenFactory.createDiagramEditPart(diagram, new Shell()));
                }
                catch (RuntimeException re) {
                    wrappedException.set((Object)re);
                }
            }
        });
        if (wrappedException.get() != null) {
            throw (RuntimeException)wrappedException.get();
        }
        monitor.worked(1.0f);
        DiagramLayoutEngine.INSTANCE.layout(null, editPart.get(), monitor.subTask(1.0f));
        resource.save(Collections.emptyMap());
        monitor.done();
    }
}

