/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui;

import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.ui.Messages;
import org.eclipse.jface.dialogs.IInputValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutOptionValidator
implements IInputValidator {
    private LayoutOptionData<?> optionData;

    public LayoutOptionValidator(LayoutOptionData<?> theoptionData) {
        this.optionData = theoptionData;
    }

    public String isValid(String newText) {
        String trimmedText = newText.trim();
        switch (this.optionData.getType()) {
            case BOOLEAN: 
            case ENUM: 
            case REMOTE_ENUM: {
                String[] choices = this.optionData.getChoices();
                int i = 0;
                while (i < choices.length) {
                    if (choices[i].equalsIgnoreCase(trimmedText)) {
                        return null;
                    }
                    ++i;
                }
                return this.getChoicesMessage(choices);
            }
            case INT: {
                try {
                    Integer.parseInt(trimmedText);
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return Messages.getString("kiml.ui.26");
                }
            }
            case FLOAT: {
                try {
                    Float.parseFloat(trimmedText);
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return Messages.getString("kiml.ui.27");
                }
            }
            case OBJECT: {
                if (this.optionData.parseValue(trimmedText) == null) {
                    return Messages.getString("kiml.ui.39");
                }
                return null;
            }
        }
        return null;
    }

    private String getChoicesMessage(String[] choices) {
        StringBuilder messageBuilder = new StringBuilder(Messages.getString("kiml.ui.25"));
        int i = 0;
        while (i < choices.length) {
            if (i == 0) {
                messageBuilder.append(" " + choices[i]);
            } else {
                messageBuilder.append(", " + choices[i]);
            }
            ++i;
        }
        return messageBuilder.toString();
    }
}

