/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvertedPortProcessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Inverted port preprocessing", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        ListIterator<Layer> layerIterator = layers.listIterator();
        Layer currentLayer = null;
        LinkedList<LNode> unassignedNodes = new LinkedList<LNode>();
        while (layerIterator.hasNext()) {
            Layer previousLayer = currentLayer;
            currentLayer = layerIterator.next();
            for (LNode node : unassignedNodes) {
                node.setLayer(previousLayer);
            }
            unassignedNodes.clear();
            for (LNode node : currentLayer) {
                LEdge edge;
                int n;
                int n2;
                LEdge[] lEdgeArray;
                LEdge[] edgeArray;
                List<LEdge> edges;
                if (!((NodeType)((Object)node.getProperty(Properties.NODE_TYPE))).equals((Object)NodeType.NORMAL) || !((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) continue;
                for (LPort port : node.getPorts(PortType.INPUT, PortSide.EAST)) {
                    edges = port.getIncomingEdges();
                    lEdgeArray = edgeArray = edges.toArray(new LEdge[edges.size()]);
                    n2 = edgeArray.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        this.createEastPortSideDummies(layeredGraph, port, edge, unassignedNodes);
                        ++n;
                    }
                }
                for (LPort port : node.getPorts(PortType.OUTPUT, PortSide.WEST)) {
                    edges = port.getOutgoingEdges();
                    lEdgeArray = edgeArray = edges.toArray(new LEdge[edges.size()]);
                    n2 = edgeArray.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        this.createWestPortSideDummies(layeredGraph, port, edge, unassignedNodes);
                        ++n;
                    }
                }
            }
        }
        for (LNode node : unassignedNodes) {
            node.setLayer(currentLayer);
        }
        this.getMonitor().done();
    }

    private void createEastPortSideDummies(LGraph layeredGraph, LPort eastwardPort, LEdge edge, List<LNode> layerNodeList) {
        if (edge.getSource().getNode() == eastwardPort.getNode()) {
            return;
        }
        LNode dummy = new LNode(layeredGraph);
        dummy.setProperty(Properties.ORIGIN, edge);
        dummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.LONG_EDGE);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        layerNodeList.add(dummy);
        LPort dummyInput = new LPort(layeredGraph);
        dummyInput.setNode(dummy);
        dummyInput.setSide(PortSide.WEST);
        LPort dummyOutput = new LPort(layeredGraph);
        dummyOutput.setNode(dummy);
        dummyOutput.setSide(PortSide.EAST);
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge(layeredGraph);
        dummyEdge.copyProperties((IPropertyHolder)edge);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(eastwardPort);
        this.setLongEdgeSourceAndTarget(dummy, dummyInput, dummyOutput, eastwardPort);
    }

    private void createWestPortSideDummies(LGraph layeredGraph, LPort westwardPort, LEdge edge, List<LNode> layerNodeList) {
        if (edge.getTarget().getNode() == westwardPort.getNode()) {
            return;
        }
        LNode dummy = new LNode(layeredGraph);
        dummy.setProperty(Properties.ORIGIN, edge);
        dummy.setProperty(Properties.NODE_TYPE, (Object)NodeType.LONG_EDGE);
        dummy.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
        layerNodeList.add(dummy);
        LPort dummyInput = new LPort(layeredGraph);
        dummyInput.setNode(dummy);
        dummyInput.setSide(PortSide.WEST);
        LPort dummyOutput = new LPort(layeredGraph);
        dummyOutput.setNode(dummy);
        dummyOutput.setSide(PortSide.EAST);
        edge.setSource(dummyOutput);
        LEdge dummyEdge = new LEdge(layeredGraph);
        dummyEdge.copyProperties((IPropertyHolder)edge);
        dummyEdge.setSource(westwardPort);
        dummyEdge.setTarget(dummyInput);
        this.setLongEdgeSourceAndTarget(dummy, dummyInput, dummyOutput, westwardPort);
    }

    private void setLongEdgeSourceAndTarget(LNode longEdgeDummy, LPort dummyInputPort, LPort dummyOutputPort, LPort oddPort) {
        LPort sourcePort = dummyInputPort.getIncomingEdges().get(0).getSource();
        LNode sourceNode = sourcePort.getNode();
        NodeType sourceNodeType = (NodeType)((Object)sourceNode.getProperty(Properties.NODE_TYPE));
        LPort targetPort = dummyOutputPort.getOutgoingEdges().get(0).getTarget();
        LNode targetNode = targetPort.getNode();
        NodeType targetNodeType = (NodeType)((Object)targetNode.getProperty(Properties.NODE_TYPE));
        if (sourceNodeType == NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(Properties.LONG_EDGE_SOURCE, sourceNode.getProperty(Properties.LONG_EDGE_SOURCE));
        } else {
            longEdgeDummy.setProperty(Properties.LONG_EDGE_SOURCE, sourcePort);
        }
        if (targetNodeType == NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(Properties.LONG_EDGE_TARGET, targetNode.getProperty(Properties.LONG_EDGE_TARGET));
        } else {
            longEdgeDummy.setProperty(Properties.LONG_EDGE_TARGET, targetPort);
        }
    }
}

