/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.KGraphImporter;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.properties.EdgeType;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundKGraphImporter
extends KGraphImporter {
    private int maximalDepth;

    public CompoundKGraphImporter(LGraphElement.HashCodeCounter counter) {
        super(counter);
    }

    @Override
    public LGraph importGraph(KNode kgraph) {
        LGraph layeredGraph = super.importGraph(kgraph);
        ((HashMap)layeredGraph.getProperty(Properties.ELEMENT_MAP)).put(kgraph, layeredGraph);
        Set graphProperties = (Set)layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
        graphProperties.add(GraphProperties.FLAT_HIERARCHICAL);
        List<LNode> unlayeredNodes = layeredGraph.getLayerlessNodes();
        Direction direction = (Direction)layeredGraph.getProperty(LayoutOptions.DIRECTION);
        HashMap<LNode, List<LNode>> parentChildMap = new HashMap<LNode, List<LNode>>();
        this.recursiveTransformCompoundGraph(kgraph, kgraph, unlayeredNodes, layeredGraph, graphProperties, parentChildMap, direction, 0);
        layeredGraph.setProperty(Properties.GRAPH_PROPERTIES, graphProperties);
        layeredGraph.setProperty(Properties.MAX_DEPTH, this.maximalDepth);
        this.createInclusionTree(layeredGraph, kgraph);
        return layeredGraph;
    }

    void recursiveTransformCompoundGraph(KNode kgraph, KNode currentNode, List<LNode> layeredNodes, LGraph layeredGraph, Set<GraphProperties> graphProperties, Map<LNode, List<LNode>> parentChildMap, Direction direction, int depth) {
        if (depth > this.maximalDepth) {
            this.maximalDepth = depth;
        }
        HashMap elemMap = (HashMap)layeredGraph.getProperty(Properties.ELEMENT_MAP);
        if (currentNode.getChildren().isEmpty()) {
            this.transformLeaveNode(currentNode, layeredNodes, elemMap, graphProperties, (Direction)layeredGraph.getProperty(LayoutOptions.DIRECTION), depth, kgraph);
            this.transformLeaveEdges(currentNode, elemMap, direction, layeredGraph);
        } else {
            for (KNode child : currentNode.getChildren()) {
                this.recursiveTransformCompoundGraph(kgraph, child, layeredNodes, layeredGraph, graphProperties, parentChildMap, direction, depth + 1);
            }
            if (currentNode != kgraph) {
                this.transformCompoundNodeWithEdges(currentNode, layeredNodes, layeredGraph, elemMap, direction, depth);
                this.setCompoundDummyEdges(layeredNodes, parentChildMap, elemMap);
            }
        }
    }

    private void transformLeaveNode(KNode node, List<LNode> layeredNodes, Map<KGraphElement, LGraphElement> elemMap, Set<GraphProperties> graphProperties, Direction direction, int depth, KNode kgraph) {
        super.transformNode(node, layeredNodes, elemMap, (EnumSet)graphProperties, direction);
        LNode newNode = (LNode)elemMap.get(node);
        newNode.setProperty(Properties.K_PARENT, node.getParent());
        KVector flatPosVec = new KVector(0.0, 0.0);
        Util.getFlatPosition(node, kgraph, flatPosVec);
        newNode.getPosition().x = flatPosVec.x;
        newNode.getPosition().y = flatPosVec.y;
        LPort dummyPortWest = this.createDummyPort(newNode, PortSide.WEST, null, elemMap);
        dummyPortWest.setProperty(Properties.LEAVE_DUMMY_PORT, true);
        LPort dummyPortEast = this.createDummyPort(newNode, PortSide.EAST, null, elemMap);
        dummyPortEast.setProperty(Properties.LEAVE_DUMMY_PORT, true);
        newNode.setProperty(Properties.DEPTH, depth);
    }

    private void transformLeaveEdges(KNode knode, Map<KGraphElement, LGraphElement> elemMap, Direction direction, LGraph layeredGraph) {
        LPort port;
        LPort newPort;
        LNode representative;
        LEdge newEdge;
        KEdgeLayout edgeLayout;
        for (KEdge edge : knode.getIncomingEdges()) {
            edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
            newEdge = null;
            newEdge = elemMap.containsKey(edge) ? (LEdge)elemMap.get(edge) : this.createLEdgeFromKEdge(edge, elemMap, layeredGraph);
            representative = (LNode)elemMap.get(knode);
            if (edge.getTargetPort() == null) {
                newPort = this.createDummyPort(representative, PortSide.WEST, null, elemMap);
                KPoint targetPoint = edgeLayout.getTargetPoint();
                newPort.getPosition().x = (double)targetPoint.getX() - representative.getPosition().x;
                newPort.getPosition().y = (double)targetPoint.getY() - representative.getPosition().y;
                newEdge.setTarget(newPort);
                continue;
            }
            port = (LPort)elemMap.get(edge.getTargetPort());
            newEdge.setTarget(port);
        }
        for (KEdge edge : knode.getOutgoingEdges()) {
            edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
            newEdge = null;
            newEdge = elemMap.containsKey(edge) ? (LEdge)elemMap.get(edge) : this.createLEdgeFromKEdge(edge, elemMap, layeredGraph);
            representative = (LNode)elemMap.get(knode);
            if (edge.getSourcePort() == null) {
                newPort = this.createDummyPort(representative, PortSide.EAST, null, elemMap);
                KPoint sourcePoint = edgeLayout.getSourcePoint();
                newPort.getPosition().x = (double)sourcePoint.getX() - representative.getPosition().x;
                newPort.getPosition().y = (double)sourcePoint.getY() - representative.getPosition().y;
                newEdge.setSource(newPort);
                continue;
            }
            port = (LPort)elemMap.get(edge.getSourcePort());
            newEdge.setSource(port);
        }
    }

    private void transformCompoundNodeWithEdges(KNode node, List<LNode> layeredNodes, LGraph layeredGraph, Map<KGraphElement, LGraphElement> elemMap, Direction direction, int depth) {
        LinkedList<LNode> dummyNodes = new LinkedList<LNode>();
        this.transformCompoundEdgeList(node, layeredNodes, elemMap, dummyNodes, (List<KEdge>)node.getIncomingEdges(), true, layeredGraph, direction, depth);
        this.transformCompoundEdgeList(node, layeredNodes, elemMap, dummyNodes, (List<KEdge>)node.getOutgoingEdges(), false, layeredGraph, direction, depth);
    }

    private void transformCompoundEdgeList(KNode node, List<LNode> layeredNodes, Map<KGraphElement, LGraphElement> elemMap, List<LNode> dummyNodes, List<KEdge> edgesList, boolean incoming, LGraph layeredGraph, Direction direction, int depth) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        KInsets insets = nodeLayout.getInsets();
        float borderSpacing = ((Float)nodeLayout.getProperty(Properties.BORDER_SPACING)).floatValue();
        LNode upperBorder = null;
        if (incoming) {
            upperBorder = this.createBorderDummyNode(node, NodeType.UPPER_COMPOUND_BORDER, dummyNodes, elemMap, depth, layeredGraph);
            upperBorder.setProperty(Properties.ORIGINAL_INSETS, insets);
            upperBorder.setProperty((IProperty)Properties.BORDER_SPACING, Float.valueOf(borderSpacing));
            upperBorder.getSize().x = insets.getLeft() + borderSpacing;
        } else {
            for (LNode lnode : dummyNodes) {
                if (lnode.getProperty(Properties.NODE_TYPE) != NodeType.UPPER_COMPOUND_BORDER || lnode.getProperty(Properties.ORIGIN) != node) continue;
                upperBorder = lnode;
                break;
            }
        }
        for (KEdge kEdge : edgesList) {
            KEdgeLayout edgeLayout = (KEdgeLayout)kEdge.getData(KEdgeLayout.class);
            LEdge lEdge = null;
            lEdge = !elemMap.containsKey(kEdge) ? this.createLEdgeFromKEdge(kEdge, elemMap, layeredGraph) : (LEdge)elemMap.get(kEdge);
            LNode representative = null;
            boolean fromInside = false;
            fromInside = incoming ? this.isDescendantNotSelf(node, kEdge.getSource()) : !this.isDescendantNotSelf(node, kEdge.getTarget());
            KPort port = null;
            port = incoming ? kEdge.getTargetPort() : kEdge.getSourcePort();
            KShapeLayout portLayout = null;
            if (port != null) {
                portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
            }
            if (port == null) {
                if (fromInside) {
                    representative = this.createBorderDummyNode(node, NodeType.LOWER_COMPOUND_BORDER, dummyNodes, elemMap, depth, layeredGraph);
                    representative.getSize().x = insets.getRight() + borderSpacing;
                } else {
                    representative = upperBorder;
                }
            } else {
                LGraphElement portRepresentative = elemMap.get(port);
                if (portRepresentative == null) {
                    if (fromInside) {
                        representative = this.createBorderDummyNode(node, NodeType.LOWER_COMPOUND_PORT, dummyNodes, elemMap, depth, layeredGraph);
                        representative.getSize().x = insets.getRight() + borderSpacing;
                    } else {
                        representative = this.createBorderDummyNode(node, NodeType.UPPER_COMPOUND_PORT, dummyNodes, elemMap, depth, layeredGraph);
                        representative.getSize().x = insets.getLeft() + borderSpacing;
                    }
                } else {
                    representative = ((LPort)portRepresentative).getNode();
                }
            }
            if (!layeredNodes.contains(representative)) {
                layeredNodes.add(representative);
            }
            PortSide portSide = null;
            portSide = incoming ? PortSide.WEST : PortSide.EAST;
            LPort dummyPort = this.createDummyPort(representative, portSide, port, elemMap);
            float edgeSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue() * ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
            representative.getSize().y += (double)edgeSpacing;
            if (incoming) {
                KPoint targetPoint = edgeLayout.getTargetPoint();
                dummyPort.getPosition().x = (double)targetPoint.getX() - representative.getPosition().x;
                lEdge.setTarget(dummyPort);
            } else {
                KPoint sourcePoint = edgeLayout.getSourcePoint();
                dummyPort.getPosition().x = (double)sourcePoint.getX() - representative.getPosition().x;
                lEdge.setSource(dummyPort);
            }
            if (port == null) continue;
            elemMap.put((KGraphElement)port, dummyPort);
            dummyPort.setProperty(Properties.ORIGIN, port);
            dummyPort.copyProperties((IPropertyHolder)portLayout);
            dummyPort.getSize().x = portLayout.getWidth();
            dummyPort.getSize().y = portLayout.getHeight();
        }
        NodeType nodeType = null;
        if (incoming) {
            if (!layeredNodes.contains(upperBorder)) {
                layeredNodes.add(upperBorder);
            }
        } else {
            nodeType = NodeType.LOWER_COMPOUND_BORDER;
            LNode dummyNode = this.createBorderDummyNode(node, nodeType, dummyNodes, elemMap, depth, layeredGraph);
            dummyNode.getSize().x = insets.getRight() + borderSpacing;
            if (!layeredNodes.contains(dummyNode)) {
                layeredNodes.add(dummyNode);
            }
        }
    }

    private void setCompoundDummyEdges(List<LNode> layeredNodes, Map<LNode, List<LNode>> parentChildMap, HashMap<KGraphElement, LGraphElement> elemMap) {
        block4: for (LNode lNode : layeredNodes) {
            NodeType nodeType = (NodeType)((Object)lNode.getProperty(Properties.NODE_TYPE));
            switch (nodeType) {
                case UPPER_COMPOUND_BORDER: 
                case UPPER_COMPOUND_PORT: {
                    LinkedList<LNode> list;
                    LPort targetPort;
                    LPort sourcePort;
                    LEdge dummyEdge;
                    for (LNode childCandidate : layeredNodes) {
                        if (childCandidate.getProperty(Properties.K_PARENT) == null || childCandidate.getProperty(Properties.K_PARENT) != lNode.getProperty(Properties.ORIGIN) || parentChildMap.containsKey(lNode) && parentChildMap.get(lNode).contains(childCandidate)) continue;
                        dummyEdge = new LEdge(this.layeredGraph);
                        dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                        sourcePort = lNode.getPorts(PortSide.EAST).iterator().next();
                        dummyEdge.setSource(sourcePort);
                        targetPort = this.findDummyEdgePort(childCandidate, PortSide.WEST, elemMap);
                        dummyEdge.setTarget(targetPort);
                        if (parentChildMap.containsKey(lNode)) {
                            parentChildMap.get(lNode).add(childCandidate);
                            continue;
                        }
                        list = new LinkedList<LNode>();
                        list.add(childCandidate);
                        parentChildMap.put(lNode, list);
                    }
                    continue block4;
                }
                case LOWER_COMPOUND_BORDER: 
                case LOWER_COMPOUND_PORT: {
                    LinkedList<LNode> list;
                    LPort targetPort;
                    LPort sourcePort;
                    LEdge dummyEdge;
                    for (LNode childCandidate : layeredNodes) {
                        if (childCandidate.getProperty(Properties.K_PARENT) == null || childCandidate.getProperty(Properties.K_PARENT) != lNode.getProperty(Properties.ORIGIN) || parentChildMap.containsKey(lNode) && parentChildMap.get(lNode).contains(childCandidate)) continue;
                        dummyEdge = new LEdge(this.layeredGraph);
                        dummyEdge.setProperty(Properties.EDGE_TYPE, (Object)EdgeType.COMPOUND_DUMMY);
                        sourcePort = this.findDummyEdgePort(childCandidate, PortSide.EAST, elemMap);
                        dummyEdge.setSource(sourcePort);
                        targetPort = lNode.getPorts(PortSide.WEST).iterator().next();
                        dummyEdge.setTarget(targetPort);
                        if (parentChildMap.containsKey(lNode)) {
                            parentChildMap.get(lNode).add(childCandidate);
                            continue;
                        }
                        list = new LinkedList();
                        list.add(childCandidate);
                        parentChildMap.put(lNode, list);
                    }
                    continue block4;
                }
            }
        }
    }

    private LEdge createLEdgeFromKEdge(KEdge kedge, Map<KGraphElement, LGraphElement> elemMap, LGraph layeredGraph) {
        super.transformEdge(kedge, (KNode)layeredGraph.getProperty(Properties.ORIGIN), elemMap);
        LEdge newEdge = (LEdge)elemMap.get(kedge);
        elemMap.put((KGraphElement)kedge, newEdge);
        return newEdge;
    }

    private LNode createBorderDummyNode(KNode node, NodeType nodeType, List<LNode> dummyList, Map<KGraphElement, LGraphElement> elemMap, int depth, LGraph layeredGraph) {
        KNode refNode = (KNode)elemMap.get(layeredGraph);
        KVector flatPosVec = new KVector(0.0, 0.0);
        Util.getFlatPosition(node, refNode, flatPosVec);
        LNode dummyNode = null;
        if (nodeType == NodeType.LOWER_COMPOUND_BORDER) {
            for (LNode dummy : dummyList) {
                if (dummy.getProperty(Properties.NODE_TYPE) != nodeType) continue;
                dummyNode = dummy;
            }
        }
        if (dummyNode == null) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            dummyNode = new LNode(layeredGraph);
            dummyNode.setProperty(Properties.ORIGIN, node);
            dummyNode.setProperty(Properties.K_PARENT, node.getParent());
            dummyNode.getPosition().x = nodeLayout.getXpos();
            dummyNode.setProperty(Properties.NODE_TYPE, (Object)nodeType);
            if (nodeType == NodeType.UPPER_COMPOUND_BORDER || nodeType == NodeType.UPPER_COMPOUND_PORT) {
                dummyNode.setProperty(LayoutOptions.ALIGNMENT, Alignment.RIGHT);
                dummyNode.getPosition().x = flatPosVec.x;
                dummyNode.getPosition().y = flatPosVec.y + (double)nodeLayout.getHeight() / 2.0;
            }
            if (nodeType == NodeType.LOWER_COMPOUND_BORDER || nodeType == NodeType.LOWER_COMPOUND_PORT) {
                dummyNode.setProperty(LayoutOptions.ALIGNMENT, Alignment.LEFT);
                dummyNode.getPosition().x = flatPosVec.x + (double)nodeLayout.getWidth();
                dummyNode.getPosition().y = flatPosVec.y + (double)nodeLayout.getHeight() / 2.0;
            }
            this.createDummyPort(dummyNode, PortSide.EAST, null, elemMap);
            this.createDummyPort(dummyNode, PortSide.WEST, null, elemMap);
            if (nodeType == NodeType.UPPER_COMPOUND_BORDER) {
                this.transferNodePropertiesAndAttributes(node, dummyNode);
            }
            dummyList.add(dummyNode);
        }
        if (nodeType == NodeType.UPPER_COMPOUND_BORDER) {
            elemMap.put((KGraphElement)node, dummyNode);
        }
        dummyNode.setProperty(Properties.DEPTH, depth);
        dummyNode.setProperty(Properties.COMPOUND_NODE, elemMap.get(node));
        return dummyNode;
    }

    private void transferNodePropertiesAndAttributes(KNode node, LNode dummyNode) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        nodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        dummyNode.copyProperties((IPropertyHolder)nodeLayout);
    }

    private LPort createDummyPort(LNode node, PortSide side, KPort port, Map<KGraphElement, LGraphElement> elemMap) {
        LPort portRepresentative = null;
        if (port != null) {
            portRepresentative = (LPort)elemMap.get(port);
        }
        if (portRepresentative == null || portRepresentative.getSide() != side) {
            LPort dummyPort = new LPort(this.layeredGraph);
            dummyPort.setSide(side);
            dummyPort.setNode(node);
            if (port != null) {
                elemMap.put((KGraphElement)port, dummyPort);
            }
            return dummyPort;
        }
        return portRepresentative;
    }

    private boolean isDescendantNotSelf(KNode node, KNode candidate) {
        LinkedList<KNode> descendantsList = new LinkedList<KNode>();
        CompoundKGraphImporter.listDescendants(node, descendantsList);
        if (node.equals(candidate)) {
            return false;
        }
        return descendantsList.contains(candidate);
    }

    public static boolean isDescendant(KNode node, KNode candidate) {
        LinkedList<KNode> descendantsList = new LinkedList<KNode>();
        CompoundKGraphImporter.listDescendants(node, descendantsList);
        return descendantsList.contains(candidate);
    }

    private static void listDescendants(KNode currentNode, List<KNode> descendantsList) {
        if (currentNode.getChildren().isEmpty()) {
            descendantsList.add(currentNode);
        } else {
            for (KNode child : currentNode.getChildren()) {
                CompoundKGraphImporter.listDescendants(child, descendantsList);
            }
            descendantsList.add(currentNode);
        }
    }

    private LPort findDummyEdgePort(LNode node, PortSide side, Map<KGraphElement, LGraphElement> elemMap) {
        LPort port = null;
        for (LPort portCandidate : node.getPorts(side)) {
            NodeType nodeType = (NodeType)((Object)portCandidate.getNode().getProperty(Properties.NODE_TYPE));
            if (nodeType != NodeType.UPPER_COMPOUND_BORDER && !((Boolean)portCandidate.getProperty(Properties.LEAVE_DUMMY_PORT)).booleanValue()) continue;
            port = portCandidate;
            break;
        }
        if (port == null) {
            port = this.createDummyPort(node, side, null, elemMap);
        }
        return port;
    }

    @Override
    public void applyLayout(LGraph layeredGraph) {
        KNode target = (KNode)layeredGraph.getProperty(Properties.ORIGIN);
        KShapeLayout parentLayout = (KShapeLayout)target.getData(KShapeLayout.class);
        float graphBorderSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        KVector graphOffset = layeredGraph.getOffset();
        LinkedList<LEdge> edgeList = new LinkedList<LEdge>();
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            Object origin = lnode.getProperty(Properties.ORIGIN);
            if (origin instanceof KNode) {
                boolean isCompound;
                KNode kNode = (KNode)origin;
                this.applyNodeLayout(layeredGraph, lnode);
                boolean bl = isCompound = lnode.getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER;
                if (isCompound) {
                    this.compoundApplyPortLayout(kNode, layeredGraph, lnode);
                } else {
                    this.applyPortLayout((KNode)origin, layeredGraph, lnode);
                }
            } else if (origin instanceof KPort) {
                KShapeLayout portLayout = (KShapeLayout)((KPort)origin).getData(KShapeLayout.class);
                Iterator<LPort> portPosition = this.getExternalPortPosition(layeredGraph, lnode, portLayout.getWidth(), portLayout.getHeight());
                portLayout.setXpos((float)((KVector)portPosition).x);
                portLayout.setYpos((float)((KVector)portPosition).y);
            }
            for (LPort port : lnode.getPorts()) {
                edgeList.addAll(port.getOutgoingEdges());
            }
        }
        EdgeRouting routing = (EdgeRouting)parentLayout.getProperty(LayoutOptions.EDGE_ROUTING);
        boolean splinesActive = routing == EdgeRouting.SPLINES;
        boolean orthogonalRouting = ((EdgeRouting)layeredGraph.getProperty(LayoutOptions.EDGE_ROUTING)).equals((Object)EdgeRouting.ORTHOGONAL);
        for (LEdge ledge : edgeList) {
            if (ledge.isSelfLoop() && !orthogonalRouting) continue;
            this.applyEdgeLayout(ledge, graphBorderSpacing, layeredGraph, splinesActive);
        }
        KInsets insets = parentLayout.getInsets();
        float width = (float)layeredGraph.getSize().x + 2.0f * graphBorderSpacing + insets.getLeft() + insets.getRight() + (float)graphOffset.x;
        float height = (float)layeredGraph.getSize().y + 2.0f * graphBorderSpacing + insets.getTop() + insets.getBottom() + (float)graphOffset.y;
        if (((Set)layeredGraph.getProperty(Properties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            parentLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
            KimlUtil.resizeNode((KNode)target, (float)width, (float)height, (boolean)false);
        } else {
            KimlUtil.resizeNode((KNode)target, (float)width, (float)height, (boolean)true);
        }
    }

    private void applyEdgeLayout(LEdge ledge, double graphBorderSpacing, LGraph layeredGraph, boolean splinesActive) {
        KEdge kedge = (KEdge)ledge.getProperty(Properties.ORIGIN);
        KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        KVectorChain bendPoints = ledge.getBendPoints();
        KNode kSourceNode = kedge.getSource();
        KShapeLayout kSourceNodeLayout = (KShapeLayout)kSourceNode.getData(KShapeLayout.class);
        KVector kSourceNodePosition = new KVector((double)kSourceNodeLayout.getXpos(), (double)kSourceNodeLayout.getYpos());
        KNode kTargetNode = kedge.getTarget();
        KShapeLayout kTargetNodeLayout = (KShapeLayout)kTargetNode.getData(KShapeLayout.class);
        KVector kTargetNodePosition = new KVector((double)kTargetNodeLayout.getXpos(), (double)kTargetNodeLayout.getYpos());
        boolean descendantEdge = KimlUtil.isDescendant((KNode)kTargetNode, (KNode)kSourceNode);
        LPort sourcePort = ledge.getSource();
        LPort targetPort = ledge.getTarget();
        KVector offsetBorderSpacingVec = new KVector(graphBorderSpacing, graphBorderSpacing);
        KVector graphOffset = layeredGraph.getOffset();
        offsetBorderSpacingVec.add(graphOffset);
        bendPoints.translate(offsetBorderSpacingVec);
        if (kSourceNode.getParent() != (KNode)layeredGraph.getProperty(Properties.ORIGIN) || descendantEdge) {
            KVector bendpointOffset = new KVector();
            bendpointOffset = descendantEdge ? this.getAbsolute(kSourceNode) : this.getAbsolute(kSourceNode.getParent());
            bendpointOffset.negate();
            bendPoints.translate(bendpointOffset);
        }
        KVector edgeStart = new KVector(0.0, 0.0);
        if (sourcePort.getNode().getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER && sourcePort.getSide() == PortSide.WEST && !(sourcePort.getProperty(Properties.ORIGIN) instanceof KPort)) {
            edgeStart.add(sourcePort.getPosition()).add(sourcePort.getAnchor());
            edgeStart.y += ((KVector)sourcePort.getNode().getProperty(Properties.POSITION_DIFFERENCE)).y;
        } else {
            edgeStart.add(sourcePort.getPosition()).add(sourcePort.getAnchor());
        }
        if (descendantEdge) {
            edgeStart.x -= (double)kSourceNodeLayout.getInsets().getLeft();
            edgeStart.y -= (double)kSourceNodeLayout.getInsets().getTop();
        } else {
            edgeStart.add(kSourceNodePosition);
        }
        KVector difference = this.getAbsolute(kTargetNode).sub(this.getAbsolute(kSourceNode));
        if (!descendantEdge) {
            KVector sourceInsets = new KVector((double)kSourceNodeLayout.getInsets().getLeft(), (double)kSourceNodeLayout.getInsets().getTop());
            difference.add(sourceInsets);
        }
        KVector edgeEnd = new KVector(0.0, 0.0);
        if (targetPort.getNode().getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER && targetPort.getSide() == PortSide.WEST && !(targetPort.getProperty(Properties.ORIGIN) instanceof KPort)) {
            edgeEnd.add(targetPort.getPosition()).add(targetPort.getAnchor());
            edgeEnd.y += ((KVector)targetPort.getNode().getProperty(Properties.POSITION_DIFFERENCE)).y;
        } else {
            edgeEnd.add(targetPort.getPosition()).add(targetPort.getAnchor());
        }
        if (kSourceNode.getParent() == kTargetNode.getParent()) {
            edgeEnd.add(kTargetNodePosition);
        } else {
            if (!descendantEdge) {
                edgeEnd.add(kSourceNodePosition);
            }
            edgeEnd.add(difference);
            edgeEnd.x -= (double)kTargetNodeLayout.getInsets().getLeft();
            edgeEnd.y -= (double)kTargetNodeLayout.getInsets().getTop();
        }
        bendPoints.addFirst((Object)edgeStart);
        bendPoints.addLast((Object)edgeEnd);
        edgeLayout.applyVectorChain(bendPoints);
        if (splinesActive) {
            edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        }
    }

    private void applyNodeLayout(LGraph layeredGraph, LNode node) {
        float graphBorderSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        KNode original = (KNode)node.getProperty(Properties.ORIGIN);
        KNode parent = original.getParent();
        KShapeLayout parentLayout = (KShapeLayout)parent.getData(KShapeLayout.class);
        KInsets insetsParent = parentLayout.getInsets();
        KShapeLayout nodeLayout = (KShapeLayout)original.getData(KShapeLayout.class);
        LNode parentRepresentative = null;
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            if (lnode.getProperty(Properties.ORIGIN) != parent) continue;
            parentRepresentative = lnode;
            break;
        }
        boolean isCompound = node.getProperty(Properties.NODE_TYPE) == NodeType.UPPER_COMPOUND_BORDER;
        KVector size = node.getSize();
        if (isCompound) {
            nodeLayout.setSize((float)size.x, (float)size.y);
        }
        KVector position = node.getPosition();
        if (original.getParent() != layeredGraph.getProperty(Properties.ORIGIN)) {
            KVector parentRepPos = parentRepresentative.getPosition();
            KVector pointOfOrigin = new KVector(parentRepPos.x, parentRepPos.y);
            pointOfOrigin.x += (double)insetsParent.getLeft();
            pointOfOrigin.y += (double)insetsParent.getTop();
            float relativeX = (float)(position.x - pointOfOrigin.x);
            float relativeY = (float)(position.y - pointOfOrigin.y);
            nodeLayout.setPos(relativeX, relativeY);
        } else {
            KVector graphOffset = layeredGraph.getOffset();
            float newX = (float)(position.x + (double)graphBorderSpacing + graphOffset.x);
            float newY = (float)(position.y + (double)graphBorderSpacing + graphOffset.y);
            nodeLayout.setPos(newX, newY);
        }
    }

    private void applyPortLayout(KNode kNode, LGraph layeredGraph, LNode representative) {
        KShapeLayout nodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
        if (!((PortConstraints)nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isPosFixed()) {
            for (LPort lport : representative.getPorts()) {
                Object origin = lport.getProperty(Properties.ORIGIN);
                if (!(origin instanceof KPort)) continue;
                KShapeLayout portLayout = (KShapeLayout)((KPort)origin).getData(KShapeLayout.class);
                portLayout.applyVector(lport.getPosition());
            }
        }
    }

    private void compoundApplyPortLayout(KNode kNode, LGraph layeredGraph, LNode representative) {
        for (LPort lport : representative.getPorts()) {
            Object origin = lport.getProperty(Properties.ORIGIN);
            if (!(origin instanceof KPort)) continue;
            KShapeLayout portLayout = (KShapeLayout)((KPort)origin).getData(KShapeLayout.class);
            portLayout.setPos((float)(lport.getPosition().x - lport.getSize().x / 2.0), (float)(lport.getPosition().y - lport.getSize().y / 2.0));
        }
    }

    private KVector getAbsolute(KNode kNode) {
        KShapeLayout nodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
        KVector purePosition = new KVector((double)nodeLayout.getXpos(), (double)nodeLayout.getYpos());
        KVector insets = new KVector((double)nodeLayout.getInsets().getLeft(), (double)nodeLayout.getInsets().getTop());
        KVector position = new KVector(0.0, 0.0);
        position.add(purePosition);
        position.add(insets);
        if (kNode.getParent().getParent() == null) {
            return position;
        }
        return this.getAbsolute(kNode.getParent()).add(position);
    }

    private void createInclusionTree(LGraph layeredGraph, KNode knode) {
        HashMap elemMap = (HashMap)layeredGraph.getProperty(Properties.ELEMENT_MAP);
        LGraphElement representative = (LGraphElement)elemMap.get(knode);
        LinkedList children = new LinkedList();
        representative.setProperty(Properties.CHILDREN, children);
        KNode parent = knode.getParent();
        if (parent != null) {
            LGraphElement parentRep = (LGraphElement)elemMap.get(parent);
            representative.setProperty(Properties.PARENT, parentRep);
            ((LinkedList)parentRep.getProperty(Properties.CHILDREN)).add((LNode)representative);
        }
        EList ownChildren = knode.getChildren();
        for (KNode child : ownChildren) {
            this.createInclusionTree(layeredGraph, child);
        }
    }
}

