/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.AbstractGraphImporter;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGraphImporter
extends AbstractGraphImporter<KNode> {
    public KGraphImporter(LGraphElement.HashCodeCounter counter) {
        super(counter);
    }

    @Override
    public LGraph importGraph(KNode kgraph) {
        this.layeredGraph = new LGraph(this.hashCodeCounter);
        this.layeredGraph.setProperty(Properties.ORIGIN, kgraph);
        KShapeLayout sourceShapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        this.layeredGraph.copyProperties((IPropertyHolder)sourceShapeLayout);
        this.layeredGraph.checkProperties(new IProperty[]{Properties.OBJ_SPACING, Properties.BORDER_SPACING, Properties.THOROUGHNESS, Properties.ASPECT_RATIO});
        Direction direction = (Direction)this.layeredGraph.getProperty(LayoutOptions.DIRECTION);
        if (direction == Direction.UNDEFINED) {
            direction = Direction.RIGHT;
            this.layeredGraph.setProperty(LayoutOptions.DIRECTION, direction);
        }
        KInsets kinsets = sourceShapeLayout.getInsets();
        LInsets.Double linsets = this.layeredGraph.getInsets();
        linsets.left = kinsets.getLeft();
        linsets.right = kinsets.getRight();
        linsets.top = kinsets.getTop();
        linsets.bottom = kinsets.getBottom();
        HashMap<KGraphElement, LGraphElement> elemMap = new HashMap<KGraphElement, LGraphElement>();
        EnumSet<GraphProperties> graphProperties = EnumSet.noneOf(GraphProperties.class);
        this.layeredGraph.setProperty(Properties.GRAPH_PROPERTIES, graphProperties);
        boolean isCompound = (Boolean)sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        if (!isCompound) {
            this.transformNodesAndPorts(kgraph, elemMap);
            this.transformEdges(kgraph, elemMap);
        }
        this.layeredGraph.setProperty(Properties.ELEMENT_MAP, elemMap);
        return this.layeredGraph;
    }

    private void transformNodesAndPorts(KNode graph, Map<KGraphElement, LGraphElement> elemMap) {
        Set graphProperties = (Set)this.layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
        List<LNode> layeredNodes = this.layeredGraph.getLayerlessNodes();
        KShapeLayout layoutNodeLayout = (KShapeLayout)graph.getData(KShapeLayout.class);
        KVector layoutNodeSize = new KVector((double)layoutNodeLayout.getWidth(), (double)layoutNodeLayout.getHeight());
        EList ports = graph.getPorts();
        for (KPort kport : ports) {
            int hierarchicalEdges = 0;
            for (KEdge kedge : kport.getEdges()) {
                if (!graph.equals(kedge.getSource().getParent()) && !graph.equals(kedge.getTarget().getParent())) continue;
                ++hierarchicalEdges;
            }
            if (hierarchicalEdges > 0) {
                graphProperties.add(GraphProperties.EXTERNAL_PORTS);
            }
            if (hierarchicalEdges <= 1) continue;
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
        Direction direction = (Direction)this.layeredGraph.getProperty(LayoutOptions.DIRECTION);
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            for (KPort kport : ports) {
                this.transformExternalPort(kport, layeredNodes, graph, layoutNodeSize, elemMap, direction);
            }
        }
        for (KNode child : graph.getChildren()) {
            this.transformNode(child, layeredNodes, elemMap, graphProperties, direction);
        }
    }

    private void transformExternalPort(KPort kport, List<LNode> layeredNodes, KNode graph, KVector layoutNodeSize, Map<KGraphElement, LGraphElement> elemMap, Direction direction) {
        KShapeLayout graphLayout = (KShapeLayout)graph.getData(KShapeLayout.class);
        KShapeLayout kportLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
        KVector kportPosition = new KVector((double)kportLayout.getXpos() + (double)kportLayout.getWidth() / 2.0, (double)kportLayout.getYpos() + (double)kportLayout.getHeight() / 2.0);
        int inEdges = 0;
        int outEdges = 0;
        for (KEdge edge : kport.getEdges()) {
            if (edge.getSourcePort() == kport && edge.getTarget().getParent() == graph) {
                ++outEdges;
            }
            if (edge.getTargetPort() != kport || edge.getSource().getParent() != graph) continue;
            ++inEdges;
        }
        KShapeLayout portLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
        PortSide portSide = (PortSide)portLayout.getProperty(LayoutOptions.PORT_SIDE);
        Float offset = (Float)portLayout.getProperty(LayoutOptions.OFFSET);
        PortConstraints portConstraints = (PortConstraints)graphLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (portSide == PortSide.UNDEFINED) {
            portSide = KimlUtil.calcPortSide((KPort)kport, (Direction)direction);
            portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
        }
        if (offset == null) {
            offset = Float.valueOf(KimlUtil.calcPortOffset((KPort)kport, (PortSide)portSide));
            portLayout.setProperty(LayoutOptions.OFFSET, (Object)offset);
        }
        LNode dummy = this.createExternalPortDummy(kport, portConstraints, portSide, inEdges - outEdges, layoutNodeSize, kportPosition, new KVector((double)kportLayout.getWidth(), (double)kportLayout.getHeight()));
        layeredNodes.add(dummy);
        elemMap.put((KGraphElement)kport, dummy);
    }

    protected void transformNode(KNode node, List<LNode> layeredNodes, Map<KGraphElement, LGraphElement> elemMap, Set<GraphProperties> graphProperties, Direction direction) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        LNode newNode = new LNode(this.layeredGraph);
        newNode.setProperty(Properties.ORIGIN, node);
        newNode.getPosition().x = nodeLayout.getXpos();
        newNode.getPosition().y = nodeLayout.getYpos();
        layeredNodes.add(newNode);
        elemMap.put((KGraphElement)node, newNode);
        PortConstraints portConstraints = (PortConstraints)nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.UNDEFINED) {
            portConstraints = PortConstraints.FREE;
        } else if (portConstraints != PortConstraints.FREE) {
            graphProperties.add(GraphProperties.NON_FREE_PORTS);
        }
        block10: for (KPort kport : node.getPorts()) {
            KVector anchorPos;
            KShapeLayout portLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
            if (kport.getEdges().size() > 1) {
                graphProperties.add(GraphProperties.HYPEREDGES);
            }
            LPort newPort = new LPort(this.layeredGraph);
            newPort.setProperty(Properties.ORIGIN, kport);
            KVector portSize = newPort.getSize();
            portSize.x = portLayout.getWidth();
            portSize.y = portLayout.getHeight();
            KVector portPos = newPort.getPosition();
            portPos.x = portLayout.getXpos();
            portPos.y = portLayout.getYpos();
            newPort.setNode(newNode);
            PortSide portSide = (PortSide)portLayout.getProperty(LayoutOptions.PORT_SIDE);
            Float offset = (Float)portLayout.getProperty(LayoutOptions.OFFSET);
            if (portSide == PortSide.UNDEFINED) {
                portSide = KimlUtil.calcPortSide((KPort)kport, (Direction)direction);
                portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
                if (offset == null && portSide != PortSide.UNDEFINED) {
                    offset = Float.valueOf(KimlUtil.calcPortOffset((KPort)kport, (PortSide)portSide));
                    portLayout.setProperty(LayoutOptions.OFFSET, (Object)offset);
                }
            }
            newPort.setSide(portSide);
            if (offset != null) {
                newPort.setProperty(Properties.OFFSET, offset);
            }
            if ((anchorPos = (KVector)portLayout.getProperty(Properties.PORT_ANCHOR)) != null) {
                newPort.getAnchor().x = anchorPos.x;
                newPort.getAnchor().y = anchorPos.y;
            } else if (portConstraints.isSideFixed() && portSide != PortSide.UNDEFINED) {
                switch (portSide) {
                    case NORTH: {
                        newPort.getAnchor().x = portSize.x / 2.0;
                        break;
                    }
                    case EAST: {
                        newPort.getAnchor().x = portSize.x;
                        newPort.getAnchor().y = portSize.y / 2.0;
                        break;
                    }
                    case SOUTH: {
                        newPort.getAnchor().x = portSize.x / 2.0;
                        newPort.getAnchor().y = portSize.y;
                        break;
                    }
                    case WEST: {
                        newPort.getAnchor().y = portSize.y / 2.0;
                    }
                }
            } else {
                newPort.getAnchor().x = portSize.x / 2.0;
                newPort.getAnchor().y = portSize.y / 2.0;
            }
            elemMap.put((KGraphElement)kport, newPort);
            for (KLabel klabel : kport.getLabels()) {
                KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
                LLabel newLabel = new LLabel(this.layeredGraph, klabel.getText());
                newLabel.setProperty(Properties.ORIGIN, klabel);
                newLabel.getSize().x = labelLayout.getWidth();
                newLabel.getSize().y = labelLayout.getHeight();
                newLabel.getPosition().x = labelLayout.getXpos();
                newLabel.getPosition().y = labelLayout.getYpos();
                newPort.getLabels().add(newLabel);
            }
            switch (direction) {
                case RIGHT: 
                case LEFT: {
                    if (portSide != PortSide.NORTH && portSide != PortSide.SOUTH) continue block10;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                    break;
                }
                case DOWN: 
                case UP: {
                    if (portSide != PortSide.EAST && portSide != PortSide.WEST) continue block10;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                }
            }
        }
        KVector ratio = KimlUtil.resizeNode((KNode)node);
        if (ratio != null && (ratio.x != 1.0 || ratio.y != 1.0)) {
            newNode.setProperty(Properties.RESIZE_RATIO, ratio);
        }
        newNode.getSize().x = nodeLayout.getWidth();
        newNode.getSize().y = nodeLayout.getHeight();
        for (KLabel klabel : node.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            LLabel newLabel = new LLabel(this.layeredGraph, klabel.getText());
            newLabel.setProperty(Properties.ORIGIN, node);
            newLabel.getSize().x = labelLayout.getWidth();
            newLabel.getSize().y = labelLayout.getHeight();
            newLabel.getPosition().x = labelLayout.getXpos();
            newLabel.getPosition().y = labelLayout.getYpos();
            newNode.getLabels().add(newLabel);
        }
        newNode.copyProperties((IPropertyHolder)nodeLayout);
        if (((Boolean)newNode.getProperty(LayoutOptions.COMMENT_BOX)).booleanValue()) {
            graphProperties.add(GraphProperties.COMMENTS);
        }
        if (((Boolean)newNode.getProperty(LayoutOptions.HYPERNODE)).booleanValue()) {
            graphProperties.add(GraphProperties.HYPERNODES);
            graphProperties.add(GraphProperties.HYPEREDGES);
            newNode.setProperty(LayoutOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        }
    }

    private void transformEdges(KNode graph, Map<KGraphElement, LGraphElement> elemMap) {
        this.transformExternalPortEdges(graph, (List<KEdge>)graph.getIncomingEdges(), elemMap);
        this.transformExternalPortEdges(graph, (List<KEdge>)graph.getOutgoingEdges(), elemMap);
        for (KNode child : graph.getChildren()) {
            for (KEdge kedge : child.getOutgoingEdges()) {
                if (kedge.getTarget().getParent() != child.getParent()) continue;
                this.transformEdge(kedge, graph, elemMap);
            }
        }
    }

    private void transformExternalPortEdges(KNode graph, List<KEdge> edges, Map<KGraphElement, LGraphElement> elemMap) {
        for (KEdge kedge : edges) {
            if (kedge.getSource().getParent() != graph && kedge.getTarget().getParent() != graph) continue;
            this.transformEdge(kedge, graph, elemMap);
        }
    }

    protected void transformEdge(KEdge kedge, KNode graph, Map<KGraphElement, LGraphElement> elemMap) {
        Set graphProperties;
        KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
        boolean isCompound = (Boolean)((KShapeLayout)graph.getData(KShapeLayout.class)).getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        LEdge newEdge = new LEdge(this.layeredGraph);
        newEdge.setProperty(Properties.ORIGIN, kedge);
        if (!isCompound) {
            LNode sourceNode = null;
            Object sourcePort = null;
            LNode targetNode = null;
            LPort targetPort = null;
            if (kedge.getSource() == graph && kedge.getSourcePort() != null) {
                sourceNode = (LNode)elemMap.get(kedge.getSourcePort());
                if (sourceNode != null) {
                    sourcePort = sourceNode.getPorts().get(0);
                }
            } else {
                sourceNode = (LNode)elemMap.get(kedge.getSource());
                sourcePort = (LPort)elemMap.get(kedge.getSourcePort());
            }
            if (kedge.getTarget() == graph && kedge.getTargetPort() != null) {
                targetNode = (LNode)elemMap.get(kedge.getTargetPort());
                if (targetNode != null) {
                    targetPort = targetNode.getPorts().get(0);
                }
            } else {
                targetNode = (LNode)elemMap.get(kedge.getTarget());
                targetPort = (LPort)elemMap.get(kedge.getTargetPort());
            }
            if (sourceNode != null && targetNode != null) {
                if (sourceNode == targetNode) {
                    graphProperties = (Set)this.layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
                    graphProperties.add(GraphProperties.SELF_LOOPS);
                }
                if (sourcePort == null) {
                    sourcePort = this.createPort(sourceNode, edgeLayout.getSourcePoint(), PortType.OUTPUT);
                }
                if (targetPort == null) {
                    targetPort = this.createPort(targetNode, edgeLayout.getTargetPoint(), PortType.INPUT);
                }
                newEdge.setSource((LPort)sourcePort);
                newEdge.setTarget(targetPort);
            }
        }
        for (KLabel klabel : kedge.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)klabel.getData(KShapeLayout.class);
            LLabel newLabel = new LLabel(this.layeredGraph, klabel.getText());
            newLabel.getPosition().x = labelLayout.getXpos();
            newLabel.getPosition().y = labelLayout.getYpos();
            newLabel.getSize().x = labelLayout.getWidth();
            newLabel.getSize().y = labelLayout.getHeight();
            newLabel.setProperty(Properties.ORIGIN, klabel);
            newLabel.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT));
            newEdge.getLabels().add(newLabel);
            if (labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT) == EdgeLabelPlacement.CENTER) {
                graphProperties = (Set)this.layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
                graphProperties.add(GraphProperties.CENTER_LABELS);
            }
            if (labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT) != EdgeLabelPlacement.HEAD && labelLayout.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT) != EdgeLabelPlacement.TAIL) continue;
            graphProperties = (Set)this.layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
            graphProperties.add(GraphProperties.END_LABELS);
        }
        if (this.layeredGraph.getProperty(Properties.CROSSMIN) == CrossingMinimizationStrategy.INTERACTIVE && !edgeLayout.getBendPoints().isEmpty()) {
            KVectorChain bendpoints = new KVectorChain();
            for (KPoint point : edgeLayout.getBendPoints()) {
                bendpoints.add((Object)point.createVector());
            }
            newEdge.setProperty(Properties.ORIGINAL_BENDPOINTS, bendpoints);
        }
        newEdge.copyProperties((IPropertyHolder)edgeLayout);
        if (isCompound) {
            elemMap.put((KGraphElement)kedge, newEdge);
        }
    }

    private LPort createPort(LNode node, KPoint endPoint, PortType type) {
        LPort port;
        Direction direction = (Direction)this.layeredGraph.getProperty(LayoutOptions.DIRECTION);
        boolean mergePorts = (Boolean)this.layeredGraph.getProperty(Properties.MERGE_PORTS);
        if ((mergePorts || ((Boolean)node.getProperty(LayoutOptions.HYPERNODE)).booleanValue()) && !((PortConstraints)node.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isSideFixed()) {
            PortSide defaultSide = PortSide.fromDirection((Direction)direction);
            port = Util.provideCollectorPort(this.layeredGraph, node, type, defaultSide);
        } else {
            port = new LPort(this.layeredGraph);
            port.setNode(node);
            KVector pos = port.getPosition();
            pos.x = (double)endPoint.getX() - node.getPosition().x;
            pos.y = (double)endPoint.getY() - node.getPosition().y;
            KVector resizeRatio = (KVector)node.getProperty(Properties.RESIZE_RATIO);
            if (resizeRatio != null) {
                pos.scale(resizeRatio.x, resizeRatio.y);
            }
            pos.applyBounds(0.0, 0.0, node.getSize().x, node.getSize().y);
            PortSide portSide = KGraphImporter.calcPortSide(node, port);
            port.setSide(portSide);
            Set graphProperties = (Set)this.layeredGraph.getProperty(Properties.GRAPH_PROPERTIES);
            switch (direction) {
                case RIGHT: 
                case LEFT: {
                    if (portSide != PortSide.NORTH && portSide != PortSide.SOUTH) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                    break;
                }
                case DOWN: 
                case UP: {
                    if (portSide != PortSide.EAST && portSide != PortSide.WEST) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                }
            }
        }
        return port;
    }

    private static PortSide calcPortSide(LNode node, LPort port) {
        double widthPercent = port.getPosition().x / node.getSize().x;
        double heightPercent = port.getPosition().y / node.getSize().y;
        if (widthPercent + heightPercent <= 1.0 && widthPercent - heightPercent <= 0.0) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0 && widthPercent - heightPercent >= 0.0) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    @Override
    public void applyLayout(LGraph layeredGraph) {
        Object target = layeredGraph.getProperty(Properties.ORIGIN);
        if (!(target instanceof KNode)) {
            return;
        }
        KNode parentNode = (KNode)target;
        KShapeLayout parentLayout = (KShapeLayout)parentNode.getData(KShapeLayout.class);
        float borderSpacing = ((Float)layeredGraph.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        KVector offset = new KVector((double)borderSpacing + layeredGraph.getOffset().x, (double)borderSpacing + layeredGraph.getOffset().y);
        LinkedList<LEdge> edgeList = new LinkedList<LEdge>();
        for (LNode lnode : layeredGraph.getLayerlessNodes()) {
            Object origin = lnode.getProperty(Properties.ORIGIN);
            if (origin instanceof KNode) {
                KNode knode = (KNode)origin;
                KShapeLayout nodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
                nodeLayout.setXpos((float)(lnode.getPosition().x + offset.x));
                nodeLayout.setYpos((float)(lnode.getPosition().y + offset.y));
                if (!((PortConstraints)nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS)).isPosFixed()) {
                    for (LPort lport : lnode.getPorts()) {
                        origin = lport.getProperty(Properties.ORIGIN);
                        if (!(origin instanceof KPort)) continue;
                        KPort kport = (KPort)origin;
                        KShapeLayout portLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
                        portLayout.applyVector(lport.getPosition());
                    }
                }
            } else if (origin instanceof KPort) {
                KPort kport = (KPort)origin;
                Iterator<LPort> portLayout = (KShapeLayout)kport.getData(KShapeLayout.class);
                KVector portPosition = this.getExternalPortPosition(layeredGraph, lnode, portLayout.getWidth(), portLayout.getHeight());
                portLayout.applyVector(portPosition);
            }
            for (LPort port : lnode.getPorts()) {
                edgeList.addAll(port.getOutgoingEdges());
            }
        }
        EdgeRouting routing = (EdgeRouting)parentLayout.getProperty(LayoutOptions.EDGE_ROUTING);
        boolean splinesActive = routing == EdgeRouting.SPLINES;
        boolean orthogonalRouting = ((EdgeRouting)layeredGraph.getProperty(LayoutOptions.EDGE_ROUTING)).equals((Object)EdgeRouting.ORTHOGONAL);
        for (LEdge ledge : edgeList) {
            if (ledge.isSelfLoop() && !orthogonalRouting) continue;
            KEdge kedge = (KEdge)ledge.getProperty(Properties.ORIGIN);
            KEdgeLayout edgeLayout = (KEdgeLayout)kedge.getData(KEdgeLayout.class);
            KVectorChain bendPoints = ledge.getBendPoints();
            bendPoints.addFirst((Object)ledge.getSource().getAbsoluteAnchor());
            bendPoints.addLast((Object)ledge.getTarget().getAbsoluteAnchor());
            bendPoints.translate(offset);
            edgeLayout.applyVectorChain(bendPoints);
            if (!splinesActive) continue;
            edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)EdgeRouting.SPLINES);
        }
        KInsets insets = parentLayout.getInsets();
        float width = (float)layeredGraph.getSize().x + 2.0f * borderSpacing + insets.getLeft() + insets.getRight();
        float height = (float)layeredGraph.getSize().y + 2.0f * borderSpacing + insets.getTop() + insets.getBottom();
        if (((Set)layeredGraph.getProperty(Properties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            parentLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
            KimlUtil.resizeNode((KNode)parentNode, (float)width, (float)height, (boolean)false);
        } else {
            KimlUtil.resizeNode((KNode)parentNode, (float)width, (float)height, (boolean)true);
        }
    }
}

