/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.intermediate;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentPostprocessor
extends AbstractAlgorithm
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Comment post-processing", 1.0f);
        double spacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        for (Layer layer : layeredGraph) {
            LinkedList boxes = new LinkedList();
            for (LNode node : layer) {
                List topBoxes = (List)node.getProperty(Properties.TOP_COMMENTS);
                List bottomBoxes = (List)node.getProperty(Properties.BOTTOM_COMMENTS);
                if (topBoxes == null && bottomBoxes == null) continue;
                this.process(node, topBoxes, bottomBoxes, spacing);
                if (topBoxes != null) {
                    boxes.addAll(topBoxes);
                }
                if (bottomBoxes == null) continue;
                boxes.addAll(bottomBoxes);
            }
            layer.getNodes().addAll(boxes);
        }
        this.getMonitor().done();
    }

    private void process(LNode node, List<LNode> topBoxes, List<LNode> bottomBoxes, double spacing) {
        LPort nodePort;
        LPort boxPort;
        double anchorX;
        double anchorInc;
        double baseLine;
        double maxHeight;
        double boxesWidth;
        KVector nodePos = node.getPosition();
        KVector nodeSize = node.getSize();
        LInsets.Double margin = node.getMargin();
        double totalWidth = nodeSize.x + margin.left + margin.right;
        if (topBoxes != null) {
            boxesWidth = spacing / 2.0 * (double)(topBoxes.size() - 1);
            maxHeight = 0.0;
            for (LNode box : topBoxes) {
                boxesWidth += box.getSize().x;
                maxHeight = Math.max(maxHeight, box.getSize().y);
            }
            double x = nodePos.x - margin.left + (totalWidth - boxesWidth) / 2.0;
            baseLine = nodePos.y - margin.top + maxHeight;
            anchorX = anchorInc = nodeSize.x / (double)(topBoxes.size() + 1);
            for (LNode box : topBoxes) {
                box.getPosition().x = x;
                box.getPosition().y = baseLine - box.getSize().y;
                x += box.getSize().x + spacing / 2.0;
                boxPort = this.getBoxPort(box);
                boxPort.getPosition().x = box.getSize().x / 2.0 - boxPort.getAnchor().x;
                boxPort.getPosition().y = box.getSize().y;
                nodePort = (LPort)box.getProperty(Properties.COMMENT_CONN_PORT);
                if (nodePort.getDegree() == 1) {
                    nodePort.getPosition().x = anchorX - nodePort.getAnchor().x;
                    nodePort.getPosition().y = 0.0;
                    nodePort.setNode(node);
                }
                anchorX += anchorInc;
            }
        }
        if (bottomBoxes != null) {
            boxesWidth = spacing / 2.0 * (double)(bottomBoxes.size() - 1);
            maxHeight = 0.0;
            for (LNode box : bottomBoxes) {
                boxesWidth += box.getSize().x;
                maxHeight = Math.max(maxHeight, box.getSize().y);
            }
            double x = nodePos.x - margin.left + (totalWidth - boxesWidth) / 2.0;
            baseLine = nodePos.y + nodeSize.y + margin.bottom - maxHeight;
            anchorX = anchorInc = nodeSize.x / (double)(bottomBoxes.size() + 1);
            for (LNode box : bottomBoxes) {
                box.getPosition().x = x;
                box.getPosition().y = baseLine;
                x += box.getSize().x + spacing / 2.0;
                boxPort = this.getBoxPort(box);
                boxPort.getPosition().x = box.getSize().x / 2.0 - boxPort.getAnchor().x;
                boxPort.getPosition().y = 0.0;
                nodePort = (LPort)box.getProperty(Properties.COMMENT_CONN_PORT);
                if (nodePort.getDegree() == 1) {
                    nodePort.getPosition().x = anchorX - nodePort.getAnchor().x;
                    nodePort.getPosition().y = nodeSize.y;
                    nodePort.setNode(node);
                }
                anchorX += anchorInc;
            }
        }
    }

    private LPort getBoxPort(LNode commentBox) {
        LPort nodePort = (LPort)commentBox.getProperty(Properties.COMMENT_CONN_PORT);
        for (LPort port : commentBox.getPorts()) {
            Iterator<LEdge> iterator = port.getOutgoingEdges().iterator();
            if (iterator.hasNext()) {
                LEdge edge = iterator.next();
                edge.setTarget(nodePort);
                return port;
            }
            iterator = port.getIncomingEdges().iterator();
            if (!iterator.hasNext()) continue;
            LEdge edge = iterator.next();
            edge.setSource(nodePort);
            return port;
        }
        return null;
    }
}

