/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeDirectionAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.edgeDirections";
    public static final int INDEX_UP = 0;
    public static final int INDEX_LEFT = 1;
    public static final int INDEX_DOWN = 2;
    public static final int INDEX_RIGHT = 3;

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Edge direction analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int[] edgeDirections = new int[4];
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (!nodeQueue.isEmpty()) {
            KNode node = (KNode)nodeQueue.remove(0);
            for (KEdge edge : node.getOutgoingEdges()) {
                if (!hierarchy && edge.getTarget().getParent() != parentNode) continue;
                KEdgeLayout layoutData = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                KPoint sourcePoint = layoutData.getSourcePoint();
                KPoint targetPoint = layoutData.getTargetPoint();
                if (sourcePoint.getX() < targetPoint.getX()) {
                    edgeDirections[3] = edgeDirections[3] + 1;
                }
                if (sourcePoint.getX() > targetPoint.getX()) {
                    edgeDirections[1] = edgeDirections[1] + 1;
                }
                if (sourcePoint.getY() < targetPoint.getY()) {
                    edgeDirections[2] = edgeDirections[2] + 1;
                }
                if (!(sourcePoint.getY() > targetPoint.getY())) continue;
                edgeDirections[0] = edgeDirections[0] + 1;
            }
            if (!hierarchy) continue;
            nodeQueue.addAll(node.getChildren());
        }
        progressMonitor.done();
        return new Object[]{edgeDirections[0], edgeDirections[1], edgeDirections[2], edgeDirections[3]};
    }
}

