/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui;

import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.kiml.ILayoutData;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.ui.LayouterHintProvider;
import de.cau.cs.kieler.kiml.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LayouterHintDialog
extends Dialog {
    private String layouterHint;
    private Label displayNameLabel;
    private Label descriptionLabel;
    private Label imageLabel;
    private TreeViewer treeViewer;
    private LayouterHintProvider contentProvider;
    private static final int DESCRIPTION_WIDTH = 300;
    private static final int DESCR_SPACING = 12;

    public LayouterHintDialog(Shell parentShell, String currentHint) {
        super(parentShell);
        this.layouterHint = currentHint;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("kiml.ui.58"));
    }

    public boolean close() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object element = selection.getFirstElement();
        this.layouterHint = element instanceof ILayoutData ? ((ILayoutData)element).getId() : this.contentProvider.getBestFilterMatch();
        if (this.imageLabel.getImage() != null) {
            this.imageLabel.getImage().dispose();
            this.imageLabel.setImage(null);
        }
        return super.close();
    }

    private void updateValue(String value) {
        LayoutDataService layoutServices = LayoutDataService.getInstance();
        LayoutAlgorithmData layoutData = layoutServices.getAlgorithmData(value);
        if (layoutData == null) {
            layoutData = layoutServices.getTypeData(value);
        }
        if (layoutData != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)layoutData));
            this.updateValue((ILayoutData)layoutData);
        }
    }

    private void updateValue(ILayoutData layoutData) {
        String name = layoutData.getName();
        if (name == null || name.length() == 0) {
            name = layoutData instanceof LayoutAlgorithmData ? Messages.getString("kiml.ui.61") : Messages.getString("kiml.ui.8");
        }
        this.displayNameLabel.setText(name);
        String description = layoutData.getDescription();
        if (description == null || description.length() == 0) {
            description = Messages.getString("kiml.ui.60");
        }
        this.descriptionLabel.setText(description);
        Image newImage = null;
        ImageDescriptor descriptor = null;
        if (layoutData instanceof LayoutAlgorithmData && (descriptor = (ImageDescriptor)((LayoutAlgorithmData)layoutData).getPreviewImage()) != null) {
            newImage = descriptor.createImage();
        }
        if (this.imageLabel.getImage() != null) {
            this.imageLabel.getImage().dispose();
        }
        this.imageLabel.setImage(newImage);
        this.imageLabel.getParent().layout();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        this.createSelectionTree(composite);
        this.createDescriptionArea(composite);
        this.updateValue(this.layouterHint);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof ILayoutData) {
                    LayouterHintDialog.this.updateValue((ILayoutData)element);
                }
            }
        });
        return composite;
    }

    private Control createSelectionTree(Composite parent) {
        Composite composite = new Composite(parent, 0);
        final Text filterText = new Text(composite, 2048);
        filterText.setText(Messages.getString("kiml.ui.59"));
        filterText.setLayoutData((Object)new GridData(4, 128, true, false));
        filterText.setForeground(parent.getDisplay().getSystemColor(15));
        this.treeViewer = new TreeViewer(composite, 2564);
        this.contentProvider = new LayouterHintProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setInput((Object)LayoutDataService.getInstance());
        this.treeViewer.expandAll();
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LayouterHintDialog.this.okPressed();
            }
        });
        final Maybe filterChanged = new Maybe((Object)Boolean.FALSE);
        final Maybe filterLeft = new Maybe((Object)Boolean.FALSE);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!((Boolean)filterChanged.get()).booleanValue()) {
                    filterChanged.set((Object)Boolean.TRUE);
                    filterText.setForeground(null);
                    int pos = filterText.getCaretPosition();
                    String newText = filterText.getText(pos - 1, pos - 1);
                    filterText.setText(newText);
                    filterText.setSelection(pos);
                } else {
                    LayouterHintDialog.this.contentProvider.updateFilter(filterText.getText());
                    LayouterHintDialog.this.treeViewer.refresh();
                    LayouterHintDialog.this.treeViewer.expandAll();
                }
            }
        });
        filterText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (((Boolean)filterLeft.get()).booleanValue() && !((Boolean)filterChanged.get()).booleanValue()) {
                    filterChanged.set((Object)Boolean.TRUE);
                    filterText.setForeground(null);
                    filterText.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                filterLeft.set((Object)Boolean.TRUE);
            }
        });
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return LayouterHintDialog.this.contentProvider.applyFilter(element);
            }
        });
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    private Control createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.displayNameLabel = new Label(composite, 0);
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)parent.getFont());
        fontDescriptor = fontDescriptor.increaseHeight(2).setStyle(1);
        this.displayNameLabel.setFont(fontDescriptor.createFont((Device)parent.getDisplay()));
        this.displayNameLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.descriptionLabel = new Label(composite, 64);
        GridData descriptionLayoutData = new GridData(4, 4, true, true);
        descriptionLayoutData.widthHint = 300;
        this.descriptionLabel.setLayoutData((Object)descriptionLayoutData);
        this.imageLabel = new Label(composite, 0);
        GridData imageLayoutData = new GridData(4, 1024, true, false);
        this.imageLabel.setLayoutData((Object)imageLayoutData);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.verticalSpacing = 12;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    public String getSelectedHint() {
        return this.layouterHint;
    }
}

