/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphiti;

import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutConfig;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.mm.MmFactory;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.mm.pictograms.util.PictogramsSwitch;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphitiLayoutConfig
implements IMutableLayoutConfig {
    public static final int PRIORITY = 30;
    public static final String PREFIX = "layout:";
    public static final String DEF_PREFIX = "defaultLayout:";
    public static final IProperty<PictogramElement> PICTO_ELEM = new de.cau.cs.kieler.core.properties.Property("context.pictogramElement");
    private static final float ASPECT_RATIO_ROUND = 100.0f;

    public int getPriority() {
        return 30;
    }

    public void enrich(LayoutContext context) {
        Object diagramPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        PictogramElement pictogramElem = null;
        Diagram diagram = null;
        if (diagramPart instanceof IPictogramElementEditPart) {
            IPictogramElementEditPart focusEditPart = (IPictogramElementEditPart)diagramPart;
            pictogramElem = focusEditPart.getPictogramElement();
            diagram = focusEditPart.getConfigurationProvider().getDiagram();
        } else if (diagramPart instanceof PictogramElement) {
            pictogramElem = (PictogramElement)diagramPart;
        }
        if (pictogramElem != null) {
            Maybe hasPorts;
            Maybe containerPe;
            Set<LayoutOptionData.Target> partTargets;
            context.setProperty(PICTO_ELEM, (Object)pictogramElem);
            if (context.getProperty(LayoutContext.DOMAIN_MODEL) == null && pictogramElem.getLink() != null && pictogramElem.getLink().getBusinessObjects().size() > 0) {
                context.setProperty(LayoutContext.DOMAIN_MODEL, pictogramElem.getLink().getBusinessObjects().get(0));
            }
            if ((partTargets = GraphitiLayoutConfig.findTarget(pictogramElem, (Maybe<PictogramElement>)(containerPe = Maybe.create()), (Maybe<Boolean>)(hasPorts = Maybe.create()))) != null) {
                context.setProperty(LayoutContext.OPT_TARGETS, partTargets);
            }
            if (hasPorts.get() != null) {
                context.setProperty(DefaultLayoutConfig.HAS_PORTS, hasPorts.get());
            }
            try {
                Control control = null;
                if (diagramPart instanceof EditPart) {
                    control = ((EditPart)diagramPart).getViewer().getControl();
                } else {
                    IWorkbenchPart workbenchPart = (IWorkbenchPart)context.getProperty(EclipseLayoutConfig.WORKBENCH_PART);
                    if (workbenchPart instanceof DiagramEditor) {
                        control = ((DiagramEditor)workbenchPart).getGraphicalViewer().getControl();
                    }
                }
                if (control != null) {
                    Point size = control.getSize();
                    if (size.x > 0 && size.y > 0) {
                        context.setProperty(EclipseLayoutConfig.ASPECT_RATIO, (Object)Float.valueOf((float)Math.round(100.0f * (float)size.x / (float)size.y) / 100.0f));
                    }
                }
            }
            catch (SWTException sWTException) {}
            if (((Boolean)context.getProperty(DefaultLayoutConfig.OPT_MAKE_OPTIONS)).booleanValue()) {
                if (diagram == null) {
                    PictogramElement pe = pictogramElem;
                    while (pe != null && !(pe instanceof Diagram)) {
                        pe = (PictogramElement)pe.eContainer();
                    }
                    if (pe != null) {
                        diagram = (Diagram)pe;
                    }
                }
                LayoutOptionData algorithmOptionData = LayoutDataService.getInstance().getOptionData(LayoutOptions.ALGORITHM.getId());
                if (context.getProperty(DefaultLayoutConfig.CONTENT_HINT) == null && algorithmOptionData != null) {
                    String contentLayoutHint = (String)this.getValue(algorithmOptionData, PREFIX, pictogramElem);
                    if (contentLayoutHint == null && diagram != null) {
                        contentLayoutHint = (String)this.getValue(algorithmOptionData, DEF_PREFIX, (PictogramElement)diagram);
                    }
                    if (contentLayoutHint != null) {
                        context.setProperty(DefaultLayoutConfig.CONTENT_HINT, (Object)contentLayoutHint);
                    }
                }
                if (containerPe.get() != null) {
                    PictogramLink link;
                    if (context.getProperty(DefaultLayoutConfig.CONTAINER_HINT) == null && algorithmOptionData != null) {
                        String containerLayoutHint = (String)this.getValue(algorithmOptionData, PREFIX, (PictogramElement)containerPe.get());
                        if (containerLayoutHint == null && diagram != null) {
                            containerLayoutHint = (String)this.getValue(algorithmOptionData, DEF_PREFIX, (PictogramElement)diagram);
                        }
                        if (containerLayoutHint != null) {
                            context.setProperty(DefaultLayoutConfig.CONTAINER_HINT, (Object)containerLayoutHint);
                        }
                    }
                    if ((link = ((PictogramElement)containerPe.get()).getLink()) != null && link.getBusinessObjects().size() > 0) {
                        context.setProperty(LayoutContext.CONTAINER_DOMAIN_MODEL, link.getBusinessObjects().get(0));
                    }
                }
            }
        }
    }

    private static Set<LayoutOptionData.Target> findTarget(final PictogramElement pe, final Maybe<PictogramElement> containerPe, final Maybe<Boolean> hasPorts) {
        PictogramsSwitch<Set<LayoutOptionData.Target>> pictogramsSwitch = new PictogramsSwitch<Set<LayoutOptionData.Target>>(){

            public Set<LayoutOptionData.Target> caseDiagram(Diagram diagram) {
                containerPe.set((Object)diagram);
                return EnumSet.of(LayoutOptionData.Target.PARENTS);
            }

            public Set<LayoutOptionData.Target> caseShape(Shape shape) {
                containerPe.set((Object)shape.getContainer());
                EnumSet<LayoutOptionData.Target> targets = EnumSet.of(LayoutOptionData.Target.NODES);
                if (pe instanceof ContainerShape) {
                    for (Shape child : ((ContainerShape)pe).getChildren()) {
                        if (child.getAnchors().isEmpty()) continue;
                        targets.add(LayoutOptionData.Target.PARENTS);
                        break;
                    }
                }
                for (Anchor anchor : ((Shape)pe).getAnchors()) {
                    if (!(anchor instanceof BoxRelativeAnchor)) continue;
                    hasPorts.set((Object)Boolean.TRUE);
                    break;
                }
                return targets;
            }

            public Set<LayoutOptionData.Target> caseConnection(Connection connection) {
                AnchorContainer ac = connection.getStart().getParent();
                if (ac instanceof Shape) {
                    containerPe.set((Object)((Shape)ac).getContainer());
                    return EnumSet.of(LayoutOptionData.Target.EDGES);
                }
                return null;
            }

            public Set<LayoutOptionData.Target> caseAnchor(Anchor anchor) {
                AnchorContainer ac = anchor.getParent();
                if (ac instanceof Shape) {
                    containerPe.set((Object)((Shape)ac).getContainer());
                    return EnumSet.of(LayoutOptionData.Target.PORTS);
                }
                return null;
            }
        };
        return (Set)pictogramsSwitch.doSwitch((EObject)pe);
    }

    public Object getValue(LayoutOptionData<?> optionData, LayoutContext context) {
        PictogramElement pe = (PictogramElement)context.getProperty(PICTO_ELEM);
        if (pe != null) {
            Object result = this.getValue(optionData, PREFIX, pe);
            if (result != null) {
                return result;
            }
            PictogramElement parent = pe;
            while (parent.eContainer() instanceof PictogramElement) {
                parent = (PictogramElement)parent.eContainer();
            }
            return this.getValue(optionData, DEF_PREFIX, parent);
        }
        return null;
    }

    private <T> T getValue(LayoutOptionData<T> optionData, String prefix, PictogramElement pictogramElement) {
        String optionKey = String.valueOf(prefix) + optionData.getId();
        for (Property p : pictogramElement.getProperties()) {
            Object result;
            if (!optionKey.equals(p.getKey()) || (result = optionData.parseValue(p.getValue())) == null) continue;
            return (T)result;
        }
        return null;
    }

    public void transferValues(KGraphData graphData, LayoutContext context) {
        PictogramElement pe = (PictogramElement)context.getProperty(PICTO_ELEM);
        if (pe != null) {
            PictogramElement parent = pe;
            while (parent.eContainer() instanceof PictogramElement) {
                parent = (PictogramElement)parent.eContainer();
            }
            this.transferValues(graphData, DEF_PREFIX, parent);
            this.transferValues(graphData, PREFIX, pe);
        }
    }

    private void transferValues(KGraphData graphData, String prefix, PictogramElement pe) {
        LayoutDataService layoutServices = LayoutDataService.getInstance();
        for (Property prop : pe.getProperties()) {
            Object value;
            LayoutOptionData optionData;
            String key = prop.getKey();
            if (key == null || !key.startsWith(prefix) || (optionData = layoutServices.getOptionData(key.substring(prefix.length()))) == null || (value = optionData.parseValue(prop.getValue())) == null) continue;
            graphData.setProperty((IProperty)optionData, value);
        }
    }

    public void setValue(LayoutOptionData<?> optionData, LayoutContext context, Object value) {
        PictogramElement pe = (PictogramElement)context.getProperty(PICTO_ELEM);
        if (pe != null) {
            if (((Boolean)context.getProperty(IMutableLayoutConfig.OPT_RECURSIVE)).booleanValue()) {
                if (value != null) {
                    this.removeValue(optionData, PREFIX, pe, true);
                }
                this.setValue(optionData, value, DEF_PREFIX, pe);
            } else {
                this.setValue(optionData, value, PREFIX, pe);
            }
        }
    }

    private void setValue(LayoutOptionData<?> optionData, Object value, String prefix, PictogramElement pictogramElement) {
        if (value == null) {
            this.removeValue(optionData, prefix, pictogramElement, false);
        } else {
            Property p2;
            String optionKey = String.valueOf(prefix) + optionData.getId();
            for (Property p2 : pictogramElement.getProperties()) {
                if (!optionKey.equals(p2.getKey())) continue;
                p2.setValue(value.toString());
                return;
            }
            p2 = MmFactory.eINSTANCE.createProperty();
            p2.setKey(String.valueOf(prefix) + optionData.getId());
            p2.setValue(value.toString());
            pictogramElement.getProperties().add((Object)p2);
        }
    }

    private void removeValue(LayoutOptionData<?> optionData, String prefix, PictogramElement pictogramElement, boolean recursive) {
        Iterator iter = pictogramElement.getProperties().iterator();
        String optionKey = String.valueOf(prefix) + optionData.getId();
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            if (!optionKey.equals(p.getKey())) continue;
            iter.remove();
        }
        if (recursive && pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            for (Shape shape : cs.getChildren()) {
                this.removeValue(optionData, prefix, (PictogramElement)shape, true);
            }
            for (Anchor anchor : cs.getAnchors()) {
                this.removeValue(optionData, prefix, (PictogramElement)anchor, true);
            }
            if (cs instanceof Diagram) {
                for (Connection connection : ((Diagram)cs).getConnections()) {
                    this.removeValue(optionData, prefix, (PictogramElement)connection, true);
                }
            }
        }
    }

    public void clearValues(LayoutContext context) {
        PictogramElement pe = (PictogramElement)context.getProperty(PICTO_ELEM);
        if (pe != null) {
            boolean recursive = (Boolean)context.getProperty(IMutableLayoutConfig.OPT_RECURSIVE);
            GraphitiLayoutConfig.clearValues(pe, recursive);
        }
    }

    private static void clearValues(PictogramElement pictogramElement, boolean recursive) {
        Iterator iter = pictogramElement.getProperties().iterator();
        while (iter.hasNext()) {
            String key;
            Property p = (Property)iter.next();
            String string = key = p.getKey() == null ? "" : p.getKey();
            if (!key.startsWith(PREFIX) && !key.startsWith(DEF_PREFIX)) continue;
            iter.remove();
        }
        if (recursive && pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            for (Shape shape : cs.getChildren()) {
                GraphitiLayoutConfig.clearValues((PictogramElement)shape, true);
            }
            for (Anchor anchor : cs.getAnchors()) {
                GraphitiLayoutConfig.clearValues((PictogramElement)anchor, true);
            }
            if (cs instanceof Diagram) {
                for (Connection connection : ((Diagram)cs).getConnections()) {
                    GraphitiLayoutConfig.clearValues((PictogramElement)connection, true);
                }
            }
        }
    }

    public boolean isSet(LayoutOptionData<?> optionData, LayoutContext context) {
        PictogramElement pe = (PictogramElement)context.getProperty(PICTO_ELEM);
        if (pe != null) {
            Object result = this.getValue(optionData, PREFIX, pe);
            return result != null;
        }
        return false;
    }
}

