/*
 * KIELER - Kiel Integrated Environment for Layout Eclipse RichClient
 *
 * http://www.informatik.uni-kiel.de/rtsys/kieler/
 *
 * Copyright 2010 by
 * + Christian-Albrechts-University of Kiel
 *   + Department of Computer Science
 *     + Real-Time and Embedded Systems Group
 *
 * This code is provided under the terms of the Eclipse Public License (EPL).
 * See the file epl-v10.html for the license text.
 */
package de.cau.cs.kieler.klay.layered.p2layers;

/**
 * Definition of available node layering strategies for the layered layouter.
 * 
 * @author pdo
 * @kieler.design proposed by msp
 * @kieler.rating proposed yellow by msp
 */
public enum LayeringStrategy {

    /** All nodes will be layered with minimal edge length by using the network-simplex-algorithm. */
    NETWORK_SIMPLEX,
    /** All nodes will be layered according to the longest path. */
    LONGEST_PATH,
    /** Nodes are put into layers according to their relative position. */
    INTERACTIVE;
    
    /**
     * Returns the enumeration value related to the given ordinal.
     * 
     * @param i
     *            ordinal value
     * @return the related enumeration value
     */
    public static LayeringStrategy valueOf(final int i) {
        return values()[i];
    }

}
