/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeCountAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.edgeCount";

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Number of edges analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        int numberOfEdges = 0;
        LinkedList nodeQueue = new LinkedList();
        nodeQueue.addAll(parentNode.getChildren());
        while (nodeQueue.size() > 0) {
            KNode node = (KNode)nodeQueue.remove(0);
            if (hierarchy) {
                numberOfEdges += node.getOutgoingEdges().size();
                nodeQueue.addAll(node.getChildren());
                continue;
            }
            for (KEdge edge : node.getOutgoingEdges()) {
                if (edge.getTarget().getParent() != parentNode) continue;
                ++numberOfEdges;
            }
        }
        progressMonitor.done();
        return numberOfEdges;
    }
}

