/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.force.ComponentsProcessor;
import de.cau.cs.kieler.klay.force.KGraphImporter;
import de.cau.cs.kieler.klay.force.graph.FGraph;
import de.cau.cs.kieler.klay.force.model.AbstractForceModel;
import de.cau.cs.kieler.klay.force.model.EadesModel;
import de.cau.cs.kieler.klay.force.model.ForceModelStrategy;
import de.cau.cs.kieler.klay.force.model.FruchtermanReingoldModel;
import de.cau.cs.kieler.klay.force.properties.Properties;
import java.util.List;
import java.util.Random;

public class ForceLayoutProvider
extends AbstractLayoutProvider {
    private AbstractForceModel forceModel;
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();

    public void doLayout(KNode kgraph, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("KLay Force", 1.0f);
        KGraphImporter graphImporter = new KGraphImporter();
        FGraph fgraph = graphImporter.importGraph(kgraph);
        this.setOptions(fgraph, kgraph);
        this.updateModel((ForceModelStrategy)((Object)fgraph.getProperty((IProperty)Properties.FORCE_MODEL)));
        List<FGraph> components = this.componentsProcessor.split(fgraph);
        for (FGraph comp : components) {
            this.forceModel.reset(progressMonitor.subTask(1.0f / (float)components.size()));
            this.forceModel.layout(comp);
        }
        fgraph = this.componentsProcessor.pack(components);
        graphImporter.applyLayout(fgraph);
        progressMonitor.done();
    }

    private void setOptions(FGraph fgraph, KNode parent) {
        Integer randomSeed = (Integer)fgraph.getProperty(LayoutOptions.RANDOM_SEED);
        if (randomSeed != null) {
            int val = randomSeed;
            if (val == 0) {
                fgraph.setProperty(Properties.RANDOM, new Random());
            } else {
                fgraph.setProperty(Properties.RANDOM, new Random(val));
            }
        } else {
            fgraph.setProperty(Properties.RANDOM, new Random(1L));
        }
    }

    private void updateModel(ForceModelStrategy strategy) {
        switch (strategy) {
            case EADES: {
                if (this.forceModel instanceof EadesModel) break;
                this.forceModel = new EadesModel();
                break;
            }
            case FRUCHTERMAN_REINGOLD: {
                if (this.forceModel instanceof FruchtermanReingoldModel) break;
                this.forceModel = new FruchtermanReingoldModel();
            }
        }
    }
}

