/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.eclipse.gemini.naming.FactoryManager;
import org.eclipse.gemini.naming.SecurityUtils;

class ContextWrapperImpl
implements Context {
    private static Logger logger = Logger.getLogger(ContextWrapperImpl.class.getName());
    private final Context m_context;
    private final FactoryManager m_factoryManager;

    public ContextWrapperImpl(Context context, FactoryManager factoryManager) {
        this.m_context = context;
        this.m_factoryManager = factoryManager;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.getURLContextOrDefaultContext(name.toString()).lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.getURLContextOrDefaultContext(name).lookup(name);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.getURLContextOrDefaultContext(name.toString()).bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.getURLContextOrDefaultContext(name).bind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.getURLContextOrDefaultContext(name.toString()).rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.getURLContextOrDefaultContext(name).rebind(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getURLContextOrDefaultContext(name.toString()).unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.getURLContextOrDefaultContext(name).unbind(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.getURLContextOrDefaultContext(oldName.toString()).rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.getURLContextOrDefaultContext(oldName).rename(oldName, newName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getURLContextOrDefaultContext(name.toString()).list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.getURLContextOrDefaultContext(name).list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getURLContextOrDefaultContext(name.toString()).listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.getURLContextOrDefaultContext(name).listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getURLContextOrDefaultContext(name.toString()).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.getURLContextOrDefaultContext(name).destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLContextOrDefaultContext(name.toString()).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.getURLContextOrDefaultContext(name).createSubcontext(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.getURLContextOrDefaultContext(name.toString()).lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.getURLContextOrDefaultContext(name).lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLContextOrDefaultContext(name.toString()).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getURLContextOrDefaultContext(name).getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.getURLContextOrDefaultContext(name.toString()).composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.getURLContextOrDefaultContext(name).composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.m_context.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.m_context.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.m_context.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.m_context.close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.m_context.getNameInNamespace();
    }

    private static boolean isURLRequest(String name) {
        int indexOfColon = name.indexOf(":");
        return indexOfColon != -1;
    }

    private static String getScheme(String name) {
        int indexOfColon = name.indexOf(":");
        if (indexOfColon != -1) {
            return name.substring(0, indexOfColon);
        }
        return null;
    }

    private Context getURLContextOrDefaultContext(String name) throws NameNotFoundException, NamingException {
        if (ContextWrapperImpl.isURLRequest(name)) {
            ObjectFactory objectFactory = null;
            try {
                objectFactory = (ObjectFactory)SecurityUtils.invokePrivilegedAction(new GetObjectFactoryAction(this.m_factoryManager, name));
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Exception occurred while trying to obtain a reference to a URL Context Factory.", e);
            }
            if (objectFactory == null) {
                throw new NameNotFoundException("Name: " + name + " was not found.  A URL Context Factory was not registered to handle " + "this URL scheme");
            }
            try {
                Context context = (Context)objectFactory.getObjectInstance(null, null, null, this.m_context.getEnvironment());
                if (context != null) {
                    return context;
                }
                throw new NamingException("Name = " + name + "was not found using the URL Context factory = " + objectFactory);
            }
            catch (Exception e) {
                if (e instanceof NamingException) {
                    throw (NamingException)e;
                }
                NameNotFoundException namingException = new NameNotFoundException("Exception occurred during URL Context Factory Resolution for name = " + name);
                namingException.initCause(e);
                throw namingException;
            }
        }
        return this.m_context;
    }

    private static class GetObjectFactoryAction
    implements PrivilegedExceptionAction {
        private final FactoryManager m_factoryManager;
        private final String m_name;

        GetObjectFactoryAction(FactoryManager factoryManager, String name) {
            this.m_factoryManager = factoryManager;
            this.m_name = name;
        }

        public Object run() throws Exception {
            return this.obtainObjectFactory(this.m_name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectFactory obtainObjectFactory(String name) {
            ObjectFactory objectFactory;
            FactoryManager factoryManager = this.m_factoryManager;
            synchronized (factoryManager) {
                objectFactory = this.m_factoryManager.getURLContextFactory(ContextWrapperImpl.getScheme(name));
            }
            return objectFactory;
        }
    }
}

