/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.gemini.naming.OSGiURLParser;
import org.eclipse.gemini.naming.ReflectionUtils;
import org.eclipse.gemini.naming.ReflectiveInvokeAction;
import org.eclipse.gemini.naming.SecurityUtils;
import org.eclipse.gemini.naming.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class ServiceInvocationHandler
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(ServiceInvocationHandler.class.getName());
    private final BundleContext m_callerBundleContext;
    private Object m_osgiService;
    protected ServiceTracker m_serviceTracker;
    private ServiceReference m_serviceReference;
    private final OSGiURLParser m_urlParser;

    ServiceInvocationHandler(BundleContext callerBundleContext, ServiceReference serviceReference, OSGiURLParser urlParser, Object osgiService) {
        this.m_callerBundleContext = callerBundleContext;
        this.m_osgiService = osgiService;
        this.m_serviceReference = serviceReference;
        this.m_urlParser = urlParser;
        this.m_serviceTracker = new ServiceTracker(this.m_callerBundleContext, this.m_serviceReference, null);
        this.m_serviceTracker.open();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return SecurityUtils.invokePrivilegedAction(new ServiceInvokeAction(method, args));
    }

    private Object handleMethodInvocation(Method method, Object[] args) throws Throwable {
        if (this.isServiceAvailable()) {
            return this.invokeMethodOnService(method, args);
        }
        if (this.obtainService()) {
            return this.invokeMethodOnService(method, args);
        }
        throw new ServiceException("Backing service is not available for invocation", 1);
    }

    private Object invokeMethodOnService(Method method, Object[] args) throws Throwable {
        try {
            return ReflectionUtils.invokeMethodOnObject(method, this.m_osgiService, args);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServiceException("An error occurred while trying to invoke on this service, please verify that this service's interface is public", (Throwable)illegalAccessException);
        }
    }

    protected void close() {
        try {
            this.m_callerBundleContext.ungetService(this.m_serviceReference);
        }
        catch (Throwable throwable) {
            logger.log(Level.FINER, "An Exception occurred while trying to unget the backing OSGi service", throwable);
        }
        this.m_serviceTracker.close();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private boolean isServiceAvailable() {
        return this.m_serviceTracker.size() == 1;
    }

    protected boolean obtainService() {
        this.m_serviceTracker.close();
        try {
            ServiceReference[] serviceReferences = this.m_callerBundleContext.getServiceReferences(this.m_urlParser.getServiceInterface(), this.m_urlParser.getFilter());
            if (serviceReferences != null) {
                ServiceReference[] sortedServiceReferences = ServiceUtils.sortServiceReferences(serviceReferences);
                return this.resetBackingService(sortedServiceReferences[0]);
            }
            ServiceReference[] serviceReferencesByName = ServiceUtils.getServiceReferencesByServiceName(this.m_callerBundleContext, this.m_urlParser);
            if (serviceReferencesByName != null) {
                ServiceReference[] sortedServiceReferences = ServiceUtils.sortServiceReferences(serviceReferencesByName);
                return this.resetBackingService(sortedServiceReferences[0]);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            logger.log(Level.SEVERE, "An error in the filter syntax for this OSGi lookup has occurred.", invalidSyntaxException);
        }
        return false;
    }

    private boolean resetBackingService(ServiceReference serviceReference) {
        this.m_serviceTracker = new ServiceTracker(this.m_callerBundleContext, serviceReference, null);
        this.m_serviceTracker.open();
        this.m_osgiService = this.m_serviceTracker.getService();
        return this.m_osgiService != null;
    }

    private class ServiceInvokeAction
    extends ReflectiveInvokeAction {
        ServiceInvokeAction(Method method, Object[] args) {
            super(method, args);
        }

        @Override
        public Object invokeMethod(Method method, Object[] args) throws Throwable {
            return ServiceInvocationHandler.this.handleMethodInvocation(method, args);
        }
    }
}

