/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import org.eclipse.gemini.naming.CloseableContextManager;
import org.eclipse.gemini.naming.SecurityUtils;

class SecurityAwareContextManagerImpl
implements CloseableContextManager {
    private static final Logger logger = Logger.getLogger(SecurityAwareContextManagerImpl.class.getName());
    private final CloseableContextManager m_contextManager;

    public SecurityAwareContextManagerImpl(CloseableContextManager contextManager) {
        this.m_contextManager = contextManager;
    }

    @Override
    public Context newInitialContext() throws NamingException {
        return (Context)SecurityAwareContextManagerImpl.invokePrivilegedAction(new NewInitialContextAction());
    }

    @Override
    public Context newInitialContext(Map environment) throws NamingException {
        return (Context)SecurityAwareContextManagerImpl.invokePrivilegedAction(new NewInitialContextWithEnvironmentAction(environment));
    }

    @Override
    public DirContext newInitialDirContext() throws NamingException {
        return (DirContext)SecurityAwareContextManagerImpl.invokePrivilegedAction(new NewInitialDirContextAction());
    }

    @Override
    public DirContext newInitialDirContext(Map environment) throws NamingException {
        return (DirContext)SecurityAwareContextManagerImpl.invokePrivilegedAction(new NewInitialDirContextWithEnvironmentAction(environment));
    }

    @Override
    public void close() {
        SecurityAwareContextManagerImpl.invokePrivilegedActionWithoutReturn(new CloseContextManagerAction());
    }

    private static Object invokePrivilegedAction(PrivilegedExceptionAction action) throws NamingException {
        try {
            return SecurityUtils.invokePrivilegedAction(action);
        }
        catch (Exception exception) {
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            SecurityAwareContextManagerImpl.logExceptionFromPrivilegedAction(exception);
            NoInitialContextException namingException = new NoInitialContextException("Error occurred during a privileged operation");
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private static void invokePrivilegedActionWithoutReturn(PrivilegedExceptionAction action) {
        try {
            SecurityUtils.invokePrivilegedActionNoReturn(action);
        }
        catch (Exception exception) {
            SecurityAwareContextManagerImpl.logExceptionFromPrivilegedAction(exception);
        }
    }

    private static void logExceptionFromPrivilegedAction(Exception e) {
        logger.log(Level.FINE, "Exception occurred while invoking a PrivilegedAction", e);
    }

    private class CloseContextManagerAction
    implements PrivilegedExceptionAction {
        private CloseContextManagerAction() {
        }

        public Object run() throws Exception {
            SecurityAwareContextManagerImpl.this.m_contextManager.close();
            return null;
        }
    }

    private class NewInitialContextAction
    implements PrivilegedExceptionAction {
        private NewInitialContextAction() {
        }

        public Object run() throws Exception {
            return SecurityAwareContextManagerImpl.this.m_contextManager.newInitialContext();
        }
    }

    private class NewInitialContextWithEnvironmentAction
    implements PrivilegedExceptionAction {
        private final Map m_environment;

        public NewInitialContextWithEnvironmentAction(Map environment) {
            this.m_environment = environment;
        }

        public Object run() throws Exception {
            return SecurityAwareContextManagerImpl.this.m_contextManager.newInitialContext(this.m_environment);
        }
    }

    private class NewInitialDirContextAction
    implements PrivilegedExceptionAction {
        private NewInitialDirContextAction() {
        }

        public Object run() throws Exception {
            return SecurityAwareContextManagerImpl.this.m_contextManager.newInitialDirContext();
        }
    }

    private class NewInitialDirContextWithEnvironmentAction
    implements PrivilegedExceptionAction {
        private final Map m_environment;

        public NewInitialDirContextWithEnvironmentAction(Map environment) {
            this.m_environment = environment;
        }

        public Object run() throws Exception {
            return SecurityAwareContextManagerImpl.this.m_contextManager.newInitialDirContext(this.m_environment);
        }
    }
}

