/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.parser.MediaType;

public class HttpParser {
    private static final Integer FIELD_TYPE_TOKEN = 0;
    private static final Integer FIELD_TYPE_QUOTED_STRING = 1;
    private static final Integer FIELD_TYPE_TOKEN_OR_QUOTED_STRING = 2;
    private static final Integer FIELD_TYPE_LHEX = 3;
    private static final Integer FIELD_TYPE_QUOTED_LHEX = 4;
    private static final Integer FIELD_TYPE_QUOTED_TOKEN = 5;
    private static final Map<String, Integer> fieldTypes = new HashMap<String, Integer>();
    private static final boolean[] isToken = new boolean[128];
    private static final boolean[] isHex = new boolean[128];

    public static Map<String, String> parseAuthorizationDigest(StringReader input) throws IllegalArgumentException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (HttpParser.skipConstant(input, "Digest") != SkipConstantResult.FOUND) {
            return null;
        }
        String field = HttpParser.readToken(input);
        if (field == null) {
            return null;
        }
        while (!field.equals("")) {
            if (HttpParser.skipConstant(input, "=") != SkipConstantResult.FOUND) {
                return null;
            }
            String value = null;
            Integer type = fieldTypes.get(field.toLowerCase(Locale.US));
            if (type == null) {
                type = FIELD_TYPE_TOKEN_OR_QUOTED_STRING;
            }
            switch (type) {
                case 0: {
                    value = HttpParser.readToken(input);
                    break;
                }
                case 1: {
                    value = HttpParser.readQuotedString(input, false);
                    break;
                }
                case 2: {
                    value = HttpParser.readTokenOrQuotedString(input, false);
                    break;
                }
                case 3: {
                    value = HttpParser.readLhex(input);
                    break;
                }
                case 4: {
                    value = HttpParser.readQuotedLhex(input);
                    break;
                }
                case 5: {
                    value = HttpParser.readQuotedToken(input);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TODO i18n: Unsupported type");
                }
            }
            if (value == null) {
                return null;
            }
            result.put(field, value);
            if (HttpParser.skipConstant(input, ",") == SkipConstantResult.NOT_FOUND) {
                return null;
            }
            field = HttpParser.readToken(input);
            if (field != null) continue;
            return null;
        }
        return result;
    }

    public static MediaType parseMediaType(StringReader input) throws IOException {
        String type = HttpParser.readToken(input);
        if (type == null || type.length() == 0) {
            return null;
        }
        if (HttpParser.skipConstant(input, "/") == SkipConstantResult.NOT_FOUND) {
            return null;
        }
        String subtype = HttpParser.readToken(input);
        if (subtype == null || subtype.length() == 0) {
            return null;
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        SkipConstantResult lookForSemiColon = HttpParser.skipConstant(input, ";");
        if (lookForSemiColon == SkipConstantResult.NOT_FOUND) {
            return null;
        }
        while (lookForSemiColon == SkipConstantResult.FOUND) {
            String attribute = HttpParser.readToken(input);
            if (HttpParser.skipConstant(input, "=") == SkipConstantResult.FOUND) {
                String value = HttpParser.readTokenOrQuotedString(input, true);
                parameters.put(attribute.toLowerCase(Locale.US), value);
            } else {
                parameters.put(attribute.toLowerCase(Locale.US), "");
            }
            if ((lookForSemiColon = HttpParser.skipConstant(input, ";")) != SkipConstantResult.NOT_FOUND) continue;
            return null;
        }
        return new MediaType(type, subtype, parameters);
    }

    public static String unquote(String input) {
        if (input == null || input.length() < 2 || input.charAt(0) != '\"') {
            return input;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < input.length() - 1; ++i) {
            char c = input.charAt(i);
            if (input.charAt(i) == '\\') {
                result.append(input.charAt(++i));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isToken(int c) {
        try {
            return isToken[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    private static boolean isHex(int c) {
        try {
            return isHex[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    private static SkipConstantResult skipConstant(StringReader input, String constant) throws IOException {
        int len = constant.length();
        int c = input.read();
        while (c == 32 || c == 9) {
            c = input.read();
        }
        for (int i = 0; i < len; ++i) {
            if (i == 0 && c == -1) {
                return SkipConstantResult.EOF;
            }
            if (c != constant.charAt(i)) {
                input.skip(-(i + 1));
                return SkipConstantResult.NOT_FOUND;
            }
            if (i == len - 1) continue;
            c = input.read();
        }
        return SkipConstantResult.FOUND;
    }

    private static String readToken(StringReader input) throws IOException {
        StringBuilder result = new StringBuilder();
        int c = input.read();
        while (c == 32 || c == 9) {
            c = input.read();
        }
        while (c != -1 && HttpParser.isToken(c)) {
            result.append((char)c);
            c = input.read();
        }
        input.skip(-1L);
        if (c != -1 && result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    private static String readQuotedString(StringReader input, boolean returnQuoted) throws IOException {
        int c = input.read();
        while (c == 32 || c == 9) {
            c = input.read();
        }
        if (c != 34) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (returnQuoted) {
            result.append('\"');
        }
        c = input.read();
        while (c != 34) {
            if (c == -1) {
                return null;
            }
            if (c == 92) {
                c = input.read();
                if (returnQuoted) {
                    result.append('\\');
                }
                result.append(c);
            } else {
                result.append((char)c);
            }
            c = input.read();
        }
        if (returnQuoted) {
            result.append('\"');
        }
        return result.toString();
    }

    private static String readTokenOrQuotedString(StringReader input, boolean returnQuoted) throws IOException {
        input.mark(1);
        int c = input.read();
        input.reset();
        if (c == 34) {
            return HttpParser.readQuotedString(input, returnQuoted);
        }
        return HttpParser.readToken(input);
    }

    private static String readQuotedToken(StringReader input) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        int c = input.read();
        while (c == 32 || c == 9) {
            c = input.read();
        }
        if (c == 34) {
            quoted = true;
        } else {
            if (c == -1) {
                return null;
            }
            result.append((char)c);
        }
        c = input.read();
        while (c != -1 && HttpParser.isToken(c)) {
            result.append((char)c);
            c = input.read();
        }
        if (quoted) {
            if (c != 34) {
                return null;
            }
        } else {
            input.skip(-1L);
        }
        if (c != -1 && result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    private static String readLhex(StringReader input) throws IOException {
        StringBuilder result = new StringBuilder();
        int c = input.read();
        while (c == 32 || c == 9) {
            c = input.read();
        }
        while (c != -1 && HttpParser.isHex(c)) {
            result.append((char)c);
            c = input.read();
        }
        input.skip(-1L);
        if (result.length() == 0) {
            return null;
        }
        return result.toString().toLowerCase(Locale.US);
    }

    private static String readQuotedLhex(StringReader input) throws IOException {
        if (HttpParser.skipConstant(input, "\"") != SkipConstantResult.FOUND) {
            return null;
        }
        String result = HttpParser.readLhex(input);
        if (HttpParser.skipConstant(input, "\"") == SkipConstantResult.NOT_FOUND) {
            return null;
        }
        return result;
    }

    static {
        fieldTypes.put("username", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("realm", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("nonce", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("digest-uri", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("response", FIELD_TYPE_QUOTED_LHEX);
        fieldTypes.put("algorithm", FIELD_TYPE_TOKEN);
        fieldTypes.put("cnonce", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("opaque", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("qop", FIELD_TYPE_QUOTED_TOKEN);
        fieldTypes.put("nc", FIELD_TYPE_LHEX);
        for (int i = 0; i < 128; ++i) {
            HttpParser.isToken[i] = i < 32 ? false : i != 40 && i != 41 && i != 60 && i != 62 && i != 64 && i != 44 && i != 59 && i != 58 && i != 92 && i != 34 && i != 47 && i != 91 && i != 93 && i != 63 && i != 61 && i != 123 && i != 125 && i != 32 && i != 9;
            HttpParser.isHex[i] = i >= 48 && i <= 57 || i >= 65 && i <= 70 || i >= 97 && i <= 102;
        }
    }

    private static enum SkipConstantResult {
        FOUND,
        NOT_FOUND,
        EOF;

    }
}

