/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.servlets.WebdavStatus;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.XMLWriter;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.security.MD5Encoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    protected static MessageDigest md5Helper;
    @Deprecated
    protected static final MD5Encoder md5Encoder;
    private Hashtable<String, LockInfo> resourceLocks = new Hashtable();
    private Hashtable<String, Vector<String>> lockNullResources = new Hashtable();
    private Vector<LockInfo> collectionLocks = new Vector();
    private String secret = "catalina";
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("secret") != null) {
            this.secret = this.getServletConfig().getInitParameter("secret");
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnavailableException("No MD5");
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException e) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        if (this.isSpecialPath(path)) {
            resp.sendError(404);
            return;
        }
        String method = req.getMethod();
        if (this.debug > 0) {
            this.log("[" + method + "] " + path);
        }
        if (method.equals(METHOD_PROPFIND)) {
            this.doPropfind(req, resp);
        } else if (method.equals(METHOD_PROPPATCH)) {
            this.doProppatch(req, resp);
        } else if (method.equals(METHOD_MKCOL)) {
            this.doMkcol(req, resp);
        } else if (method.equals(METHOD_COPY)) {
            this.doCopy(req, resp);
        } else if (method.equals(METHOD_MOVE)) {
            this.doMove(req, resp);
        } else if (method.equals(METHOD_LOCK)) {
            this.doLock(req, resp);
        } else if (method.equals(METHOD_UNLOCK)) {
            this.doUnlock(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    private final boolean isSpecialPath(String path) {
        return !this.allowSpecialPaths && (path.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || path.toUpperCase(Locale.ENGLISH).startsWith("/META-INF"));
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, ResourceAttributes resourceAttributes) throws IOException {
        return super.checkIfHeaders(request, response, resourceAttributes);
    }

    @Override
    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    @Override
    protected String getPathPrefix(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (request.getServletPath() != null) {
            contextPath = contextPath + request.getServletPath();
        }
        return contextPath;
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addHeader("DAV", "1,2");
        StringBuilder methodsAllowed = this.determineMethodsAllowed(this.resources, req);
        resp.addHeader("Allow", methodsAllowed.toString());
        resp.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object object;
        boolean exists;
        int type;
        int depth;
        Vector<String> properties;
        String path;
        block44: {
            if (!this.listings) {
                StringBuilder methodsAllowed = this.determineMethodsAllowed(this.resources, req);
                resp.addHeader("Allow", methodsAllowed.toString());
                resp.sendError(405);
                return;
            }
            path = this.getRelativePath(req);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            properties = null;
            depth = this.maxDepth;
            type = 1;
            String depthStr = req.getHeader("Depth");
            if (depthStr == null) {
                depth = this.maxDepth;
            } else if (depthStr.equals("0")) {
                depth = 0;
            } else if (depthStr.equals("1")) {
                depth = 1;
            } else if (depthStr.equals("infinity")) {
                depth = this.maxDepth;
            }
            Node propNode = null;
            if (req.getContentLength() > 0) {
                DocumentBuilder documentBuilder = this.getDocumentBuilder();
                try {
                    Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                    Element rootElement = document.getDocumentElement();
                    NodeList childList = rootElement.getChildNodes();
                    block17: for (int i = 0; i < childList.getLength(); ++i) {
                        Node currentNode = childList.item(i);
                        switch (currentNode.getNodeType()) {
                            case 3: {
                                continue block17;
                            }
                            case 1: {
                                if (currentNode.getNodeName().endsWith("prop")) {
                                    type = 0;
                                    propNode = currentNode;
                                }
                                if (currentNode.getNodeName().endsWith("propname")) {
                                    type = 2;
                                }
                                if (!currentNode.getNodeName().endsWith("allprop")) continue block17;
                                type = 1;
                            }
                        }
                    }
                }
                catch (SAXException e) {
                    resp.sendError(400);
                    return;
                }
                catch (IOException e) {
                    resp.sendError(400);
                    return;
                }
            }
            if (type == 0) {
                properties = new Vector<String>();
                NodeList childList = propNode.getChildNodes();
                block18: for (int i = 0; i < childList.getLength(); ++i) {
                    Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block18;
                        }
                        case 1: {
                            String nodeName = currentNode.getNodeName();
                            String propertyName = null;
                            propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                            properties.addElement(propertyName);
                        }
                    }
                }
            }
            exists = true;
            object = null;
            try {
                object = this.resources.lookup(path);
            }
            catch (NamingException e) {
                String parentPath;
                Vector<String> currentLockNullResources;
                exists = false;
                int slash = path.lastIndexOf(47);
                if (slash == -1 || (currentLockNullResources = this.lockNullResources.get(parentPath = path.substring(0, slash))) == null) break block44;
                Enumeration<String> lockNullResourcesList = currentLockNullResources.elements();
                while (lockNullResourcesList.hasMoreElements()) {
                    String lockNullPath = lockNullResourcesList.nextElement();
                    if (!lockNullPath.equals(path)) continue;
                    resp.setStatus(207);
                    resp.setContentType("text/xml; charset=UTF-8");
                    XMLWriter generatedXML = new XMLWriter(resp.getWriter());
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                    generatedXML.writeElement("D", "multistatus", 1);
                    generatedXML.sendData();
                    return;
                }
            }
        }
        if (!exists) {
            resp.sendError(404, path);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter(resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (depth == 0) {
            this.parseProperties(req, generatedXML, path, type, properties);
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(path);
            Stack<String> stackBelow = new Stack<String>();
            while (!stack.isEmpty() && depth >= 0) {
                String currentPath = (String)stack.pop();
                this.parseProperties(req, generatedXML, currentPath, type, properties);
                try {
                    object = this.resources.lookup(currentPath);
                }
                catch (NamingException e) {
                    continue;
                }
                if (object instanceof DirContext && depth > 0) {
                    Vector<String> currentLockNullResources;
                    try {
                        NamingEnumeration<NameClassPair> enumeration = this.resources.list(currentPath);
                        while (enumeration.hasMoreElements()) {
                            NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                            String newPath = currentPath;
                            if (!newPath.endsWith("/")) {
                                newPath = newPath + "/";
                            }
                            newPath = newPath + ncPair.getName();
                            stackBelow.push(newPath);
                        }
                    }
                    catch (NamingException e) {
                        resp.sendError(500, path);
                        return;
                    }
                    String lockPath = currentPath;
                    if (lockPath.endsWith("/")) {
                        lockPath = lockPath.substring(0, lockPath.length() - 1);
                    }
                    if ((currentLockNullResources = this.lockNullResources.get(lockPath)) != null) {
                        Enumeration<String> lockNullResourcesList = currentLockNullResources.elements();
                        while (lockNullResourcesList.hasMoreElements()) {
                            String lockNullPath = lockNullResourcesList.nextElement();
                            this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new Stack();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement("D", "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        resp.sendError(501);
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        boolean exists = true;
        try {
            this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (exists) {
            StringBuilder methodsAllowed = this.determineMethodsAllowed(this.resources, req);
            resp.addHeader("Allow", methodsAllowed.toString());
            resp.sendError(405);
            return;
        }
        if (req.getContentLength() > 0) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                resp.sendError(501);
                return;
            }
            catch (SAXException saxe) {
                resp.sendError(415);
                return;
            }
        }
        boolean result = true;
        try {
            this.resources.createSubcontext(path);
        }
        catch (NamingException e) {
            result = false;
        }
        if (!result) {
            resp.sendError(409, WebdavStatus.getStatusText(409));
        } else {
            resp.setStatus(201);
            this.lockNullResources.remove(path);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        this.deleteResource(req, resp);
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        super.doPut(req, resp);
        String path = this.getRelativePath(req);
        this.lockNullResources.remove(path);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        this.copyResource(req, resp);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        if (this.copyResource(req, resp)) {
            this.deleteResource(path, req, resp, false);
        }
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path;
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        LockInfo lock = new LockInfo();
        String depthStr = req.getHeader("Depth");
        lock.depth = depthStr == null ? this.maxDepth : (depthStr.equals("0") ? 0 : this.maxDepth);
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            int commaPos = lockDurationStr.indexOf(",");
            if (commaPos != -1) {
                lockDurationStr = lockDurationStr.substring(0, commaPos);
            }
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = new Integer(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = new Integer(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock.expiresAt = System.currentTimeMillis() + (long)(lockDuration * 1000);
        boolean lockRequestType = false;
        Node lockInfoNode = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            lockInfoNode = rootElement;
        }
        catch (IOException e) {
            lockRequestType = true;
        }
        catch (SAXException e) {
            lockRequestType = true;
        }
        if (lockInfoNode != null) {
            Node currentNode;
            int i;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            Node lockScopeNode = null;
            Node lockTypeNode = null;
            Node lockOwnerNode = null;
            block25: for (i = 0; i < childList.getLength(); ++i) {
                currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block25;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        if (nodeName.endsWith("lockscope")) {
                            lockScopeNode = currentNode;
                        }
                        if (nodeName.endsWith("locktype")) {
                            lockTypeNode = currentNode;
                        }
                        if (!nodeName.endsWith("owner")) continue block25;
                        lockOwnerNode = currentNode;
                    }
                }
            }
            if (lockScopeNode != null) {
                childList = lockScopeNode.getChildNodes();
                block26: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block26;
                        }
                        case 1: {
                            String tempScope = currentNode.getNodeName();
                            lock.scope = tempScope.indexOf(58) != -1 ? tempScope.substring(tempScope.indexOf(58) + 1) : tempScope;
                        }
                    }
                }
                if (lock.scope == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockTypeNode != null) {
                childList = lockTypeNode.getChildNodes();
                block27: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block27;
                        }
                        case 1: {
                            String tempType = currentNode.getNodeName();
                            lock.type = tempType.indexOf(58) != -1 ? tempType.substring(tempType.indexOf(58) + 1) : tempType;
                        }
                    }
                }
                if (lock.type == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                block28: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            lock.owner = lock.owner + currentNode.getNodeValue();
                            continue block28;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter(strWriter, true);
                            domWriter.setQualifiedNames(false);
                            domWriter.print(currentNode);
                            lock.owner = lock.owner + strWriter.toString();
                        }
                    }
                }
                if (lock.owner == null) {
                    resp.setStatus(400);
                }
            } else {
                lock.owner = "";
            }
        }
        lock.path = path = this.getRelativePath(req);
        boolean exists = true;
        Object object = null;
        try {
            object = this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        Enumeration<LockInfo> locksList = null;
        if (!lockRequestType) {
            String lockTokenStr = req.getServletPath() + "-" + lock.type + "-" + lock.scope + "-" + req.getUserPrincipal() + "-" + lock.depth + "-" + lock.owner + "-" + lock.tokens + "-" + lock.expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            String lockToken = MD5Encoder.encode((byte[])md5Helper.digest(lockTokenStr.getBytes(Charset.defaultCharset())));
            if (exists && object instanceof DirContext && lock.depth == this.maxDepth) {
                LockInfo currentLock;
                Vector<String> lockPaths = new Vector<String>();
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                locksList = this.resourceLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                if (!lockPaths.isEmpty()) {
                    Enumeration lockPathsList = lockPaths.elements();
                    resp.setStatus(409);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    while (lockPathsList.hasMoreElements()) {
                        generatedXML.writeElement("D", "response", 0);
                        generatedXML.writeElement("D", "href", 0);
                        generatedXML.writeText((String)lockPathsList.nextElement());
                        generatedXML.writeElement("D", "href", 1);
                        generatedXML.writeElement("D", "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 " + WebdavStatus.getStatusText(423));
                        generatedXML.writeElement("D", "status", 1);
                        generatedXML.writeElement("D", "response", 1);
                    }
                    generatedXML.writeElement("D", "multistatus", 1);
                    PrintWriter writer = resp.getWriter();
                    ((Writer)writer).write(generatedXML.toString());
                    ((Writer)writer).close();
                    return;
                }
                boolean addLock = true;
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock2 = locksList.nextElement();
                    if (!currentLock2.path.equals(lock.path)) continue;
                    if (currentLock2.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    if (lock.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    currentLock2.tokens.addElement(lockToken);
                    lock = currentLock2;
                    addLock = false;
                }
                if (addLock) {
                    lock.tokens.addElement(lockToken);
                    this.collectionLocks.addElement(lock);
                }
            } else {
                LockInfo presentLock = this.resourceLocks.get(lock.path);
                if (presentLock != null) {
                    if (presentLock.isExclusive() || lock.isExclusive()) {
                        resp.sendError(412);
                        return;
                    }
                    presentLock.tokens.addElement(lockToken);
                    lock = presentLock;
                } else {
                    lock.tokens.addElement(lockToken);
                    this.resourceLocks.put(lock.path, lock);
                    exists = true;
                    try {
                        object = this.resources.lookup(path);
                    }
                    catch (NamingException e) {
                        exists = false;
                    }
                    if (!exists) {
                        int slash = lock.path.lastIndexOf(47);
                        String parentPath = lock.path.substring(0, slash);
                        Vector<String> lockNulls = this.lockNullResources.get(parentPath);
                        if (lockNulls == null) {
                            lockNulls = new Vector();
                            this.lockNullResources.put(parentPath, lockNulls);
                        }
                        lockNulls.addElement(lock.path);
                    }
                    resp.addHeader("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
                }
            }
        }
        if (lockRequestType) {
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                ifHeader = "";
            }
            LockInfo toRenew = this.resourceLocks.get(path);
            Enumeration<String> tokenList = null;
            if (toRenew != null) {
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
            Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
            while (collectionLocksList.hasMoreElements()) {
                toRenew = collectionLocksList.nextElement();
                if (!path.equals(toRenew.path)) continue;
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        generatedXML.writeElement("D", "lockdiscovery", 0);
        lock.toXML(generatedXML);
        generatedXML.writeElement("D", "lockdiscovery", 1);
        generatedXML.writeElement("D", "prop", 1);
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            lockTokenHeader = "";
        }
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null) {
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
            }
            if (lock.tokens.isEmpty()) {
                this.resourceLocks.remove(path);
                this.lockNullResources.remove(path);
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (!path.equals(lock.path)) continue;
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
                break;
            }
            if (!lock.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lock);
            this.lockNullResources.remove(path);
        }
        resp.setStatus(204);
    }

    private boolean isLocked(HttpServletRequest req) {
        String lockTokenHeader;
        String path = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        return this.isLocked(path, ifHeader + lockTokenHeader);
    }

    private boolean isLocked(String path, String ifHeader) {
        LockInfo lock = this.resourceLocks.get(path);
        Enumeration<String> tokenList = null;
        if (lock != null && lock.hasExpired()) {
            this.resourceLocks.remove(path);
        } else if (lock != null) {
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
                break;
            }
            if (!tokenMatch) {
                return true;
            }
        }
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = collectionLocksList.nextElement();
            if (lock.hasExpired()) {
                this.collectionLocks.removeElement(lock);
                continue;
            }
            if (!path.startsWith(lock.path)) continue;
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
                break;
            }
            if (tokenMatch) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Hashtable<String, Integer> errorList;
        boolean result;
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return false;
        }
        int protocolIndex = (destinationPath = RequestUtil.URLDecode(destinationPath, "UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = org.apache.tomcat.util.http.RequestUtil.normalize((String)destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        if (this.debug > 0) {
            this.log("Dest path :" + destinationPath);
        }
        if (this.isSpecialPath(destinationPath)) {
            resp.sendError(403);
            return false;
        }
        String path = this.getRelativePath(req);
        if (destinationPath.equals(path)) {
            resp.sendError(403);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        boolean exists = true;
        try {
            this.resources.lookup(destinationPath);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (overwrite) {
            if (exists) {
                if (!this.deleteResource(destinationPath, req, resp, true)) {
                    return false;
                }
            } else {
                resp.setStatus(201);
            }
        } else if (exists) {
            resp.sendError(412);
            return false;
        }
        if (!(result = this.copyResource(this.resources, errorList = new Hashtable<String, Integer>(), path, destinationPath)) || !errorList.isEmpty()) {
            if (errorList.size() == 1) {
                resp.sendError(errorList.elements().nextElement().intValue());
            } else {
                this.sendReport(req, resp, errorList);
            }
            return false;
        }
        if (exists) {
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
        this.lockNullResources.remove(destinationPath);
        return true;
    }

    private boolean copyResource(DirContext dirContext, Hashtable<String, Integer> errorList, String source, String dest) {
        if (this.debug > 1) {
            this.log("Copy: " + source + " To: " + dest);
        }
        Object object = null;
        try {
            object = dirContext.lookup(source);
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (object instanceof DirContext) {
            try {
                dirContext.createSubcontext(dest);
            }
            catch (NamingException e) {
                errorList.put(dest, new Integer(409));
                return false;
            }
            try {
                NamingEnumeration<NameClassPair> enumeration = dirContext.list(source);
                while (enumeration.hasMoreElements()) {
                    NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                    String childDest = dest;
                    if (!childDest.equals("/")) {
                        childDest = childDest + "/";
                    }
                    childDest = childDest + ncPair.getName();
                    String childSrc = source;
                    if (!childSrc.equals("/")) {
                        childSrc = childSrc + "/";
                    }
                    childSrc = childSrc + ncPair.getName();
                    this.copyResource(dirContext, errorList, childSrc, childDest);
                }
            }
            catch (NamingException e) {
                errorList.put(dest, new Integer(500));
                return false;
            }
        }
        if (object instanceof Resource) {
            try {
                dirContext.bind(dest, object);
            }
            catch (NamingException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    errorList.put(source, new Integer(409));
                } else {
                    errorList.put(source, new Integer(500));
                }
                return false;
            }
        } else {
            errorList.put(source, new Integer(500));
            return false;
        }
        return true;
    }

    private boolean deleteResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = this.getRelativePath(req);
        return this.deleteResource(path, req, resp, true);
    }

    private boolean deleteResource(String path, HttpServletRequest req, HttpServletResponse resp, boolean setStatus) throws IOException {
        String lockTokenHeader;
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        if (this.isLocked(path, ifHeader + lockTokenHeader)) {
            resp.sendError(423);
            return false;
        }
        boolean exists = true;
        Object object = null;
        try {
            object = this.resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (!exists) {
            resp.sendError(404);
            return false;
        }
        boolean collection = object instanceof DirContext;
        if (!collection) {
            try {
                this.resources.unbind(path);
            }
            catch (NamingException e) {
                resp.sendError(500);
                return false;
            }
        }
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        this.deleteCollection(req, this.resources, path, errorList);
        try {
            this.resources.unbind(path);
        }
        catch (NamingException e) {
            errorList.put(path, new Integer(500));
        }
        if (!errorList.isEmpty()) {
            this.sendReport(req, resp, errorList);
            return false;
        }
        if (setStatus) {
            resp.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest req, DirContext dirContext, String path, Hashtable<String, Integer> errorList) {
        String lockTokenHeader;
        if (this.debug > 1) {
            this.log("Delete:" + path);
        }
        if (this.isSpecialPath(path)) {
            errorList.put(path, new Integer(403));
            return;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        NamingEnumeration<NameClassPair> enumeration = null;
        try {
            enumeration = dirContext.list(path);
        }
        catch (NamingException e) {
            errorList.put(path, new Integer(500));
            return;
        }
        while (enumeration.hasMoreElements()) {
            NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
            String childName = path;
            if (!childName.equals("/")) {
                childName = childName + "/";
            }
            if (this.isLocked(childName = childName + ncPair.getName(), ifHeader + lockTokenHeader)) {
                errorList.put(childName, new Integer(423));
                continue;
            }
            try {
                Object object = dirContext.lookup(childName);
                if (object instanceof DirContext) {
                    this.deleteCollection(req, dirContext, childName, errorList);
                }
                try {
                    dirContext.unbind(childName);
                }
                catch (NamingException e) {
                    if (object instanceof DirContext) continue;
                    errorList.put(childName, new Integer(500));
                }
            }
            catch (NamingException e) {
                errorList.put(childName, new Integer(500));
            }
        }
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable<String, Integer> errorList) throws IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        Enumeration<String> pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = pathList.nextElement();
            int errorCode = errorList.get(errorPath);
            generatedXML.writeElement("D", "response", 0);
            generatedXML.writeElement("D", "href", 0);
            String toAppend = errorPath.substring(relativePath.length());
            if (!toAppend.startsWith("/")) {
                toAppend = "/" + toAppend;
            }
            generatedXML.writeText(absoluteUri + toAppend);
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
            generatedXML.writeElement("D", "status", 1);
            generatedXML.writeElement("D", "response", 1);
        }
        generatedXML.writeElement("D", "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void parseProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (this.isSpecialPath(path)) {
            return;
        }
        CacheEntry cacheEntry = this.resources.lookupCache(path);
        if (!cacheEntry.exists) {
            return;
        }
        generatedXML.writeElement("D", "response", 0);
        String status = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        generatedXML.writeElement("D", "href", 0);
        String href = req.getContextPath() + req.getServletPath();
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (cacheEntry.context != null && !href.endsWith("/")) {
            href = href + "/";
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement("D", "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(cacheEntry.attributes.getCreation()));
                generatedXML.writeElement("D", "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("D", "displayname", 1);
                if (cacheEntry.resource != null) {
                    generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)cacheEntry.attributes.getLastModified(), null));
                    generatedXML.writeProperty("D", "getcontentlength", String.valueOf(cacheEntry.attributes.getContentLength()));
                    String contentType = this.getServletContext().getMimeType(cacheEntry.name);
                    if (contentType != null) {
                        generatedXML.writeProperty("D", "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty("D", "getetag", cacheEntry.attributes.getETag());
                    generatedXML.writeElement("D", "resourcetype", 2);
                } else {
                    generatedXML.writeElement("D", "resourcetype", 0);
                    generatedXML.writeElement("D", "collection", 2);
                    generatedXML.writeElement("D", "resourcetype", 1);
                }
                generatedXML.writeProperty("D", "source", "");
                String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                generatedXML.writeElement("D", "displayname", 2);
                if (cacheEntry.resource != null) {
                    generatedXML.writeElement("D", "getcontentlanguage", 2);
                    generatedXML.writeElement("D", "getcontentlength", 2);
                    generatedXML.writeElement("D", "getcontenttype", 2);
                    generatedXML.writeElement("D", "getetag", 2);
                    generatedXML.writeElement("D", "getlastmodified", 2);
                }
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "source", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(cacheEntry.attributes.getCreation()));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement("D", "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeElement("D", "getcontentlanguage", 2);
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getcontentlength", String.valueOf(cacheEntry.attributes.getContentLength()));
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getcontenttype", this.getServletContext().getMimeType(cacheEntry.name));
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getetag", cacheEntry.attributes.getETag());
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (cacheEntry.context != null) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)cacheEntry.attributes.getLastModified(), null));
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (cacheEntry.context != null) {
                            generatedXML.writeElement("D", "resourcetype", 0);
                            generatedXML.writeElement("D", "collection", 2);
                            generatedXML.writeElement("D", "resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement("D", "resourcetype", 2);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty("D", "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement("D", (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private void parseLockNullProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (this.isSpecialPath(path)) {
            return;
        }
        LockInfo lock = this.resourceLocks.get(path);
        if (lock == null) {
            return;
        }
        generatedXML.writeElement("D", "response", 0);
        String status = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        generatedXML.writeElement("D", "href", 0);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        String toAppend = path.substring(relativePath.length());
        if (!toAppend.startsWith("/")) {
            toAppend = "/" + toAppend;
        }
        generatedXML.writeText(this.rewriteUrl(org.apache.tomcat.util.http.RequestUtil.normalize((String)(absoluteUri + toAppend))));
        generatedXML.writeElement("D", "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                generatedXML.writeElement("D", "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("D", "displayname", 1);
                generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)lock.creationDate.getTime(), null));
                generatedXML.writeProperty("D", "getcontentlength", String.valueOf(0));
                generatedXML.writeProperty("D", "getcontenttype", "");
                generatedXML.writeProperty("D", "getetag", "");
                generatedXML.writeElement("D", "resourcetype", 0);
                generatedXML.writeElement("D", "lock-null", 2);
                generatedXML.writeElement("D", "resourcetype", 1);
                generatedXML.writeProperty("D", "source", "");
                String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                generatedXML.writeElement("D", "displayname", 2);
                generatedXML.writeElement("D", "getcontentlanguage", 2);
                generatedXML.writeElement("D", "getcontentlength", 2);
                generatedXML.writeElement("D", "getcontenttype", 2);
                generatedXML.writeElement("D", "getetag", 2);
                generatedXML.writeElement("D", "getlastmodified", 2);
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "source", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement("D", "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        generatedXML.writeElement("D", "getcontentlanguage", 2);
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        generatedXML.writeProperty("D", "getcontentlength", String.valueOf(0));
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        generatedXML.writeProperty("D", "getcontenttype", "");
                        continue;
                    }
                    if (property.equals("getetag")) {
                        generatedXML.writeProperty("D", "getetag", "");
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        generatedXML.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)lock.creationDate.getTime(), null));
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "lock-null", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty("D", "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement("D", (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String path, XMLWriter generatedXML) {
        LockInfo resourceLock = this.resourceLocks.get(path);
        Enumeration<LockInfo> collectionLocksList = this.collectionLocks.elements();
        boolean wroteStart = false;
        if (resourceLock != null) {
            wroteStart = true;
            generatedXML.writeElement("D", "lockdiscovery", 0);
            resourceLock.toXML(generatedXML);
        }
        while (collectionLocksList.hasMoreElements()) {
            LockInfo currentLock = collectionLocksList.nextElement();
            if (!path.startsWith(currentLock.path)) continue;
            if (!wroteStart) {
                wroteStart = true;
                generatedXML.writeElement("D", "lockdiscovery", 0);
            }
            currentLock.toXML(generatedXML);
        }
        if (!wroteStart) {
            return false;
        }
        generatedXML.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long creationDate) {
        StringBuilder creationDateValue = new StringBuilder(creationDateFormat.format(new Date(creationDate)));
        return creationDateValue.toString();
    }

    private StringBuilder determineMethodsAllowed(DirContext dirContext, HttpServletRequest req) {
        StringBuilder methodsAllowed = new StringBuilder();
        boolean exists = true;
        Object object = null;
        try {
            String path = this.getRelativePath(req);
            object = dirContext.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (!exists) {
            methodsAllowed.append("OPTIONS, MKCOL, PUT, LOCK");
            return methodsAllowed;
        }
        methodsAllowed.append("OPTIONS, GET, HEAD, POST, DELETE, TRACE");
        methodsAllowed.append(", PROPPATCH, COPY, MOVE, LOCK, UNLOCK");
        if (this.listings) {
            methodsAllowed.append(", PROPFIND");
        }
        if (!(object instanceof DirContext)) {
            methodsAllowed.append(", PUT");
        }
        return methodsAllowed;
    }

    static {
        md5Encoder = new MD5Encoder();
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class LockInfo {
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector<String> tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public String toString() {
            StringBuilder result = new StringBuilder("Type:");
            result.append(this.type);
            result.append("\nScope:");
            result.append(this.scope);
            result.append("\nDepth:");
            result.append(this.depth);
            result.append("\nOwner:");
            result.append(this.owner);
            result.append("\nExpiration:");
            result.append(FastHttpDateFormat.formatDate((long)this.expiresAt, null));
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                result.append("\nToken:");
                result.append(tokensList.nextElement());
            }
            result.append("\n");
            return result.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter generatedXML) {
            generatedXML.writeElement("D", "activelock", 0);
            generatedXML.writeElement("D", "locktype", 0);
            generatedXML.writeElement("D", this.type, 2);
            generatedXML.writeElement("D", "locktype", 1);
            generatedXML.writeElement("D", "lockscope", 0);
            generatedXML.writeElement("D", this.scope, 2);
            generatedXML.writeElement("D", "lockscope", 1);
            generatedXML.writeElement("D", "depth", 0);
            if (this.depth == WebdavServlet.this.maxDepth) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText("0");
            }
            generatedXML.writeElement("D", "depth", 1);
            generatedXML.writeElement("D", "owner", 0);
            generatedXML.writeText(this.owner);
            generatedXML.writeElement("D", "owner", 1);
            generatedXML.writeElement("D", "timeout", 0);
            long timeout = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            generatedXML.writeText("Second-" + timeout);
            generatedXML.writeElement("D", "timeout", 1);
            generatedXML.writeElement("D", "locktoken", 0);
            Enumeration<String> tokensList = this.tokens.elements();
            while (tokensList.hasMoreElements()) {
                generatedXML.writeElement("D", "href", 0);
                generatedXML.writeText("opaquelocktoken:" + tokensList.nextElement());
                generatedXML.writeElement("D", "href", 1);
            }
            generatedXML.writeElement("D", "locktoken", 1);
            generatedXML.writeElement("D", "activelock", 1);
        }
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        public WebdavResolver(ServletContext theContext) {
            this.context = theContext;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.enternalEntityIgnored", new Object[]{publicId, systemId}));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }
}

