/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.support;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.gemini.web.tomcat.internal.support.BundleDependencyDeterminer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackageAdminBundleDependencyDeterminer
implements BundleDependencyDeterminer {
    private final BundleContext bundleContext;
    private final PackageAdmin packageAdmin;

    public PackageAdminBundleDependencyDeterminer(BundleContext bundleContext, PackageAdmin packageAdmin) {
        this.bundleContext = bundleContext;
        this.packageAdmin = packageAdmin;
    }

    @Override
    public Set<Bundle> getDependencies(Bundle rootBundle) {
        HashSet<Bundle> dependencies = new HashSet<Bundle>();
        Bundle[] bundles = this.bundleContext.getBundles();
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(bundle);
                if (exportedPackages != null) {
                    ExportedPackage[] exportedPackageArray = exportedPackages;
                    int n3 = exportedPackages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExportedPackage exportedPackage = exportedPackageArray[n4];
                        Bundle[] importers = exportedPackage.getImportingBundles();
                        if (importers != null) {
                            Bundle[] bundleArray2 = importers;
                            int n5 = importers.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Bundle importer = bundleArray2[n6];
                                if (importer.equals(rootBundle)) {
                                    dependencies.add(bundle);
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return dependencies;
    }
}

