/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ArrayToArrayConverter;
import org.springframework.core.convert.support.ArrayToCollectionConverter;
import org.springframework.core.convert.support.ArrayToObjectConverter;
import org.springframework.core.convert.support.ArrayToStringConverter;
import org.springframework.core.convert.support.CharacterToNumberFactory;
import org.springframework.core.convert.support.CollectionToArrayConverter;
import org.springframework.core.convert.support.CollectionToCollectionConverter;
import org.springframework.core.convert.support.CollectionToObjectConverter;
import org.springframework.core.convert.support.CollectionToStringConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.IdToEntityConverter;
import org.springframework.core.convert.support.MapToMapConverter;
import org.springframework.core.convert.support.NumberToCharacterConverter;
import org.springframework.core.convert.support.NumberToNumberConverterFactory;
import org.springframework.core.convert.support.ObjectToArrayConverter;
import org.springframework.core.convert.support.ObjectToCollectionConverter;
import org.springframework.core.convert.support.ObjectToObjectConverter;
import org.springframework.core.convert.support.ObjectToStringConverter;
import org.springframework.core.convert.support.PropertiesToStringConverter;
import org.springframework.core.convert.support.StringToArrayConverter;
import org.springframework.core.convert.support.StringToBooleanConverter;
import org.springframework.core.convert.support.StringToCharacterConverter;
import org.springframework.core.convert.support.StringToCollectionConverter;
import org.springframework.core.convert.support.StringToEnumConverterFactory;
import org.springframework.core.convert.support.StringToLocaleConverter;
import org.springframework.core.convert.support.StringToNumberConverterFactory;
import org.springframework.core.convert.support.StringToPropertiesConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConversionServiceFactory {
    public static GenericConversionService createDefaultConversionService() {
        GenericConversionService conversionService = new GenericConversionService();
        ConversionServiceFactory.addDefaultConverters(conversionService);
        return conversionService;
    }

    public static void addDefaultConverters(GenericConversionService conversionService) {
        conversionService.addConverter(new ArrayToCollectionConverter(conversionService));
        conversionService.addConverter(new CollectionToArrayConverter(conversionService));
        conversionService.addConverter(new ArrayToStringConverter(conversionService));
        conversionService.addConverter(new StringToArrayConverter(conversionService));
        conversionService.addConverter(new ArrayToObjectConverter(conversionService));
        conversionService.addConverter(new ObjectToArrayConverter(conversionService));
        conversionService.addConverter(new CollectionToStringConverter(conversionService));
        conversionService.addConverter(new StringToCollectionConverter(conversionService));
        conversionService.addConverter(new CollectionToObjectConverter(conversionService));
        conversionService.addConverter(new ObjectToCollectionConverter(conversionService));
        conversionService.addConverter(new ArrayToArrayConverter(conversionService));
        conversionService.addConverter(new CollectionToCollectionConverter(conversionService));
        conversionService.addConverter(new MapToMapConverter(conversionService));
        conversionService.addConverter(new PropertiesToStringConverter());
        conversionService.addConverter(new StringToPropertiesConverter());
        conversionService.addConverter(new StringToBooleanConverter());
        conversionService.addConverter(new StringToCharacterConverter());
        conversionService.addConverter(new StringToLocaleConverter());
        conversionService.addConverterFactory(new StringToNumberConverterFactory());
        conversionService.addConverterFactory(new StringToEnumConverterFactory());
        conversionService.addConverter(new NumberToCharacterConverter());
        conversionService.addConverterFactory(new CharacterToNumberFactory());
        conversionService.addConverterFactory(new NumberToNumberConverterFactory());
        conversionService.addConverter(new ObjectToStringConverter());
        conversionService.addConverter(new ObjectToObjectConverter());
        conversionService.addConverter(new IdToEntityConverter(conversionService));
    }

    public static void registerConverters(Set<Object> converters, ConverterRegistry registry) {
        if (converters != null) {
            for (Object converter : converters) {
                if (converter instanceof GenericConverter) {
                    registry.addConverter((GenericConverter)converter);
                    continue;
                }
                if (converter instanceof Converter) {
                    registry.addConverter((Converter)converter);
                    continue;
                }
                if (converter instanceof ConverterFactory) {
                    registry.addConverterFactory((ConverterFactory)converter);
                    continue;
                }
                throw new IllegalArgumentException("Each converter object must implement one of the Converter, ConverterFactory, or GenericConverter interfaces");
            }
        }
    }
}

