/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScopeMetadataResolver
implements ScopeMetadataResolver {
    private Class<? extends Annotation> scopeAnnotationType = Scope.class;
    private final ScopedProxyMode defaultProxyMode;

    public AnnotationScopeMetadataResolver() {
        this.defaultProxyMode = ScopedProxyMode.NO;
    }

    public AnnotationScopeMetadataResolver(ScopedProxyMode defaultProxyMode) {
        Assert.notNull((Object)((Object)defaultProxyMode), (String)"'defaultProxyMode' must not be null");
        this.defaultProxyMode = defaultProxyMode;
    }

    public void setScopeAnnotationType(Class<? extends Annotation> scopeAnnotationType) {
        Assert.notNull(scopeAnnotationType, (String)"'scopeAnnotationType' must not be null");
        this.scopeAnnotationType = scopeAnnotationType;
    }

    @Override
    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        ScopeMetadata metadata = new ScopeMetadata();
        if (definition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annDef = (AnnotatedBeanDefinition)definition;
            Map attributes = annDef.getMetadata().getAnnotationAttributes(this.scopeAnnotationType.getName());
            ScopedProxyMode annMode = null;
            if (attributes != null) {
                metadata.setScopeName((String)attributes.get("value"));
                annMode = (ScopedProxyMode)((Object)attributes.get("proxyMode"));
            }
            if (annMode != null && annMode != ScopedProxyMode.DEFAULT) {
                metadata.setScopedProxyMode(annMode);
            } else if (!metadata.getScopeName().equals("singleton")) {
                metadata.setScopedProxyMode(this.defaultProxyMode);
            }
        }
        return metadata;
    }
}

