/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.inria.diverse.melange.lib.EcoreExtensions;
import fr.inria.diverse.melange.lib.EcoreMerger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PackageMergeMerger
implements EcoreMerger {
    @Inject
    @Extension
    private EcoreExtensions _ecoreExtensions;
    private List<EcoreMerger.Conflict> conflicts;
    private static final String ORIGIN_ANNOTATION_SOURCE = "http://www.inria.fr/melange/origin";

    @Override
    public EPackage merge(EPackage receiving, EPackage merged) {
        return this.merge(receiving, merged, true);
    }

    public EPackage merge(EPackage receiving, EPackage merged, boolean validate) {
        boolean _isEmpty;
        boolean _not;
        boolean _doMatch;
        boolean _contains_1;
        this.conflicts = CollectionLiterals.newArrayList();
        EPackage resulting = receiving;
        boolean _equals = Objects.equal((Object)receiving, (Object)merged);
        if (_equals) {
            this.addConflict((ENamedElement)receiving, (ENamedElement)merged, null, "Cannot merge package with itself");
            return null;
        }
        if (receiving == null || merged == null) {
            return null;
        }
        boolean _contains = this._ecoreExtensions.getAllSubPkgs(receiving).contains(merged);
        if (_contains) {
            this.addConflict((ENamedElement)receiving, (ENamedElement)merged, null, "Receiving package cannot contain merged package");
        }
        if (_contains_1 = this._ecoreExtensions.getAllSubPkgs(merged).contains(receiving)) {
            this.addConflict((ENamedElement)receiving, (ENamedElement)merged, null, "Merged package cannot contain receiving package");
        }
        if (_doMatch = this.doMatch((EModelElement)receiving, (EModelElement)merged)) {
            this.doMerge((EModelElement)resulting, (EModelElement)merged);
        }
        boolean bl = _not = !(_isEmpty = this.conflicts.isEmpty());
        if (_not) {
            this.cleanAnnotations(resulting);
            return null;
        }
        this.updateReferences(CollectionLiterals.newHashSet((Object[])new EPackage[]{resulting}));
        boolean _xifexpression = false;
        _xifexpression = validate ? this.validateAndProduceConflicts(resulting) : true;
        boolean isValid = _xifexpression;
        this.cleanAnnotations(resulting);
        Object _xifexpression_1 = null;
        _xifexpression_1 = isValid ? resulting : null;
        return _xifexpression_1;
    }

    public void cleanAnnotations(EPackage pkg) {
        ArrayList toRemove = CollectionLiterals.newArrayList();
        TreeIterator i = pkg.eAllContents();
        while (i.hasNext()) {
            EObject o = (EObject)i.next();
            if (!(o instanceof EModelElement)) continue;
            Functions.Function1<EAnnotation, Boolean> _function = new Functions.Function1<EAnnotation, Boolean>(){

                public Boolean apply(EAnnotation it) {
                    String _source = it.getSource();
                    return Objects.equal((Object)_source, (Object)PackageMergeMerger.ORIGIN_ANNOTATION_SOURCE);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)((EModelElement)o).getEAnnotations(), (Functions.Function1)_function);
            Iterables.addAll((Collection)toRemove, (Iterable)_filter);
        }
        Consumer<EAnnotation> _function = new Consumer<EAnnotation>(){

            @Override
            public void accept(EAnnotation it) {
                EcoreUtil.delete((EObject)it);
            }
        };
        toRemove.forEach(_function);
    }

    public boolean validateAndProduceConflicts(EPackage resulting) {
        boolean _notEquals;
        Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)resulting);
        int _severity = diag.getSeverity();
        boolean bl = _notEquals = _severity != 0;
        if (_notEquals) {
            Consumer<Diagnostic> _function = new Consumer<Diagnostic>(){

                @Override
                public void accept(final Diagnostic d) {
                    Consumer<Object> _function = new Consumer<Object>(){

                        @Override
                        public void accept(final Object diagSource) {
                            if (diagSource instanceof ENamedElement) {
                                Functions.Function1<EAnnotation, Boolean> _function = new Functions.Function1<EAnnotation, Boolean>(){

                                    public Boolean apply(EAnnotation it) {
                                        String _source = it.getSource();
                                        return Objects.equal((Object)_source, (Object)PackageMergeMerger.ORIGIN_ANNOTATION_SOURCE);
                                    }
                                };
                                Consumer<EAnnotation> _function_1 = new Consumer<EAnnotation>(){

                                    @Override
                                    public void accept(EAnnotation ann) {
                                        boolean _equals;
                                        int _size = ann.getReferences().size();
                                        boolean bl = _equals = _size == 2;
                                        if (_equals) {
                                            EObject _head = (EObject)IterableExtensions.head((Iterable)ann.getReferences());
                                            ENamedElement mergedElement = (ENamedElement)_head;
                                            EObject _get = (EObject)ann.getReferences().get(1);
                                            EReference feature = (EReference)_get;
                                            EObject _xifexpression = null;
                                            boolean _isContainment = feature.isContainment();
                                            _xifexpression = _isContainment ? ((ENamedElement)diagSource).eContainer() : (EObject)diagSource;
                                            EObject receivingElement = _xifexpression;
                                            PackageMergeMerger.this.addConflict((ENamedElement)receivingElement, mergedElement, feature, d);
                                        }
                                    }
                                };
                                IterableExtensions.filter((Iterable)((ENamedElement)diagSource).getEAnnotations(), (Functions.Function1)_function).forEach(_function_1);
                            }
                        }
                    };
                    d.getData().forEach(_function);
                }
            };
            diag.getChildren().forEach(_function);
            return false;
        }
        return true;
    }

    public void updateReferences(final Set<EPackage> pkgs) {
        BiConsumer<EObject, Collection<EStructuralFeature.Setting>> _function = new BiConsumer<EObject, Collection<EStructuralFeature.Setting>>(){

            @Override
            public void accept(final EObject o, Collection<EStructuralFeature.Setting> s) {
                Consumer<EStructuralFeature.Setting> _function = new Consumer<EStructuralFeature.Setting>(){

                    @Override
                    public void accept(EStructuralFeature.Setting ss) {
                        if (ss.getEStructuralFeature() != null && !ss.getEStructuralFeature().isDerived() && !ss.getEStructuralFeature().isMany()) {
                            if (o instanceof EClassifier) {
                                EClassifier corresponding = PackageMergeMerger.this._ecoreExtensions.findClassifier(pkgs, PackageMergeMerger.this._ecoreExtensions.getUniqueId((ENamedElement)o));
                                if (corresponding != null) {
                                    ss.getEObject().eSet(ss.getEStructuralFeature(), (Object)corresponding);
                                }
                            } else if (o instanceof EReference) {
                                boolean _tripleNotEquals;
                                EReference _eOpposite = ((EReference)o).getEOpposite();
                                boolean bl = _tripleNotEquals = _eOpposite != null;
                                if (_tripleNotEquals) {
                                    EReference correspondingRef;
                                    EClassifier _findClassifier = PackageMergeMerger.this._ecoreExtensions.findClassifier(pkgs, PackageMergeMerger.this._ecoreExtensions.getUniqueId((ENamedElement)((EReference)o).getEContainingClass()));
                                    EClass correspondingCls = (EClass)_findClassifier;
                                    EList _eReferences = null;
                                    if (correspondingCls != null) {
                                        _eReferences = correspondingCls.getEReferences();
                                    }
                                    EReference _findFirst = null;
                                    if (_eReferences != null) {
                                        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

                                            public Boolean apply(EReference it) {
                                                String _name = it.getName();
                                                String _name_1 = ((EReference)o).getName();
                                                return Objects.equal((Object)_name, (Object)_name_1);
                                            }
                                        };
                                        _findFirst = (EReference)IterableExtensions.findFirst((Iterable)_eReferences, (Functions.Function1)_function);
                                    }
                                    if ((correspondingRef = _findFirst) != null) {
                                        ss.getEObject().eSet(ss.getEStructuralFeature(), correspondingRef);
                                    }
                                }
                            }
                        }
                    }
                };
                s.forEach(_function);
            }
        };
        EcoreUtil.ExternalCrossReferencer.find(pkgs).forEach(_function);
    }

    @Override
    public Set<EPackage> merge(final Set<EPackage> receiving, Set<EPackage> merged) {
        this.conflicts = CollectionLiterals.newArrayList();
        final HashSet allConflicts = CollectionLiterals.newHashSet();
        Consumer<EPackage> _function = new Consumer<EPackage>(){

            @Override
            public void accept(final EPackage mergedPkg) {
                Functions.Function1<EPackage, Boolean> _function = new Functions.Function1<EPackage, Boolean>(){

                    public Boolean apply(EPackage it) {
                        return PackageMergeMerger.this.doMatch((EModelElement)it, (EModelElement)mergedPkg);
                    }
                };
                EPackage correspondingPkg = (EPackage)IterableExtensions.findFirst((Iterable)receiving, (Functions.Function1)_function);
                if (correspondingPkg != null) {
                    PackageMergeMerger.this.merge(correspondingPkg, mergedPkg);
                } else {
                    EPackage _copy = (EPackage)EcoreUtil.copy((EObject)mergedPkg);
                    receiving.add(_copy);
                }
                allConflicts.addAll(PackageMergeMerger.this.getConflicts());
            }
        };
        merged.forEach(_function);
        this.updateReferences(receiving);
        this.conflicts = IterableExtensions.toList((Iterable)allConflicts);
        return receiving;
    }

    private boolean _doMatch(ENamedElement rcv, ENamedElement merged) {
        return false;
    }

    private boolean _doMatch(EPackage rcv, EPackage merged) {
        String _name = rcv.getName();
        String _name_1 = merged.getName();
        return Objects.equal((Object)_name, (Object)_name_1);
    }

    private boolean _doMatch(EClass rcv, EClass merged) {
        String _name = rcv.getName();
        String _name_1 = merged.getName();
        return Objects.equal((Object)_name, (Object)_name_1);
    }

    private boolean _doMatch(EDataType rcv, EDataType merged) {
        String _name = rcv.getName();
        String _name_1 = merged.getName();
        return Objects.equal((Object)_name, (Object)_name_1);
    }

    private boolean _doMatch(EEnum rcv, EEnum merged) {
        String _name = rcv.getName();
        String _name_1 = merged.getName();
        return Objects.equal((Object)_name, (Object)_name_1);
    }

    private boolean _doMatch(EAttribute rcv, EAttribute merged) {
        return Objects.equal((Object)rcv.getName(), (Object)merged.getName()) && this.typesMatch(rcv.getEType(), merged.getEType());
    }

    private boolean _doMatch(EReference rcv, EReference merged) {
        return Objects.equal((Object)rcv.getName(), (Object)merged.getName()) && this.typesMatch(rcv.getEType(), merged.getEType());
    }

    private boolean _doMatch(EOperation rcv, EOperation merged) {
        return Objects.equal((Object)rcv.getName(), (Object)merged.getName()) && this.typesMatch(rcv.getEType(), merged.getEType());
    }

    private boolean _doMatch(EParameter rcv, EParameter merged) {
        String _name = rcv.getName();
        String _name_1 = merged.getName();
        return Objects.equal((Object)_name, (Object)_name_1);
    }

    private boolean _doMatch(EAnnotation rcv, EAnnotation merged) {
        return false;
    }

    private boolean typesMatch(EClassifier eA, EClassifier eB) {
        if (eA == null && eB == null) {
            return true;
        }
        if (eA == null || eB == null) {
            return false;
        }
        return this.doTypesMatch(eA, eB);
    }

    private boolean _doTypesMatch(EClassifier eA, EClassifier eB) {
        return false;
    }

    private boolean _doTypesMatch(EClass clsA, final EClass clsB) {
        return Objects.equal((Object)clsA.getName(), (Object)clsB.getName()) || IterableExtensions.exists((Iterable)clsA.getEAllSuperTypes(), (Functions.Function1)new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass it) {
                String _name = it.getName();
                String _name_1 = clsB.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            }
        });
    }

    private boolean _doTypesMatch(EDataType dtA, EDataType dtB) {
        String _name = dtA.getName();
        String _name_1 = dtB.getName();
        return Objects.equal((Object)_name, (Object)_name_1);
    }

    private boolean _doTypesMatch(EEnum enumA, EEnum enumB) {
        String _name = enumA.getName();
        String _name_1 = enumB.getName();
        return Objects.equal((Object)_name, (Object)_name_1);
    }

    private void _doMerge(EPackage rcv, EPackage merged) {
        this.doCollectionsMerge((ENamedElement)rcv, EcorePackage.Literals.EPACKAGE__ECLASSIFIERS, (List)rcv.getEClassifiers(), (List)merged.getEClassifiers());
        this.doCollectionsMerge((ENamedElement)rcv, EcorePackage.Literals.EPACKAGE__ESUBPACKAGES, (List)rcv.getESubpackages(), (List)merged.getESubpackages());
    }

    private void _doMerge(EClass rcv, EClass merged) {
        rcv.setAbstract(rcv.isAbstract() && merged.isAbstract());
        rcv.setInterface(rcv.isInterface() && merged.isInterface());
        this.doCollectionsMerge((ENamedElement)rcv, EcorePackage.Literals.ECLASS__ESTRUCTURAL_FEATURES, (List)rcv.getEStructuralFeatures(), (List)merged.getEStructuralFeatures());
        this.doCollectionsMerge((ENamedElement)rcv, EcorePackage.Literals.ECLASS__EOPERATIONS, (List)rcv.getEOperations(), (List)merged.getEOperations());
        this.doCollectionsMerge((ENamedElement)rcv, EcorePackage.Literals.ECLASS__ESUPER_TYPES, (List)rcv.getESuperTypes(), (List)merged.getESuperTypes());
    }

    private void _doMerge(EDataType rcv, EDataType merged) {
    }

    private void _doMerge(EEnum rcv, EEnum merged) {
    }

    private void _doMerge(EAttribute rcv, EAttribute merged) {
        rcv.setDerived(rcv.isDerived() || merged.isDerived());
        rcv.setTransient(rcv.isTransient() || merged.isTransient());
        rcv.setVolatile(rcv.isVolatile() || merged.isVolatile());
        rcv.setUnsettable(rcv.isUnsettable() && merged.isUnsettable());
        rcv.setChangeable(rcv.isChangeable() || merged.isChangeable());
        rcv.setOrdered(rcv.isOrdered() || merged.isOrdered());
        rcv.setUnique(rcv.isUnique() || merged.isUnique());
        int _lowerBound = rcv.getLowerBound();
        int _lowerBound_1 = merged.getLowerBound();
        rcv.setLowerBound(((Integer)IterableExtensions.min(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{_lowerBound, _lowerBound_1})))).intValue());
        rcv.setUpperBound(this.maxBound(rcv.getUpperBound(), merged.getUpperBound()));
    }

    private void _doMerge(EReference rcv, EReference merged) {
        rcv.setDerived(rcv.isDerived() || merged.isDerived());
        rcv.setTransient(rcv.isTransient() || merged.isTransient());
        rcv.setVolatile(rcv.isVolatile() || merged.isVolatile());
        rcv.setUnsettable(rcv.isUnsettable() && merged.isUnsettable());
        rcv.setChangeable(rcv.isChangeable() || merged.isChangeable());
        rcv.setOrdered(rcv.isOrdered() || merged.isOrdered());
        rcv.setUnique(rcv.isUnique() || merged.isUnique());
        int _lowerBound = rcv.getLowerBound();
        int _lowerBound_1 = merged.getLowerBound();
        rcv.setLowerBound(((Integer)IterableExtensions.min(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{_lowerBound, _lowerBound_1})))).intValue());
        rcv.setUpperBound(this.maxBound(rcv.getUpperBound(), merged.getUpperBound()));
        boolean _isContainment = rcv.isContainment();
        boolean _isContainment_1 = merged.isContainment();
        boolean _notEquals = _isContainment ^ _isContainment_1;
        if (_notEquals) {
            this.addConflict((ENamedElement)rcv, (ENamedElement)merged, null, "Conflicting containment values for reference");
        }
    }

    private void _doMerge(EOperation rcv, EOperation merged) {
        rcv.setOrdered(rcv.isOrdered() || merged.isOrdered());
        rcv.setUnique(rcv.isOrdered() || merged.isUnique());
        int _lowerBound = rcv.getLowerBound();
        int _lowerBound_1 = merged.getLowerBound();
        rcv.setLowerBound(((Integer)IterableExtensions.min(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{_lowerBound, _lowerBound_1})))).intValue());
        rcv.setUpperBound(this.maxBound(rcv.getUpperBound(), merged.getUpperBound()));
    }

    private void _doMerge(EParameter rcv, EParameter merged) {
    }

    private void _doMerge(EAnnotation rcv, EAnnotation merged) {
    }

    private <T extends ENamedElement> void deepCopy(ENamedElement context, final EReference ref, List<T> receiving, final T merged) {
        ENamedElement copy = (ENamedElement)EcoreUtil.copy(merged);
        receiving.add(copy);
        if (copy instanceof EClassifier) {
            boolean _tripleEquals;
            EPackage _ePackage = ((EClassifier)copy).getEPackage();
            boolean bl = _tripleEquals = _ePackage == null;
            if (_tripleEquals) {
                String packageFqName = this._ecoreExtensions.getUniqueId((ENamedElement)((EClassifier)merged).getEPackage());
                EPackage container = this.getOrCreate(this.getRootPackage(context), packageFqName);
                EList _eClassifiers = container.getEClassifiers();
                _eClassifiers.add((Object)((EClassifier)copy));
            }
        }
        EAnnotation _createEAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        Procedures.Procedure1<EAnnotation> _function = new Procedures.Procedure1<EAnnotation>(){

            public void apply(EAnnotation it) {
                it.setSource(PackageMergeMerger.ORIGIN_ANNOTATION_SOURCE);
                EList _references = it.getReferences();
                _references.add((Object)merged);
                EList _references_1 = it.getReferences();
                _references_1.add((Object)ref);
            }
        };
        EAnnotation newAnn = (EAnnotation)ObjectExtensions.operator_doubleArrow((Object)_createEAnnotation, (Procedures.Procedure1)_function);
        boolean _isContainment = ref.isContainment();
        if (_isContainment) {
            EList _eAnnotations = copy.getEAnnotations();
            _eAnnotations.add((Object)newAnn);
        } else {
            EList _eAnnotations_1 = context.getEAnnotations();
            _eAnnotations_1.add((Object)newAnn);
        }
    }

    private <T extends ENamedElement> void doCollectionsMerge(final ENamedElement context, final EReference ref, final List<T> rcv, List<T> merged) {
        Consumer _function = new Consumer<T>(){

            @Override
            public void accept(T m) {
                Functions.Function1 _function = new Functions.Function1<T, Boolean>((ENamedElement)m){
                    private final /* synthetic */ ENamedElement val$m;
                    {
                        this.val$m = eNamedElement;
                    }

                    public Boolean apply(T r) {
                        return PackageMergeMerger.this.doMatch(r, (EModelElement)this.val$m);
                    }
                };
                ENamedElement match = (ENamedElement)IterableExtensions.findFirst((Iterable)rcv, (Functions.Function1)_function);
                if (match != null) {
                    PackageMergeMerger.this.doMerge((EModelElement)match, m);
                } else if (m instanceof EClassifier) {
                    EPackage root = PackageMergeMerger.this.getRootPackage(context);
                    String clsFqName = PackageMergeMerger.this._ecoreExtensions.getUniqueId((ENamedElement)m);
                    final EClassifier candidate = PackageMergeMerger.this._ecoreExtensions.findClassifier(root, clsFqName);
                    if (candidate != null) {
                        rcv.add(candidate);
                        EAnnotation _createEAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                        Procedures.Procedure1<EAnnotation> _function_1 = new Procedures.Procedure1<EAnnotation>(){

                            public void apply(EAnnotation it) {
                                it.setSource(PackageMergeMerger.ORIGIN_ANNOTATION_SOURCE);
                                EList _references = it.getReferences();
                                _references.add((Object)candidate);
                                EList _references_1 = it.getReferences();
                                _references_1.add((Object)ref);
                            }
                        };
                        EAnnotation newAnn = (EAnnotation)ObjectExtensions.operator_doubleArrow((Object)_createEAnnotation, (Procedures.Procedure1)_function_1);
                        boolean _isContainment = ref.isContainment();
                        if (_isContainment) {
                            EList _eAnnotations = candidate.getEAnnotations();
                            _eAnnotations.add((Object)newAnn);
                        } else {
                            EList _eAnnotations_1 = context.getEAnnotations();
                            _eAnnotations_1.add((Object)newAnn);
                        }
                    } else {
                        PackageMergeMerger.this.deepCopy(context, ref, rcv, m);
                    }
                } else {
                    PackageMergeMerger.this.deepCopy(context, ref, rcv, m);
                }
            }
        };
        merged.forEach(_function);
    }

    private int maxBound(int a, int b) {
        Integer _xifexpression = null;
        _xifexpression = a == -1 || b == -1 ? Integer.valueOf(-1) : (Integer)IterableExtensions.max(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{a, b})));
        return _xifexpression;
    }

    private void addConflict(ENamedElement rcv, ENamedElement merged, EReference ref, String message) {
        this.addConflict(rcv, merged, ref, message, null);
    }

    private void addConflict(ENamedElement rcv, ENamedElement merged, EReference ref, Diagnostic d) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Cannot merge ");
        String _uniqueId = this._ecoreExtensions.getUniqueId(merged);
        _builder.append(_uniqueId);
        _builder.append(" with ");
        String _uniqueId_1 = this._ecoreExtensions.getUniqueId(rcv);
        _builder.append(_uniqueId_1);
        _builder.append(".");
        String _name = ref.getName();
        _builder.append(_name);
        _builder.append(": ");
        String _message = d.getMessage();
        _builder.append(_message);
        this.addConflict(rcv, merged, ref, _builder.toString(), d);
    }

    private void addConflict(ENamedElement rcv, ENamedElement merged, EReference ref, String message, Diagnostic d) {
        EcoreMerger.Conflict _conflict = new EcoreMerger.Conflict((EObject)rcv, (EObject)merged, ref, message, d);
        this.conflicts.add(_conflict);
    }

    @Override
    public List<EcoreMerger.Conflict> getConflicts() {
        return this.conflicts;
    }

    private EPackage getRootPackage(ENamedElement element) {
        boolean _tripleNotEquals;
        EPackage _switchResult = null;
        boolean _matched = false;
        EObject _eContainer = element.eContainer();
        boolean bl = _tripleNotEquals = _eContainer != null;
        if (_tripleNotEquals) {
            _matched = true;
            EObject _eContainer_1 = element.eContainer();
            _switchResult = this.getRootPackage((ENamedElement)_eContainer_1);
        }
        if (!_matched && element instanceof EPackage) {
            _matched = true;
            _switchResult = (EPackage)element;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    private EPackage getOrCreate(EPackage root, String qualifiedPkgName) {
        EPackage _xifexpression_2;
        EPackage subPkg;
        String nameWithoutRoot;
        EPackage _xblockexpression;
        EPackage _xifexpression = null;
        String _name = root.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)qualifiedPkgName);
        if (_equals) {
            return root;
        }
        EPackage _xifexpression_1 = null;
        if (qualifiedPkgName.startsWith(String.valueOf(root.getName()) + ".") && !qualifiedPkgName.endsWith(".")) {
            boolean _equals_1;
            _xblockexpression = null;
            nameWithoutRoot = qualifiedPkgName.substring(root.getName().length());
            final String[] segments = nameWithoutRoot.split(".");
            Functions.Function1<EPackage, Boolean> _function = new Functions.Function1<EPackage, Boolean>(){

                public Boolean apply(EPackage it) {
                    String _name = it.getName();
                    String _get = segments[0];
                    return Objects.equal((Object)_name, (Object)_get);
                }
            };
            subPkg = (EPackage)IterableExtensions.findFirst((Iterable)root.getESubpackages(), (Functions.Function1)_function);
            if (subPkg == null) {
                subPkg = EcoreFactory.eINSTANCE.createEPackage();
                subPkg.setName(segments[0]);
                subPkg.setNsPrefix(segments[0]);
                String _nsURI = root.getNsURI();
                String _get = segments[0];
                String _plus = String.valueOf(_nsURI) + _get;
                String _plus_1 = String.valueOf(_plus) + "/";
                subPkg.setNsURI(_plus_1);
            }
            _xifexpression_2 = null;
            int _size = ((List)Conversions.doWrapArray((Object)segments)).size();
            boolean bl = _equals_1 = _size == 1;
            if (_equals_1) {
                return subPkg;
            }
        } else {
            return null;
        }
        _xifexpression_1 = _xblockexpression = (_xifexpression_2 = this.getOrCreate(subPkg, nameWithoutRoot));
        _xifexpression = _xifexpression_1;
        return _xifexpression;
    }

    private boolean doMatch(EModelElement rcv, EModelElement merged) {
        if (rcv instanceof EAttribute && merged instanceof EAttribute) {
            return this._doMatch((EAttribute)rcv, (EAttribute)merged);
        }
        if (rcv instanceof EEnum && merged instanceof EEnum) {
            return this._doMatch((EEnum)rcv, (EEnum)merged);
        }
        if (rcv instanceof EReference && merged instanceof EReference) {
            return this._doMatch((EReference)rcv, (EReference)merged);
        }
        if (rcv instanceof EClass && merged instanceof EClass) {
            return this._doMatch((EClass)rcv, (EClass)merged);
        }
        if (rcv instanceof EDataType && merged instanceof EDataType) {
            return this._doMatch((EDataType)rcv, (EDataType)merged);
        }
        if (rcv instanceof EOperation && merged instanceof EOperation) {
            return this._doMatch((EOperation)rcv, (EOperation)merged);
        }
        if (rcv instanceof EParameter && merged instanceof EParameter) {
            return this._doMatch((EParameter)rcv, (EParameter)merged);
        }
        if (rcv instanceof EPackage && merged instanceof EPackage) {
            return this._doMatch((EPackage)rcv, (EPackage)merged);
        }
        if (rcv instanceof EAnnotation && merged instanceof EAnnotation) {
            return this._doMatch((EAnnotation)rcv, (EAnnotation)merged);
        }
        if (rcv instanceof ENamedElement && merged instanceof ENamedElement) {
            return this._doMatch((ENamedElement)rcv, (ENamedElement)merged);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(rcv, merged).toString());
    }

    private boolean doTypesMatch(EClassifier enumA, EClassifier enumB) {
        if (enumA instanceof EEnum && enumB instanceof EEnum) {
            return this._doTypesMatch((EEnum)enumA, (EEnum)enumB);
        }
        if (enumA instanceof EClass && enumB instanceof EClass) {
            return this._doTypesMatch((EClass)enumA, (EClass)enumB);
        }
        if (enumA instanceof EDataType && enumB instanceof EDataType) {
            return this._doTypesMatch((EDataType)enumA, (EDataType)enumB);
        }
        if (enumA != null && enumB != null) {
            return this._doTypesMatch(enumA, enumB);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(enumA, enumB).toString());
    }

    private void doMerge(EModelElement rcv, EModelElement merged) {
        if (rcv instanceof EAttribute && merged instanceof EAttribute) {
            this._doMerge((EAttribute)rcv, (EAttribute)merged);
            return;
        }
        if (rcv instanceof EEnum && merged instanceof EEnum) {
            this._doMerge((EEnum)rcv, (EEnum)merged);
            return;
        }
        if (rcv instanceof EReference && merged instanceof EReference) {
            this._doMerge((EReference)rcv, (EReference)merged);
            return;
        }
        if (rcv instanceof EClass && merged instanceof EClass) {
            this._doMerge((EClass)rcv, (EClass)merged);
            return;
        }
        if (rcv instanceof EDataType && merged instanceof EDataType) {
            this._doMerge((EDataType)rcv, (EDataType)merged);
            return;
        }
        if (rcv instanceof EOperation && merged instanceof EOperation) {
            this._doMerge((EOperation)rcv, (EOperation)merged);
            return;
        }
        if (rcv instanceof EParameter && merged instanceof EParameter) {
            this._doMerge((EParameter)rcv, (EParameter)merged);
            return;
        }
        if (rcv instanceof EPackage && merged instanceof EPackage) {
            this._doMerge((EPackage)rcv, (EPackage)merged);
            return;
        }
        if (rcv instanceof EAnnotation && merged instanceof EAnnotation) {
            this._doMerge((EAnnotation)rcv, (EAnnotation)merged);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(rcv, merged).toString());
    }
}

