/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.text.CollationKey;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

public class MarkerDescriptionField
extends MarkerField {
    @Override
    public int compare(MarkerItem item1, MarkerItem item2) {
        return this.getDescriptionKey(item1).compareTo(this.getDescriptionKey(item2));
    }

    @Override
    public int getDefaultColumnWidth(Control control) {
        return 50 * MarkerSupportInternalUtilities.getFontWidth(control);
    }

    private CollationKey getDescriptionKey(Object element) {
        if (element instanceof MarkerEntry) {
            return ((MarkerEntry)element).getCollationKey("message", MarkerSupportInternalUtilities.UNKNOWN_ATRRIBTE_VALUE_STRING);
        }
        return MarkerSupportInternalUtilities.EMPTY_COLLATION_KEY;
    }

    @Override
    public String getValue(MarkerItem item) {
        return item.getAttributeValue("message", MarkerSupportInternalUtilities.UNKNOWN_ATRRIBTE_VALUE_STRING);
    }

    @Override
    public EditingSupport getEditingSupport(ColumnViewer viewer) {
        return new DescriptionEditingSupport(viewer);
    }

    private static class DescriptionEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public DescriptionEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            if (element instanceof MarkerEntry) {
                MarkerEntry entry = (MarkerEntry)element;
                try {
                    if (entry.getMarker() != null && entry.getMarker().isSubtypeOf("org.eclipse.core.resources.bookmark")) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    Policy.handle(e);
                    return false;
                }
                return entry.getAttributeValue("userEditable", false);
            }
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            return ((MarkerEntry)element).getAttributeValue("message", "");
        }

        protected void setValue(Object element, Object value) {
            MarkerEntry entry = (MarkerEntry)element;
            try {
                entry.getMarker().setAttribute("message", value);
            }
            catch (CoreException e) {
                Policy.handle(e);
            }
        }
    }
}

