/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IProjectContentWizard;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.templates.ITemplateSection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public abstract class AbstractNewProjectTemplateWizard
extends Wizard
implements IProjectContentWizard {
    private BaseProjectWizardFields data;

    public AbstractNewProjectTemplateWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEXPRJ_WIZ);
        this.setNeedsProgressMonitor(true);
    }

    @Override
    public void init(BaseProjectWizardFields data) {
        this.data = data;
        this.setWindowTitle(PDEUIMessages.PluginCodeGeneratorWizard_title);
    }

    public BaseProjectWizardFields getData() {
        return this.data;
    }

    protected abstract void addAdditionalPages();

    public final void addPages() {
        this.addAdditionalPages();
    }

    public boolean performFinish() {
        return true;
    }

    @Override
    public boolean performFinish(IProject project, IProgressMonitor monitor) {
        try {
            try {
                ITemplateSection[] sections = this.getTemplateSections();
                monitor.beginTask("", sections.length);
                int i = 0;
                while (i < sections.length) {
                    sections[i].execute(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++i;
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException((Throwable)e);
                monitor.done();
                return false;
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public abstract ITemplateSection[] getTemplateSections();

    @Override
    public IPluginReference[] getDependencies(String schemaVersion) {
        ArrayList<IPluginReference> result = new ArrayList<IPluginReference>();
        ITemplateSection[] sections = this.getTemplateSections();
        int i = 0;
        while (i < sections.length) {
            IPluginReference[] refs = sections[i].getDependencies(schemaVersion);
            int j = 0;
            while (j < refs.length) {
                if (!result.contains(refs[j])) {
                    result.add(refs[j]);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    @Override
    public String[] getNewFiles() {
        ArrayList<String> result = new ArrayList<String>();
        ITemplateSection[] sections = this.getTemplateSections();
        int i = 0;
        while (i < sections.length) {
            String[] newFiles = sections[i].getNewFiles();
            int j = 0;
            while (j < newFiles.length) {
                if (!result.contains(newFiles[j])) {
                    result.add(newFiles[j]);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean hasPages() {
        return this.getTemplateSections().length > 0;
    }

    public String[] getImportPackages() {
        return new String[0];
    }
}

