/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.preferences;

import fr.inria.diverse.melange.preferences.MelangePreferencesConstants;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

/**
 * So ugly, but Xtext doesn't appear to
 * provide something cleaner
 */
@SuppressWarnings("all")
public class MelangePreferencesAccess {
  private static final String PREFS_ID = "fr.inria.diverse.melange.ui";
  
  private static MelangePreferencesAccess instance;
  
  private IPreferencesService preferencesService;
  
  private boolean isUserLaunch;
  
  private MelangePreferencesAccess() {
    this.preferencesService = Platform.getPreferencesService();
    this.isUserLaunch = false;
  }
  
  public static synchronized MelangePreferencesAccess getInstance() {
    if ((MelangePreferencesAccess.instance == null)) {
      MelangePreferencesAccess _melangePreferencesAccess = new MelangePreferencesAccess();
      MelangePreferencesAccess.instance = _melangePreferencesAccess;
    }
    return MelangePreferencesAccess.instance;
  }
  
  public boolean isGenerateAdaptersCode() {
    boolean _xifexpression = false;
    if ((this.preferencesService != null)) {
      _xifexpression = this.preferencesService.getBoolean(
        MelangePreferencesAccess.PREFS_ID, 
        MelangePreferencesConstants.GENERATE_ADAPTERS_CODE, 
        true, 
        null);
    } else {
      _xifexpression = true;
    }
    return _xifexpression;
  }
  
  /**
   * Return true if the user request a full compilation.
   * Should return false if the compilation process is automatically launched
   */
  public boolean isUserLaunch() {
    return this.isUserLaunch;
  }
  
  public void enableCodeGenerator() {
    this.isUserLaunch = true;
  }
  
  public void disableCodeGenerator() {
    this.isUserLaunch = false;
  }
}
