/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.manifest;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.pde.manifest.ManifestChanger;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ManifestChangerExportPackage {
    private ManifestChanger _mfChanger;

    public ManifestChangerExportPackage(ManifestChanger connection) {
        this._mfChanger = connection;
    }

    public void add(String packageName) throws BundleException, IOException, CoreException {
        String exportPackageHeader = "Export-Package";
        boolean foundHeader = false;
        boolean hasValuesForPackageName = false;
        StringBuilder strBuilder = new StringBuilder();
        Attributes mainAttrs = this.getManifest().getMainAttributes();
        block0: for (Object entryName : mainAttrs.keySet()) {
            String values;
            String header;
            if (entryName instanceof String) {
                header = (String)entryName;
                values = mainAttrs.getValue(header);
            } else if (entryName instanceof Attributes.Name) {
                header = ((Attributes.Name)entryName).toString();
                values = mainAttrs.getValue((Attributes.Name)entryName);
            } else {
                throw new BundleException("Unknown Main Attribute Key type: " + entryName.getClass() + " (" + entryName + ")");
            }
            if (!"Export-Package".equals(header)) continue;
            foundHeader = true;
            if (values == null) break;
            ManifestElement[] elements = ManifestElement.parseHeader((String)header, (String)values);
            int i = 0;
            while (i < elements.length) {
                boolean lastElement;
                ManifestElement manifestElement = elements[i];
                boolean bl = lastElement = i >= elements.length - 1;
                if (packageName.equals(manifestElement.getValueComponents()[0])) {
                    hasValuesForPackageName = true;
                    break block0;
                }
                strBuilder.append(manifestElement.getValue());
                if (!lastElement) {
                    strBuilder.append(",\n");
                }
                ++i;
            }
            break block0;
        }
        if (!foundHeader) {
            this.getManifest().getMainAttributes().putValue("Export-Package", packageName);
        } else if (!hasValuesForPackageName) {
            String existingValues = strBuilder.toString();
            boolean areExistingValues = existingValues.trim().length() != 0;
            String newValue = packageName;
            newValue = areExistingValues ? String.valueOf(existingValues) + ",\n " + newValue : newValue;
            this.getManifest().getMainAttributes().putValue("Export-Package", newValue);
        }
    }

    private Manifest getManifest() throws IOException, CoreException {
        return this._mfChanger.getManifest();
    }
}

