/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure;

import java.util.BitSet;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BackgroundStyle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientRoundedRectangle;

public class RegionRoundedGradientRectangle
extends GradientRoundedRectangle {
    private final Dimension secondaryCorner = new Dimension(0, 0);
    private BitSet positions = new BitSet(29);

    public RegionRoundedGradientRectangle(Dimension dimension, BackgroundStyle backgroundStyle, View view, boolean useOverlayLabel) {
        super(dimension, backgroundStyle.getValue(), view, useOverlayLabel);
        this.setOutline(false);
    }

    public RegionRoundedGradientRectangle(Dimension dimension, BackgroundStyle backgroundStyle, View view) {
        this(dimension, backgroundStyle, view, false);
    }

    public void setOutline(boolean b) {
        super.setOutline(false);
    }

    public void setAdditionalCornerDimensions(Dimension d, BitSet chosenCorners) {
        this.positions.clear();
        if (chosenCorners != null) {
            this.positions.or(chosenCorners);
        }
        if (d == null) {
            this.secondaryCorner.setWidth(0);
            this.secondaryCorner.setHeight(0);
        } else {
            this.secondaryCorner.setWidth(d.width);
            this.secondaryCorner.setHeight(d.height);
        }
    }

    public Dimension getAdditionalCornerDimensions() {
        return this.secondaryCorner.getCopy();
    }

    public BitSet getAdditionalDimensionCorners() {
        return this.positions;
    }

    @Override
    protected void fillShape(Graphics graphics) {
        Rectangle corner;
        super.fillShape(graphics);
        if (this.positions.isEmpty()) {
            return;
        }
        if (this.positions.get(9)) {
            corner = new Rectangle(this.bounds.getCenter(), this.bounds.getTopLeft());
            graphics.fillRoundRectangle(corner, this.secondaryCorner.width, this.secondaryCorner.height);
        }
        if (this.positions.get(17)) {
            corner = new Rectangle(this.bounds.getCenter(), this.bounds.getTopRight());
            graphics.fillRoundRectangle(corner, this.secondaryCorner.width, this.secondaryCorner.height);
        }
        if (this.positions.get(20)) {
            corner = new Rectangle(this.bounds.getCenter(), this.bounds.getBottomRight());
            graphics.fillRoundRectangle(corner, this.secondaryCorner.width, this.secondaryCorner.height);
        }
        if (this.positions.get(12)) {
            corner = new Rectangle(this.bounds.getCenter(), this.bounds.getBottomLeft());
            graphics.fillRoundRectangle(corner, this.secondaryCorner.width, this.secondaryCorner.height);
        }
    }
}

