/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal.messages;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.core.internal.messages.AbstractMessageSink;

public class ByteBufferMessageSink
extends AbstractMessageSink {
    private static final int BUFFER_SIZE = 65535;
    private ByteArrayOutputStream out;
    private int size;

    public ByteBufferMessageSink(CoreSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
        Objects.requireNonNull(methodHandle, "MethodHandle");
        MethodType onMessageType = MethodType.methodType(Void.TYPE, ByteBuffer.class);
        if (methodHandle.type() != onMessageType) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            this.size += frame.getPayloadLength();
            long maxBinaryMessageSize = this.session.getMaxBinaryMessageSize();
            if (maxBinaryMessageSize > 0L && (long)this.size > maxBinaryMessageSize) {
                throw new MessageTooLargeException(String.format("Binary message too large: (actual) %,d > (configured max binary message size) %,d", this.size, maxBinaryMessageSize));
            }
            if (frame.isFin() && this.out == null) {
                if (frame.hasPayload()) {
                    this.methodHandle.invoke(frame.getPayload());
                } else {
                    this.methodHandle.invoke(BufferUtil.EMPTY_BUFFER);
                }
                callback.succeeded();
                return;
            }
            this.aggregatePayload(frame);
            if (frame.isFin()) {
                this.methodHandle.invoke(ByteBuffer.wrap(this.out.toByteArray()));
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        finally {
            if (frame.isFin()) {
                this.out = null;
                this.size = 0;
            }
        }
    }

    private void aggregatePayload(Frame frame) throws IOException {
        if (frame.hasPayload()) {
            ByteBuffer payload = frame.getPayload();
            if (this.out == null) {
                this.out = new ByteArrayOutputStream(65535);
            }
            BufferUtil.writeTo((ByteBuffer)payload, (OutputStream)this.out);
            payload.position(payload.limit());
        }
    }
}

