/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.adapters.EListAdapter;
import fr.inria.diverse.melange.adapters.EObjectAdapter;
import fr.inria.diverse.melange.ast.ModelingElementExtensions;
import fr.inria.diverse.melange.ast.NamingHelper;
import fr.inria.diverse.melange.lib.EcoreExtensions;
import fr.inria.diverse.melange.metamodel.melange.ClassBinding;
import fr.inria.diverse.melange.metamodel.melange.Metamodel;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.metamodel.melange.PropertyBinding;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @deprecated Mappers aren't in use for now
 */
@SuppressWarnings("all")
public class MetaclassMapperInferrer {
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;

  @Inject
  @Extension
  private NamingHelper _namingHelper;

  @Inject
  @Extension
  private EcoreExtensions _ecoreExtensions;

  @Inject
  @Extension
  private MelangeTypesBuilder _melangeTypesBuilder;

  @Inject
  @Extension
  private ModelingElementExtensions _modelingElementExtensions;

  @Inject
  @Extension
  private JvmAnnotationReferenceBuilder.Factory jvmAnnRefBuilderFact;

  @Extension
  private JvmAnnotationReferenceBuilder jvmAnnRefBuilder;

  @Extension
  private JvmTypeReferenceBuilder typeRefBuilder;

  public void generateMapper(final ClassBinding binding, final Metamodel sourceModel, final ModelType targetMT, final IJvmDeclaredTypeAcceptor acceptor, @Extension final JvmTypeReferenceBuilder builder) {
    this.typeRefBuilder = builder;
    this.jvmAnnRefBuilder = this.jvmAnnRefBuilderFact.create(targetMT.getExtracted().eResource().getResourceSet());
    final Function1<EClass, Boolean> _function = (EClass it) -> {
      String _name = it.getName();
      String _from = binding.getFrom();
      return Boolean.valueOf(Objects.equal(_name, _from));
    };
    final EClass sourceClass = IterableExtensions.<EClass>findFirst(this._modelingElementExtensions.getAllClasses(sourceModel), _function);
    final Function1<EClass, Boolean> _function_1 = (EClass it) -> {
      String _name = it.getName();
      String _to = binding.getTo();
      return Boolean.valueOf(Objects.equal(_name, _to));
    };
    final EClass targetClass = IterableExtensions.<EClass>findFirst(this._modelingElementExtensions.getAllClasses(targetMT), _function_1);
    final String mapperName = this._namingHelper.mapperNameFor(sourceModel, targetMT, targetClass);
    final Procedure1<JvmGenericType> _function_2 = (JvmGenericType jvmCls) -> {
      EList<JvmTypeReference> _superTypes = jvmCls.getSuperTypes();
      JvmTypeReference _typeRef = builder.typeRef(EObjectAdapter.class, 
        this._melangeTypesBuilder.typeRef(sourceModel, sourceClass, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls))));
      this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
      EList<JvmTypeReference> _superTypes_1 = jvmCls.getSuperTypes();
      JvmTypeReference _typeRef_1 = builder.typeRef(this._namingHelper.getFqnFor(targetMT, targetClass));
      this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes_1, _typeRef_1);
      EList<JvmMember> _members = jvmCls.getMembers();
      JvmField _field = this._jvmTypesBuilder.toField(targetMT, "adaptersFactory", 
        builder.typeRef(this._namingHelper.getMappersFactoryNameFor(sourceModel, targetMT)));
      this._jvmTypesBuilder.<JvmField>operator_add(_members, _field);
      EList<JvmMember> _members_1 = jvmCls.getMembers();
      final Procedure1<JvmConstructor> _function_3 = (JvmConstructor it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("super(");
            String _mappersFactoryNameFor = MetaclassMapperInferrer.this._namingHelper.getMappersFactoryNameFor(sourceModel, targetMT);
            _builder.append(_mappersFactoryNameFor);
            _builder.append(".getInstance());");
            _builder.newLineIfNotEmpty();
          }
        };
        this._jvmTypesBuilder.setBody(it, _client);
      };
      JvmConstructor _constructor = this._jvmTypesBuilder.toConstructor(targetMT, _function_3);
      this._jvmTypesBuilder.<JvmConstructor>operator_add(_members_1, _constructor);
      final Consumer<EAttribute> _function_4 = (EAttribute targetAttr) -> {
        final Function1<PropertyBinding, Boolean> _function_5 = (PropertyBinding it) -> {
          String _to = it.getTo();
          String _name = targetAttr.getName();
          return Boolean.valueOf(Objects.equal(_to, _name));
        };
        final PropertyBinding propBinding = IterableExtensions.<PropertyBinding>findFirst(binding.getProperties(), _function_5);
        if ((propBinding != null)) {
          final Function1<EAttribute, Boolean> _function_6 = (EAttribute it) -> {
            String _name = it.getName();
            String _from = propBinding.getFrom();
            return Boolean.valueOf(Objects.equal(_name, _from));
          };
          final EAttribute sourceAttr = IterableExtensions.<EAttribute>findFirst(sourceClass.getEAllAttributes(), _function_6);
          this.processAttribute(sourceAttr, targetAttr, targetMT, jvmCls);
        } else {
          this.processAttribute(null, targetAttr, targetMT, jvmCls);
        }
      };
      targetClass.getEAllAttributes().forEach(_function_4);
      final Consumer<EReference> _function_5 = (EReference targetRef) -> {
        final Function1<PropertyBinding, Boolean> _function_6 = (PropertyBinding it) -> {
          String _to = it.getTo();
          String _name = targetRef.getName();
          return Boolean.valueOf(Objects.equal(_to, _name));
        };
        final PropertyBinding propBinding = IterableExtensions.<PropertyBinding>findFirst(binding.getProperties(), _function_6);
        if ((propBinding != null)) {
          final Function1<EReference, Boolean> _function_7 = (EReference it) -> {
            String _name = it.getName();
            String _from = propBinding.getFrom();
            return Boolean.valueOf(Objects.equal(_name, _from));
          };
          final EReference sourceRef = IterableExtensions.<EReference>findFirst(sourceClass.getEAllReferences(), _function_7);
          this.processReference(sourceRef, targetRef, sourceModel, targetMT, jvmCls);
        } else {
          this.processReference(null, targetRef, sourceModel, targetMT, jvmCls);
        }
      };
      targetClass.getEAllReferences().forEach(_function_5);
      final Consumer<EOperation> _function_6 = (EOperation it) -> {
        this.processOperation(it, targetMT, jvmCls);
      };
      this._ecoreExtensions.sortByOverridingPriority(targetClass.getEAllOperations()).forEach(_function_6);
    };
    acceptor.<JvmGenericType>accept(this._jvmTypesBuilder.toClass(binding, mapperName), _function_2);
  }

  /**
   * sourceAttr != null means we can use getter/setter
   */
  private void processAttribute(final EAttribute sourceAttr, final EAttribute targetAttr, final ModelType targetMT, final JvmGenericType jvmCls) {
    final JvmTypeReference attrType = this._melangeTypesBuilder.typeRef(targetMT, targetAttr, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls)));
    EList<JvmMember> _members = jvmCls.getMembers();
    final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
      if ((sourceAttr == null)) {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("throw new UnsupportedOperationException");
            _builder.append("(\"This attribute is not mapped\");");
            _builder.newLine();
          }
        };
        this._jvmTypesBuilder.setBody(it, _client);
      } else {
        EClassifier _eType = targetAttr.getEType();
        if ((_eType instanceof EEnum)) {
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              String _fqnFor = MetaclassMapperInferrer.this._namingHelper.getFqnFor(targetMT, targetAttr.getEType());
              _builder.append(_fqnFor);
              _builder.append(".get(adaptee.");
              String _getterName = MetaclassMapperInferrer.this._namingHelper.getGetterName(sourceAttr);
              _builder.append(_getterName);
              _builder.append("().getValue());");
              _builder.newLineIfNotEmpty();
            }
          };
          this._jvmTypesBuilder.setBody(it, _client_1);
        } else {
          StringConcatenationClient _client_2 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return adaptee.");
              String _getterName = MetaclassMapperInferrer.this._namingHelper.getGetterName(sourceAttr);
              _builder.append(_getterName);
              _builder.append("(); ");
              _builder.newLineIfNotEmpty();
            }
          };
          this._jvmTypesBuilder.setBody(it, _client_2);
        }
      }
    };
    JvmOperation _method = this._jvmTypesBuilder.toMethod(targetMT, this._namingHelper.getGetterName(targetAttr), attrType, _function);
    this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    boolean _needsSetterImplementation = this._ecoreExtensions.needsSetterImplementation(targetAttr);
    if (_needsSetterImplementation) {
      EList<JvmMember> _members_1 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_1 = (JvmOperation it) -> {
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmFormalParameter _parameter = this._jvmTypesBuilder.toParameter(targetMT, "o", attrType);
        this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        if ((sourceAttr == null)) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("throw new UnsupportedOperationException");
              _builder.append("(\"This attribute is not mapped\");");
              _builder.newLine();
            }
          };
          this._jvmTypesBuilder.setBody(it, _client);
        } else {
          EClassifier _eType = targetAttr.getEType();
          if ((_eType instanceof EEnum)) {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("adaptee.");
                String _setterName = MetaclassMapperInferrer.this._namingHelper.getSetterName(sourceAttr);
                _builder.append(_setterName);
                _builder.append("(");
                String _fqnFor = MetaclassMapperInferrer.this._namingHelper.getFqnFor(targetMT, targetAttr.getEType());
                _builder.append(_fqnFor);
                _builder.append(".get(o.getValue()));");
                _builder.newLineIfNotEmpty();
              }
            };
            this._jvmTypesBuilder.setBody(it, _client_1);
          } else {
            StringConcatenationClient _client_2 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("adaptee.");
                String _setterName = MetaclassMapperInferrer.this._namingHelper.getSetterName(sourceAttr);
                _builder.append(_setterName);
                _builder.append("(o);");
                _builder.newLineIfNotEmpty();
              }
            };
            this._jvmTypesBuilder.setBody(it, _client_2);
          }
        }
      };
      JvmOperation _method_1 = this._jvmTypesBuilder.toMethod(targetMT, this._namingHelper.getSetterName(targetAttr), 
        this.typeRefBuilder.typeRef(Void.TYPE), _function_1);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
  }

  /**
   * sourceRef != null means we can use getter/setter
   */
  private void processReference(final EReference sourceRef, final EReference targetRef, final Metamodel sourceModel, final ModelType targetMT, final JvmGenericType jvmCls) {
    final JvmTypeReference refType = this._melangeTypesBuilder.typeRef(targetMT, targetRef, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls)));
    final String mapName = this._namingHelper.mapperNameFor(sourceModel, targetMT, targetRef.getEReferenceType());
    boolean _isEMFMapDetails = this._ecoreExtensions.isEMFMapDetails(targetRef);
    if (_isEMFMapDetails) {
      EList<JvmMember> _members = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function = (JvmOperation it) -> {
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return adaptee.getDetails();");
          }
        };
        this._jvmTypesBuilder.setBody(it, _client);
      };
      JvmOperation _method = this._jvmTypesBuilder.toMethod(targetMT, "getDetails", 
        this.typeRefBuilder.typeRef(EMap.class, this.typeRefBuilder.typeRef(String.class), this.typeRefBuilder.typeRef(String.class)), _function);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    } else {
      EList<JvmMember> _members_1 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_1 = (JvmOperation it) -> {
        if ((sourceRef == null)) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("throw new UnsupportedOperationException");
              _builder.append("(\"This method is not mapped\");");
              _builder.newLine();
            }
          };
          this._jvmTypesBuilder.setBody(it, _client);
        } else {
          final String mapperName = this._namingHelper.simpleMapperNameFor(sourceModel, targetMT, 
            targetRef.getEReferenceType());
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              {
                boolean _isMany = targetRef.isMany();
                if (_isMany) {
                  _builder.append("return ");
                  _builder.append(EListAdapter.class);
                  _builder.append(".newInstance(adaptee.");
                  String _getterName = MetaclassMapperInferrer.this._namingHelper.getGetterName(sourceRef);
                  _builder.append(_getterName);
                  _builder.append("(), ");
                  _builder.append(mapName);
                  _builder.append(".class);");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("return adaptersFactory.create");
                  _builder.append(mapperName);
                  _builder.append("(adaptee.");
                  String _getterName_1 = MetaclassMapperInferrer.this._namingHelper.getGetterName(sourceRef);
                  _builder.append(_getterName_1);
                  _builder.append("());");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          };
          this._jvmTypesBuilder.setBody(it, _client_1);
        }
      };
      JvmOperation _method_1 = this._jvmTypesBuilder.toMethod(targetMT, this._namingHelper.getGetterName(targetRef), refType, _function_1);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
    boolean _needsSetterImplementation = this._ecoreExtensions.needsSetterImplementation(targetRef);
    if (_needsSetterImplementation) {
      EList<JvmMember> _members_2 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_2 = (JvmOperation it) -> {
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmFormalParameter _parameter = this._jvmTypesBuilder.toParameter(targetMT, "o", refType);
        this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        if ((sourceRef == null)) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("throw new UnsupportedOperationException");
              _builder.append("(\"This method is not mapped\");");
              _builder.newLine();
            }
          };
          this._jvmTypesBuilder.setBody(it, _client);
        } else {
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("adaptee.");
              String _setterName = MetaclassMapperInferrer.this._namingHelper.getSetterName(sourceRef);
              _builder.append(_setterName);
              _builder.append("(((");
              _builder.append(mapName);
              _builder.append(") o)");
              _builder.append(".getAdaptee());");
              _builder.newLineIfNotEmpty();
            }
          };
          this._jvmTypesBuilder.setBody(it, _client_1);
        }
      };
      JvmOperation _method_2 = this._jvmTypesBuilder.toMethod(targetMT, this._namingHelper.getSetterName(targetRef), this.typeRefBuilder.typeRef(Void.TYPE), _function_2);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
    }
  }

  private void processOperation(final EOperation op, final ModelType targetMT, final JvmGenericType jvmCls) {
    String _xifexpression = null;
    boolean _isUml = this._ecoreExtensions.isUml(op.getEContainingClass().getEPackage());
    boolean _not = (!_isUml);
    if (_not) {
      _xifexpression = op.getName();
    } else {
      _xifexpression = this._namingHelper.formatUmlOperationName(op);
    }
    final String opName = _xifexpression;
    final Procedure1<JvmOperation> _function = (JvmOperation m) -> {
      final Consumer<ETypeParameter> _function_1 = (ETypeParameter t) -> {
        EList<JvmTypeParameter> _typeParameters = m.getTypeParameters();
        JvmTypeParameter _createJvmTypeParameter = TypesFactory.eINSTANCE.createJvmTypeParameter();
        final Procedure1<JvmTypeParameter> _function_2 = (JvmTypeParameter tp) -> {
          tp.setName(t.getName());
        };
        JvmTypeParameter _doubleArrow = ObjectExtensions.<JvmTypeParameter>operator_doubleArrow(_createJvmTypeParameter, _function_2);
        this._jvmTypesBuilder.<JvmTypeParameter>operator_add(_typeParameters, _doubleArrow);
      };
      op.getETypeParameters().forEach(_function_1);
      final Consumer<ETypeParameter> _function_2 = (ETypeParameter t) -> {
        final Consumer<EGenericType> _function_3 = (EGenericType b) -> {
          final Function1<JvmTypeParameter, Boolean> _function_4 = (JvmTypeParameter it) -> {
            String _name = it.getName();
            String _name_1 = t.getName();
            return Boolean.valueOf(Objects.equal(_name, _name_1));
          };
          final JvmTypeParameter tp = IterableExtensions.<JvmTypeParameter>findFirst(m.getTypeParameters(), _function_4);
          EClassifier _eClassifier = b.getEClassifier();
          boolean _tripleNotEquals = (_eClassifier != null);
          if (_tripleNotEquals) {
            EList<JvmTypeConstraint> _constraints = tp.getConstraints();
            JvmUpperBound _createJvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            final Procedure1<JvmUpperBound> _function_5 = (JvmUpperBound it) -> {
              it.setTypeReference(this._melangeTypesBuilder.typeRef(targetMT, b, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, jvmCls))));
            };
            JvmUpperBound _doubleArrow = ObjectExtensions.<JvmUpperBound>operator_doubleArrow(_createJvmUpperBound, _function_5);
            this._jvmTypesBuilder.<JvmTypeConstraint>operator_add(_constraints, _doubleArrow);
          } else {
            ETypeParameter _eTypeParameter = b.getETypeParameter();
            boolean _tripleNotEquals_1 = (_eTypeParameter != null);
            if (_tripleNotEquals_1) {
              EList<JvmTypeConstraint> _constraints_1 = tp.getConstraints();
              JvmUpperBound _createJvmUpperBound_1 = TypesFactory.eINSTANCE.createJvmUpperBound();
              final Procedure1<JvmUpperBound> _function_6 = (JvmUpperBound it) -> {
                it.setTypeReference(this._melangeTypesBuilder.createTypeParameterReference(
                  new JvmTypeParameterDeclarator[] { m, jvmCls }, b.getETypeParameter().getName()));
              };
              JvmUpperBound _doubleArrow_1 = ObjectExtensions.<JvmUpperBound>operator_doubleArrow(_createJvmUpperBound_1, _function_6);
              this._jvmTypesBuilder.<JvmTypeConstraint>operator_add(_constraints_1, _doubleArrow_1);
            }
          }
        };
        t.getEBounds().forEach(_function_3);
      };
      op.getETypeParameters().forEach(_function_2);
      final Consumer<EParameter> _function_3 = (EParameter p) -> {
        EList<JvmFormalParameter> _parameters = m.getParameters();
        JvmFormalParameter _parameter = this._jvmTypesBuilder.toParameter(op, p.getName(), 
          this._melangeTypesBuilder.typeRef(targetMT, p, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, jvmCls))));
        this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
      };
      op.getEParameters().forEach(_function_3);
      final Consumer<EClassifier> _function_4 = (EClassifier e) -> {
        EList<JvmTypeReference> _exceptions = m.getExceptions();
        String _xifexpression_1 = null;
        Class<?> _instanceClass = e.getInstanceClass();
        boolean _tripleNotEquals = (_instanceClass != null);
        if (_tripleNotEquals) {
          _xifexpression_1 = e.getInstanceClass().getName();
        } else {
          _xifexpression_1 = e.getInstanceTypeName();
        }
        JvmTypeReference _typeRef = this.typeRefBuilder.typeRef(_xifexpression_1);
        this._jvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
      };
      op.getEExceptions().forEach(_function_4);
      final Consumer<EGenericType> _function_5 = (EGenericType e) -> {
      };
      op.getEGenericExceptions().forEach(_function_5);
      StringConcatenationClient _client = new StringConcatenationClient() {
        @Override
        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
          _builder.append("throw new UnsupportedOperationException");
          _builder.append("(\"This method is not mapped\");");
          _builder.newLine();
        }
      };
      this._jvmTypesBuilder.setBody(m, _client);
    };
    final JvmOperation newOp = this._jvmTypesBuilder.toMethod(op, opName, null, _function);
    newOp.setReturnType(this._melangeTypesBuilder.typeRef(targetMT, op, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(newOp, jvmCls))));
    EList<JvmMember> _members = jvmCls.getMembers();
    this._jvmTypesBuilder.<JvmOperation>operator_add(_members, newOp);
  }
}
