/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFixCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.text.edits.TextEditGroup;

public class SubstringCleanUpCore
extends AbstractMultiFixCore {
    public SubstringCleanUpCore() {
        this(Collections.emptyMap());
    }

    public SubstringCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        boolean requireAST = this.isEnabled("cleanup.substring");
        return new CleanUpRequirementsCore(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.substring")) {
            return new String[]{MultiFixMessages.SubstringCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.substring")) {
            return "String shortenedText = text.substring(2);\n";
        }
        return "String shortenedText = text.substring(2, text.length());\n";
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.substring")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation visited) {
                MethodInvocation endIndex;
                if (ASTNodes.usesGivenSignature(visited, String.class.getCanonicalName(), "substring", Integer.TYPE.getCanonicalName(), Integer.TYPE.getCanonicalName()) && (endIndex = ASTNodes.as((Expression)visited.arguments().get(1), MethodInvocation.class)) != null && endIndex.getExpression() != null && ASTNodes.usesGivenSignature(endIndex, String.class.getCanonicalName(), "length", new String[0]) && ASTNodes.match((ASTNode)visited.getExpression(), (ASTNode)endIndex.getExpression()) && ASTNodes.isPassive((ASTNode)visited.getExpression())) {
                    rewriteOperations.add(new SubstringOperation(visited));
                    return false;
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.SubstringCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    @Override
    public ICleanUpFixCore createFix(CompilationUnit unit, IProblemLocationCore[] problems) throws CoreException {
        return this.createFix(unit);
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocationCore problem) {
        return false;
    }

    private static class SubstringOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final MethodInvocation visited;

        public SubstringOperation(MethodInvocation visited) {
            this.visited = visited;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.SubstringCleanUp_description, cuRewrite);
            rewrite.remove((ASTNode)this.visited.arguments().get(1), group);
        }
    }
}

